//
// Software License for MTL
// 
// Copyright (c) 2001-2005 The Trustees of Indiana University. All rights reserved.
// Copyright (c) 1998-2001 University of Notre Dame. All rights reserved.
// Authors: Andrew Lumsdaine, Jeremy G. Siek, Lie-Quan Lee
// 
// This file is part of the Matrix Template Library
// 
// See also license.mtl.txt in the distribution.

#include <iostream>
#include <mtl/matrix.h>

int
main()
{
#ifdef MTL_DISABLE_BLOCKING
  std::cout << "Static blocking unsupported for this compiler" << std::endl;
#else
  using namespace mtl;
  //begin
  const int M = 4;
  const int N = 4;
  typedef matrix<double,
                 rectangle<>, 
                 dense<>, 
                 column_major >::type Matrix;
  Matrix A(M,N);

  for (int i = 0; i < M; ++i)
    for (int j = 0; j < N; ++j)
      A(i, j) = i * N + j;
  print_all_matrix(A);

  block_view<Matrix,2,2>::type
                     bA = blocked(A, blk<2,2>());
  print_partitioned_matrix(bA);

  block_view<Matrix>::type cA = blocked(A, 2, 2);
  print_partitioned_by_column(cA);
  //end
  return 0;
#endif
}
