/*
 * Decompiled with CFR 0.152.
 */
package free.jin;

import free.jin.Connection;
import free.jin.ConnectionDetails;
import free.jin.Jin;
import free.jin.Preferences;
import free.jin.Server;
import free.jin.User;
import free.jin.action.ActionContext;
import free.jin.action.ActionInfo;
import free.jin.action.JinAction;
import free.jin.event.ConnectionListener;
import free.jin.plugin.Plugin;
import free.jin.plugin.PluginContext;
import free.jin.plugin.PluginInfo;
import free.jin.plugin.PluginStartException;
import java.io.IOException;
import java.util.Vector;

public class Session {
    private final ConnectionDetails connDetails;
    private final Connection conn;
    private boolean isClosed = false;
    private final JinAction[] actions;
    private final Plugin[] plugins;
    private PluginContext pluginContext;
    private int port = -1;

    public Session(ConnectionDetails connectionDetails) throws PluginStartException {
        if (connectionDetails == null) {
            throw new IllegalArgumentException("connDetails may not be null");
        }
        this.connDetails = connectionDetails;
        this.conn = connectionDetails.getServer().createConnection(connectionDetails);
        this.actions = this.createActions();
        this.plugins = this.createPlugins();
    }

    private JinAction[] createActions() throws PluginStartException {
        ActionInfo[] actionInfoArray = Jin.getInstance().getActions(this.getServer());
        Vector<JinAction> vector = new Vector<JinAction>(actionInfoArray.length);
        for (int i = 0; i < actionInfoArray.length; ++i) {
            JinAction jinAction;
            ActionInfo actionInfo = actionInfoArray[i];
            Class clazz = actionInfo.getActionClass();
            Preferences preferences = actionInfo.getActionPreferences();
            try {
                jinAction = (JinAction)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new PluginStartException(instantiationException, "Unable to instantiate " + clazz);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PluginStartException(illegalAccessException, "Unable to instantiate " + clazz);
            }
            ActionContext actionContext = new ActionContext(this.conn, this.getUser(), preferences);
            if (jinAction.setContext(actionContext)) {
                vector.addElement(jinAction);
                continue;
            }
            System.err.println("Warning: unsupported action not created - " + jinAction.getId());
        }
        Object[] objectArray = new JinAction[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private Plugin[] createPlugins() throws PluginStartException {
        int n;
        PluginInfo[] pluginInfoArray = Jin.getInstance().getPlugins(this.getServer());
        Plugin[] pluginArray = new Plugin[pluginInfoArray.length];
        Preferences[] preferencesArray = new Preferences[pluginInfoArray.length];
        for (n = 0; n < preferencesArray.length; ++n) {
            preferencesArray[n] = pluginInfoArray[n].getPluginPreferences();
        }
        for (n = 0; n < pluginArray.length; ++n) {
            Class clazz = pluginInfoArray[n].getPluginClass();
            try {
                pluginArray[n] = (Plugin)clazz.newInstance();
                continue;
            }
            catch (InstantiationException instantiationException) {
                throw new PluginStartException(instantiationException, "Unable to instantiate " + clazz);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PluginStartException(illegalAccessException, "Unable to instantiate " + clazz);
            }
        }
        this.pluginContext = new PluginContext(this.conn, this.getUser(), pluginArray, preferencesArray, this.actions);
        this.pluginContext.setAndStart();
        return this.pluginContext.getPlugins();
    }

    public ConnectionDetails getConnDetails() {
        return this.connDetails;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public Server getServer() {
        return this.getUser().getServer();
    }

    public User getUser() {
        return this.connDetails.getUser();
    }

    public synchronized Plugin[] getPlugins() {
        return this.plugins == null ? null : (Plugin[])this.plugins.clone();
    }

    public PluginContext getPluginContext() {
        return this.pluginContext;
    }

    synchronized void initiateLogin() {
        if (this.conn.isConnected()) {
            throw new IllegalArgumentException("Session already logged in");
        }
        if (this.isClosed) {
            throw new IllegalArgumentException("Session already closed - can't reuse session");
        }
        new ConnectionInitializer(this.connDetails.getHost(), this.connDetails.getPorts()).go();
    }

    public boolean isConnected() {
        return this.conn.isConnected();
    }

    public synchronized void close() {
        int n;
        for (n = 0; n < this.plugins.length; ++n) {
            this.plugins[n].saveState();
        }
        for (n = 0; n < this.plugins.length; ++n) {
            this.plugins[n].stop();
        }
        try {
            if (this.conn.isConnected()) {
                this.conn.exit();
            }
            this.conn.close();
        }
        catch (IOException iOException) {
            System.err.println("Failed to disconnect connection: " + this.conn);
            iOException.printStackTrace();
        }
        this.isClosed = true;
    }

    private class ConnectionInitializer
    implements ConnectionListener {
        private final String hostname;
        private final int[] ports;
        private final String[] errorMessages;
        private int portIndex = 0;

        public ConnectionInitializer(String string, int[] nArray) {
            this.hostname = string;
            this.ports = nArray;
            this.errorMessages = new String[nArray.length];
        }

        public void go() {
            Session.this.conn.getListenerManager().addConnectionListener(this);
            Session.this.conn.initiateConnectAndLogin(this.hostname, this.ports[this.portIndex]);
        }

        public void connectingFailed(Connection connection, String string) {
            this.errorMessages[this.portIndex] = string;
            if (this.portIndex == this.ports.length - 1) {
                for (int i = 0; i < Session.this.plugins.length; ++i) {
                    Session.this.plugins[i].stop();
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.errorMessages.length; ++i) {
                    stringBuffer.append("Port " + this.ports[i] + ": " + this.errorMessages[i] + "\n");
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
                Jin.getInstance().getConnManager().loginFailed(stringBuffer.toString());
            } else {
                ++this.portIndex;
                connection.initiateConnectAndLogin(this.hostname, this.ports[this.portIndex]);
            }
        }

        public void loginFailed(Connection connection, String string) {
            for (int i = 0; i < Session.this.plugins.length; ++i) {
                Session.this.plugins[i].stop();
            }
            Jin.getInstance().getConnManager().loginFailed(string);
        }

        public void loginSucceeded(Connection connection) {
            connection.getListenerManager().removeConnectionListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionEstablished(Connection connection) {
            Session session = Session.this;
            synchronized (session) {
                Session.this.port = this.ports[this.portIndex];
            }
        }

        public void connectionAttempted(Connection connection, String string, int n) {
        }

        public void connectionLost(Connection connection) {
        }
    }
}

