/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import com.google.protobuf.ByteString;
import com.martiansoftware.jsap.JSAPResult;
import edu.cornell.med.icb.identifier.DoubleIndexedIdentifier;
import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.campagnelab.goby.alignments.AlignmentReaderFactory;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.ConcatSortedAlignmentReader;
import org.campagnelab.goby.alignments.DefaultAlignmentReaderFactory;
import org.campagnelab.goby.alignments.PositionToBasesMap;
import org.campagnelab.goby.alignments.processors.AlignmentProcessorFactory;
import org.campagnelab.goby.alignments.processors.AlignmentProcessorInterface;
import org.campagnelab.goby.alignments.processors.DefaultAlignmentProcessorFactory;
import org.campagnelab.goby.reads.RandomAccessSequenceInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IterateSortedAlignments<T> {
    private static final Logger LOG = LoggerFactory.getLogger(IterateSortedAlignments.class);
    private boolean filterByReferenceNames;
    private ObjectSet<String> includeReferenceNames = new ObjectOpenHashSet();
    private DoubleIndexedIdentifier referenceIds;
    protected int lastRemovedPosition = -1;
    private int numAlignmentEntries;
    private String startOffsetArgument;
    private String endOffsetArgument;
    private int startFlapLength;
    public int maxThreshold = 500000;
    private AlignmentReaderFactory alignmentReaderFactory = new DefaultAlignmentReaderFactory();
    protected int[] alignmentToGenomeTargetIndices;
    protected boolean useWindow;
    private AlignmentProcessorFactory alignmentProcessorFactory = new DefaultAlignmentProcessorFactory();
    protected int startPosition;
    protected int endPosition;
    protected int startReferenceIndex;
    protected int endReferenceIndex;
    IntArrayList tmpPositions = new IntArrayList();

    public void setMaxThreshold(int maxThreshold) {
        this.maxThreshold = maxThreshold;
    }

    public void setAlignmentProcessorFactory(AlignmentProcessorFactory alignmentProcessorFactory) {
        this.alignmentProcessorFactory = alignmentProcessorFactory;
    }

    public void setStartFlapLength(int length) {
        this.startFlapLength = length;
    }

    public void parseIncludeReferenceArgument(JSAPResult jsapResult) {
        String includeReferenceNameCommas = jsapResult.getString("include-reference-names");
        this.parseIncludeReferenceArgument(includeReferenceNameCommas);
        this.startOffsetArgument = jsapResult.getString("start-position");
        this.endOffsetArgument = jsapResult.getString("end-position");
        if (this.startOffsetArgument != null && this.endOffsetArgument == null || this.endOffsetArgument != null && this.startOffsetArgument == null) {
            System.err.println("Start (-s) and end offset (-e) arguments must be specified together or not at all.");
            System.exit(1);
        }
    }

    public void setStartPositionArgument(String arg) {
        this.startOffsetArgument = arg;
    }

    public void setAlignmentReaderFactory(AlignmentReaderFactory factory) {
        this.alignmentReaderFactory = factory;
    }

    public void setEndPositionArgument(String arg) {
        this.endOffsetArgument = arg;
    }

    public void parseIncludeReferenceArgument(String includeReferenceNameCommas) {
        if (includeReferenceNameCommas != null) {
            this.includeReferenceNames = new ObjectOpenHashSet();
            this.includeReferenceNames.addAll(Arrays.asList(includeReferenceNameCommas.split("[,]")));
            LOG.info("Will iterate through the following sequences:");
            for (String name : this.includeReferenceNames) {
                System.out.println(name);
            }
            this.filterByReferenceNames = true;
        }
    }

    public int getNumAlignmentEntries() {
        return this.numAlignmentEntries;
    }

    public boolean isWithinStartFlap(int referenceIndex, int position) {
        return referenceIndex == this.startReferenceIndex && position >= this.startPosition - this.startFlapLength && position < this.startPosition;
    }

    public void iterate(String ... basenames) throws IOException {
        Alignments.AlignmentEntry alignmentEntry;
        ConcatSortedAlignmentReader sortedReaders = new ConcatSortedAlignmentReader(false, basenames);
        this.checkGenomeMatchAlignment(sortedReaders, this.getGenome());
        int numberOfReferences = sortedReaders.getNumberOfTargets();
        this.referenceIds = new DoubleIndexedIdentifier(sortedReaders.getTargetIdentifiers());
        if (this.referenceIds == null) {
            this.filterByReferenceNames = false;
        }
        sortedReaders.close();
        LOG.info(String.format("Alignment contains %d reference sequences", numberOfReferences));
        this.processNumberOfReferences(numberOfReferences);
        IntLinkedOpenHashSet referencesToProcess = new IntLinkedOpenHashSet();
        for (int referenceIndex = 0; referenceIndex < numberOfReferences; ++referenceIndex) {
            if (this.filterByReferenceNames) {
                MutableString referenceId = this.referenceIds.getId(referenceIndex);
                assert (referenceId != null) : "reference id cannot be null for reference index=" + referenceIndex;
                String referenceName = referenceId.toString();
                if (!this.includeReferenceNames.contains((Object)referenceName)) continue;
                referencesToProcess.add(referenceIndex);
                continue;
            }
            referencesToProcess.add(referenceIndex);
        }
        try {
            if (StringUtils.isEmpty((String)this.startOffsetArgument) && StringUtils.isEmpty((String)this.endOffsetArgument)) {
                sortedReaders = new ConcatSortedAlignmentReader(this.alignmentReaderFactory, false, basenames);
            } else {
                assert (this.isValidOffsetArgument(this.startOffsetArgument)) : "start offset must contain a coma or colon delimiter.";
                assert (this.isValidOffsetArgument(this.endOffsetArgument)) : "end offset must contain a coma delimiter.";
                String[] startTokens = this.startOffsetArgument.split("[:,]");
                String[] endTokens = this.endOffsetArgument.split("[:,]");
                this.startPosition = Integer.parseInt(startTokens[1]);
                this.endPosition = Integer.parseInt(endTokens[1]);
                this.startReferenceIndex = this.referenceIds.getIndex(startTokens[0]);
                this.endReferenceIndex = this.referenceIds.getIndex(endTokens[0]);
                if (this.startReferenceIndex == -1 || this.endReferenceIndex == -1) {
                    String message = String.format("One of the reference identifier specified for start and end limits does not exist %s %s. ", startTokens[0], endTokens[0]);
                    LOG.error(message);
                    throw new IllegalArgumentException(message);
                }
                this.useWindow = true;
                sortedReaders = new ConcatSortedAlignmentReader(this.alignmentReaderFactory, false, basenames, this.startReferenceIndex, Math.max(0, this.startPosition - this.startFlapLength), this.endReferenceIndex, this.endPosition);
                int numRefs = referencesToProcess.size();
                for (int referenceIndex = 0; referenceIndex < numRefs; ++referenceIndex) {
                    if (referenceIndex >= this.startReferenceIndex && referenceIndex <= this.endReferenceIndex) continue;
                    referencesToProcess.rem(referenceIndex);
                }
                assert (!referencesToProcess.contains(this.startReferenceIndex - 1)) : "internal error";
                assert (!referencesToProcess.contains(this.endReferenceIndex + 1)) : "internal error";
            }
        }
        catch (NumberFormatException e) {
            System.err.println("An error occured parsing --start-position or --end-position. These arguments expect \na string in the format ref-id,ref-position, where ref-id is a reference identifier \nstring and ref-position in an integer that encodes a position within the reference sequence.");
            throw e;
        }
        sortedReaders.setAdjustSampleIndices(true);
        int currentMinTargetIndex = referencesToProcess.firstInt();
        int lastPosition = -1;
        int lastTarget = -1;
        PositionToBasesMap positionToBases = new PositionToBasesMap();
        boolean first = true;
        ProgressLogger pg = new ProgressLogger(LOG);
        pg.displayFreeMemory = true;
        pg.itemsName = "aligned reads";
        pg.start();
        AlignmentProcessorInterface realigner = this.alignmentProcessorFactory.create(sortedReaders);
        realigner.setGenome(this.getGenome(), sortedReaders.getTargetIdentifiers());
        int currentPosition = this.startPosition;
        while ((alignmentEntry = realigner.nextRealignedEntry(currentMinTargetIndex, currentPosition)) != null) {
            boolean forwardStrand;
            pg.lightUpdate();
            this.numAlignmentEntries = this.advanceReference(this.numAlignmentEntries);
            final int referenceIndex = alignmentEntry.getTargetIndex();
            if (lastTarget != -1 && referenceIndex != lastTarget) {
                this.processAllPreviousPositions(lastTarget, positionToBases);
            }
            int queryLength = alignmentEntry.getQueryLength();
            assert (queryLength != 0) : "queryLength should never be zero";
            currentPosition = alignmentEntry.getPosition();
            boolean bl = forwardStrand = !alignmentEntry.getMatchingReverseStrand();
            if (this.lastRemovedPosition == -1) {
                this.lastRemovedPosition = currentPosition - 1;
            }
            if (!first && currentPosition != lastPosition) {
                this.processAndCleanup(referenceIndex, lastPosition, positionToBases);
                lastPosition = currentPosition;
            }
            first = false;
            assert (queryLength != 0) : "queryLength cannot be zero to iterate sorted alignments.";
            int currentReadIndex = forwardStrand ? 0 : queryLength + 1;
            int currentRefPosition = alignmentEntry.getPosition() - alignmentEntry.getQueryPosition();
            int numInsertions = 0;
            int numDeletions = 0;
            List<Alignments.SequenceVariation> seqVars = alignmentEntry.getSequenceVariationsList();
            for (Alignments.SequenceVariation var : seqVars) {
                String from = var.getFrom();
                int fromLength = from.length();
                String to = var.getTo();
                int toLength = to.length();
                int sequenceVariationLength = Math.max(fromLength, toLength);
                for (int i = 0; i < sequenceVariationLength; ++i) {
                    int toChar;
                    int fromChar = i >= fromLength ? 45 : (int)from.charAt(i);
                    int n = toChar = i >= toLength ? 45 : (int)to.charAt(i);
                    if (fromChar == 45) {
                        ++numInsertions;
                    }
                    if (toChar != 45) continue;
                    ++numDeletions;
                }
            }
            int leftPadding = alignmentEntry.getQueryPosition();
            int rightPadding = Math.max(0, queryLength + numDeletions - (alignmentEntry.getTargetAlignedLength() + numInsertions) - leftPadding);
            if (leftPadding > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("queryIndex=%d, left padding, %d bases", alignmentEntry.getQueryIndex(), leftPadding));
                }
                for (int i = 0; i < leftPadding; ++i) {
                    currentReadIndex = this.advanceReadIndex(forwardStrand, currentReadIndex);
                    currentRefPosition = this.advanceReference(currentRefPosition);
                }
            }
            int numObservedBases = 0;
            for (Alignments.SequenceVariation var : seqVars) {
                int i;
                String to = var.getTo();
                String from = var.getFrom();
                ByteString qualityScores = var.getToQuality();
                int fromLength = from.length();
                int toLength = to.length();
                int qualLength = qualityScores.size();
                int sequenceVariationLength = Math.max(fromLength, toLength);
                int preSeqvarBases = from.charAt(0) == '-' ? var.getPosition() - numObservedBases : var.getPosition() - numObservedBases - 1;
                for (i = 0; i < preSeqvarBases; ++i) {
                    currentReadIndex = this.advanceReadIndex(forwardStrand, currentReadIndex);
                    currentRefPosition = this.advanceReference(currentRefPosition);
                    this.observeReferenceBase(sortedReaders, alignmentEntry, positionToBases, referenceIndex, currentRefPosition, currentReadIndex);
                    ++numObservedBases;
                }
                for (i = 0; i < sequenceVariationLength; ++i) {
                    char toChar = i >= toLength ? (char)'-' : (char)to.charAt(i);
                    char fromChar = i >= fromLength ? (char)'-' : (char)from.charAt(i);
                    byte toQual = i >= qualLength ? (byte)0 : qualityScores.byteAt(i);
                    boolean isIndel = false;
                    if (fromChar == '-') {
                        isIndel = true;
                    } else {
                        ++numObservedBases;
                        currentRefPosition = this.advanceReference(currentRefPosition);
                    }
                    if (toChar == '-') {
                        isIndel = true;
                        if (!forwardStrand && i == 0) {
                            currentReadIndex = this.advanceReadIndex(forwardStrand, currentReadIndex);
                        }
                    } else {
                        currentReadIndex = this.advanceReadIndex(forwardStrand, currentReadIndex);
                    }
                    if (!isIndel) {
                        this.observeVariantBase(sortedReaders, alignmentEntry, positionToBases, var, toChar, fromChar, toQual, referenceIndex, currentRefPosition, currentReadIndex);
                    }
                    if (toChar != 45 || forwardStrand || i != sequenceVariationLength - 1) continue;
                    currentReadIndex = this.advanceReadIndex(!forwardStrand, currentReadIndex);
                }
                if (!this.isInsertionOrDeletion(var)) continue;
                this.observeIndel(positionToBases, referenceIndex, alignmentEntry.getPosition() + var.getPosition() - 1, var.getFrom(), var.getTo(), alignmentEntry.getSampleIndex(), var.getReadIndex(), alignmentEntry);
            }
            while (forwardStrand ? currentReadIndex < queryLength - rightPadding : currentReadIndex > 1 + rightPadding) {
                currentReadIndex = this.advanceReadIndex(forwardStrand, currentReadIndex);
                currentRefPosition = this.advanceReference(currentRefPosition);
                assert (currentReadIndex >= 1 && currentReadIndex < queryLength + 1) : String.format("currentReadIndex %d is out of range.", currentReadIndex);
                this.observeReferenceBase(sortedReaders, alignmentEntry, positionToBases, referenceIndex, currentRefPosition, currentReadIndex);
            }
            if (rightPadding > 0) {
                LOG.debug(String.format("queryIndex=%d, right padding, %d bases", alignmentEntry.getQueryIndex(), rightPadding));
            }
            if (referencesToProcess.contains(referenceIndex)) {
                lastPosition = alignmentEntry.getPosition();
                lastTarget = alignmentEntry.getTargetIndex();
            }
            if (referenceIndex <= currentMinTargetIndex) continue;
            boolean success = referencesToProcess.remove(currentMinTargetIndex);
            assert (success) : "removing an element from referencesToProcess must succeed. ";
            if (referencesToProcess.isEmpty()) break;
            referencesToProcess.removeIf((Predicate)new Predicate<Integer>(){

                @Override
                public boolean test(Integer value) {
                    return value < referenceIndex;
                }
            });
            currentMinTargetIndex = referencesToProcess.firstInt();
        }
        int minPos = Integer.MAX_VALUE;
        int maxPos = Integer.MIN_VALUE;
        IntIterator forwardStrand = positionToBases.keySet().iterator();
        while (forwardStrand.hasNext()) {
            int pos = (Integer)forwardStrand.next();
            minPos = Math.min(pos, minPos);
            maxPos = Math.max(pos, maxPos);
        }
        for (int position = minPos; position <= maxPos; ++position) {
            this.processAndCleanup(lastTarget, position, positionToBases);
        }
        sortedReaders.close();
        pg.stop();
    }

    protected boolean isValidOffsetArgument(String offsetArgument) {
        return offsetArgument.contains(",") | offsetArgument.contains(":");
    }

    private boolean isInsertionOrDeletion(Alignments.SequenceVariation var) {
        return var.getFrom().indexOf(45) >= 0 || var.getTo().indexOf(45) >= 0;
    }

    protected void checkGenomeMatchAlignment(ConcatSortedAlignmentReader sortedReaders, RandomAccessSequenceInterface genome) {
        if (genome == null) {
            return;
        }
        try {
            sortedReaders.readHeader();
        }
        catch (IOException e) {
            LOG.error("Failed to read alignment header, aborting", (Throwable)e);
            throw new RuntimeException(e);
        }
        int numTargets = sortedReaders.getNumberOfTargets();
        this.alignmentToGenomeTargetIndices = new int[numTargets];
        int[] alignmentTargetLengths = sortedReaders.getTargetLength();
        IndexedIdentifier alignmentTargetIds = sortedReaders.getTargetIdentifiers();
        DoubleIndexedIdentifier alignmentReverseIds = new DoubleIndexedIdentifier(alignmentTargetIds);
        for (int targetIndex = 0; targetIndex < numTargets; ++targetIndex) {
            MutableString targetId = alignmentReverseIds.getId(targetIndex);
            int genomeTargetIndex = genome.getReferenceIndex(targetId.toString());
            if (genomeTargetIndex == -1) {
                LOG.error(String.format("Alignment reference %s index (%d) was not found in the genome.", targetId, targetIndex));
                continue;
            }
            int alignmentTargetLength = alignmentTargetLengths[targetIndex];
            int genomeLength = genome.getLength(genomeTargetIndex);
            if (alignmentTargetLength != genomeLength) {
                LOG.error(String.format("Genome reference %s length (%d) differs from alignment reference length (%d) for sequence %s at index %d", genome.getReferenceName(targetIndex), genomeLength, alignmentTargetLength, alignmentReverseIds.getId(targetIndex), targetIndex));
            }
            this.alignmentToGenomeTargetIndices[targetIndex] = genomeTargetIndex;
        }
    }

    private int advanceReadIndex(boolean forwardStrand, int currentReadIndex) {
        return currentReadIndex += forwardStrand ? 1 : -1;
    }

    private int advanceReference(int currentRefPosition) {
        return ++currentRefPosition;
    }

    private void processAndCleanup(int lastReferenceIndex, int lastPosition, PositionToBasesMap<T> positionToBases) {
        int intermediatePosition;
        if (positionToBases.isEmpty()) {
            return;
        }
        while (!positionToBases.isEmpty() && (intermediatePosition = positionToBases.firstPosition()) <= lastPosition) {
            if (!positionToBases.containsKey(intermediatePosition)) continue;
            this.processPositions(lastReferenceIndex, intermediatePosition, positionToBases.get(intermediatePosition));
            positionToBases.remove(intermediatePosition);
            lastPosition = Math.max(intermediatePosition, lastPosition);
        }
        this.lastRemovedPosition = lastPosition;
    }

    private void processAllPreviousPositions(int lastReferenceIndex, PositionToBasesMap positionToBases) {
        this.tmpPositions.clear();
        this.tmpPositions.addAll((IntCollection)positionToBases.keySet());
        Collections.sort(this.tmpPositions);
        IntListIterator intListIterator = this.tmpPositions.iterator();
        while (intListIterator.hasNext()) {
            int intermediatePosition = (Integer)intListIterator.next();
            if (!positionToBases.containsKey(intermediatePosition)) continue;
            this.processPositions(lastReferenceIndex, intermediatePosition, positionToBases.get(intermediatePosition));
            positionToBases.remove(intermediatePosition);
            this.lastRemovedPosition = intermediatePosition;
        }
        positionToBases.clear();
        this.lastRemovedPosition = -1;
    }

    public abstract void observeReferenceBase(ConcatSortedAlignmentReader var1, Alignments.AlignmentEntry var2, PositionToBasesMap<T> var3, int var4, int var5, int var6);

    public abstract void observeVariantBase(ConcatSortedAlignmentReader var1, Alignments.AlignmentEntry var2, PositionToBasesMap<T> var3, Alignments.SequenceVariation var4, char var5, char var6, byte var7, int var8, int var9, int var10);

    public abstract void processPositions(int var1, int var2, T var3);

    public void observeIndel(PositionToBasesMap<T> positionToBases, int referenceIndex, int startPosition, String from, String to, int sampleIndex, int readIndex, Alignments.AlignmentEntry alignmentEntry) {
    }

    public void processNumberOfReferences(int numberOfReferences) throws IOException {
    }

    public CharSequence getReferenceId(int targetIndex) {
        return this.referenceIds.getId(targetIndex);
    }

    public RandomAccessSequenceInterface getGenome() {
        return null;
    }
}

