/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.indexlifecycle.CloseFollowerIndexStep;
import org.elasticsearch.xpack.core.indexlifecycle.LifecycleAction;
import org.elasticsearch.xpack.core.indexlifecycle.OpenFollowerIndexStep;
import org.elasticsearch.xpack.core.indexlifecycle.PauseFollowerIndexStep;
import org.elasticsearch.xpack.core.indexlifecycle.Step;
import org.elasticsearch.xpack.core.indexlifecycle.UnfollowFollowIndexStep;
import org.elasticsearch.xpack.core.indexlifecycle.WaitForFollowShardTasksStep;
import org.elasticsearch.xpack.core.indexlifecycle.WaitForIndexingCompleteStep;
import org.elasticsearch.xpack.core.indexlifecycle.WaitForYellowStep;

public final class UnfollowAction
implements LifecycleAction {
    public static final String NAME = "unfollow";
    public static final String CCR_METADATA_KEY = "ccr";
    private static final ObjectParser<UnfollowAction, Void> PARSER = new ObjectParser("unfollow", UnfollowAction::new);

    public UnfollowAction() {
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey indexingComplete = new Step.StepKey(phase, NAME, "wait-for-indexing-complete");
        Step.StepKey waitForFollowShardTasks = new Step.StepKey(phase, NAME, "wait-for-follow-shard-tasks");
        Step.StepKey pauseFollowerIndex = new Step.StepKey(phase, NAME, "pause-follower-index");
        Step.StepKey closeFollowerIndex = new Step.StepKey(phase, NAME, "close-follower-index");
        Step.StepKey unfollowFollowerIndex = new Step.StepKey(phase, NAME, "unfollow-follower-index");
        Step.StepKey openFollowerIndex = new Step.StepKey(phase, NAME, "open-follower-index");
        Step.StepKey waitForYellowStep = new Step.StepKey(phase, NAME, "wait-for-yellow-step");
        WaitForIndexingCompleteStep step1 = new WaitForIndexingCompleteStep(indexingComplete, waitForFollowShardTasks);
        WaitForFollowShardTasksStep step2 = new WaitForFollowShardTasksStep(waitForFollowShardTasks, pauseFollowerIndex, client);
        PauseFollowerIndexStep step3 = new PauseFollowerIndexStep(pauseFollowerIndex, closeFollowerIndex, client);
        CloseFollowerIndexStep step4 = new CloseFollowerIndexStep(closeFollowerIndex, unfollowFollowerIndex, client);
        UnfollowFollowIndexStep step5 = new UnfollowFollowIndexStep(unfollowFollowerIndex, openFollowerIndex, client);
        OpenFollowerIndexStep step6 = new OpenFollowerIndexStep(openFollowerIndex, waitForYellowStep, client);
        WaitForYellowStep step7 = new WaitForYellowStep(waitForYellowStep, nextStepKey);
        return Arrays.asList(step1, step2, step3, step4, step5, step6, step7);
    }

    @Override
    public List<Step.StepKey> toStepKeys(String phase) {
        Step.StepKey indexingCompleteStep = new Step.StepKey(phase, NAME, "wait-for-indexing-complete");
        Step.StepKey waitForFollowShardTasksStep = new Step.StepKey(phase, NAME, "wait-for-follow-shard-tasks");
        Step.StepKey pauseFollowerIndexStep = new Step.StepKey(phase, NAME, "pause-follower-index");
        Step.StepKey closeFollowerIndexStep = new Step.StepKey(phase, NAME, "close-follower-index");
        Step.StepKey unfollowIndexStep = new Step.StepKey(phase, NAME, "unfollow-follower-index");
        Step.StepKey openFollowerIndexStep = new Step.StepKey(phase, NAME, "open-follower-index");
        Step.StepKey waitForYellowStep = new Step.StepKey(phase, NAME, "wait-for-yellow-step");
        return Arrays.asList(indexingCompleteStep, waitForFollowShardTasksStep, pauseFollowerIndexStep, closeFollowerIndexStep, unfollowIndexStep, openFollowerIndexStep, waitForYellowStep);
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    public String getWriteableName() {
        return NAME;
    }

    public UnfollowAction(StreamInput in) throws IOException {
    }

    public void writeTo(StreamOutput out) throws IOException {
    }

    public static UnfollowAction parse(XContentParser parser) {
        return (UnfollowAction)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return 36970;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.getClass();
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

