/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SoftDeletesDirectoryReaderWrapper;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.core.internal.io.IOUtils;

public class SourceOnlySnapshot {
    private final Directory targetDirectory;
    private final Supplier<Query> deleteByQuerySupplier;

    public SourceOnlySnapshot(Directory targetDirectory, Supplier<Query> deleteByQuerySupplier) {
        this.targetDirectory = targetDirectory;
        this.deleteByQuerySupplier = deleteByQuerySupplier;
    }

    public SourceOnlySnapshot(Directory targetDirectory) {
        this(targetDirectory, null);
    }

    public synchronized List<String> syncSnapshot(IndexCommit commit) throws IOException {
        String segmentFileName;
        long generation;
        HashMap<BytesRef, SegmentCommitInfo> existingSegments = new HashMap<BytesRef, SegmentCommitInfo>();
        if (Lucene.indexExists((Directory)this.targetDirectory)) {
            SegmentInfos existingsSegmentInfos = Lucene.readSegmentInfos((Directory)this.targetDirectory);
            for (SegmentCommitInfo info : existingsSegmentInfos) {
                existingSegments.put(new BytesRef(info.info.getId()), info);
            }
            generation = existingsSegmentInfos.getGeneration();
        } else {
            generation = 1L;
        }
        ArrayList<String> createdFiles = new ArrayList<String>();
        try (Lock writeLock = this.targetDirectory.obtainLock("write.lock");
             StandardDirectoryReader reader = (StandardDirectoryReader)DirectoryReader.open((IndexCommit)commit);){
            SegmentInfos segmentInfos = reader.getSegmentInfos().clone();
            DirectoryReader wrappedReader = this.wrapReader((DirectoryReader)reader);
            ArrayList<SegmentCommitInfo> newInfos = new ArrayList<SegmentCommitInfo>();
            for (LeafReaderContext ctx : wrappedReader.leaves()) {
                LeafReader leafReader = ctx.reader();
                SegmentCommitInfo info = Lucene.segmentReader((LeafReader)leafReader).getSegmentInfo();
                LiveDocs liveDocs = this.getLiveDocs(leafReader);
                if (leafReader.numDocs() == 0) continue;
                SegmentCommitInfo newInfo = this.syncSegment(info, liveDocs, leafReader.getFieldInfos(), existingSegments, createdFiles);
                newInfos.add(newInfo);
            }
            segmentInfos.clear();
            segmentInfos.addAll(newInfos);
            segmentInfos.setNextWriteGeneration(Math.max(segmentInfos.getGeneration(), generation) + 1L);
            String pendingSegmentFileName = IndexFileNames.fileNameFromGeneration((String)"pending_segments", (String)"", (long)segmentInfos.getGeneration());
            try (IndexOutput segnOutput = this.targetDirectory.createOutput(pendingSegmentFileName, IOContext.DEFAULT);){
                segmentInfos.write(this.targetDirectory, segnOutput);
            }
            this.targetDirectory.sync(Collections.singleton(pendingSegmentFileName));
            this.targetDirectory.sync(createdFiles);
            segmentFileName = IndexFileNames.fileNameFromGeneration((String)"segments", (String)"", (long)segmentInfos.getGeneration());
            this.targetDirectory.rename(pendingSegmentFileName, segmentFileName);
        }
        Lucene.pruneUnreferencedFiles((String)segmentFileName, (Directory)this.targetDirectory);
        assert (this.assertCheckIndex());
        return Collections.unmodifiableList(createdFiles);
    }

    private LiveDocs getLiveDocs(LeafReader reader) throws IOException {
        if (this.deleteByQuerySupplier != null) {
            DocIdSetIterator iterator;
            Query query = this.deleteByQuerySupplier.get();
            IndexSearcher s = new IndexSearcher((IndexReader)reader);
            s.setQueryCache(null);
            Query rewrite = s.rewrite(query);
            Weight weight = s.createWeight(rewrite, false, 1.0f);
            Scorer scorer = weight.scorer(reader.getContext());
            if (scorer != null && (iterator = scorer.iterator()) != null) {
                FixedBitSet bits;
                Bits liveDocs = reader.getLiveDocs();
                if (liveDocs != null) {
                    bits = FixedBitSet.copyOf((Bits)liveDocs);
                } else {
                    bits = new FixedBitSet(reader.maxDoc());
                    bits.set(0, reader.maxDoc());
                }
                int newDeletes = this.apply(iterator, bits);
                if (newDeletes != 0) {
                    int numDeletes = reader.numDeletedDocs() + newDeletes;
                    return new LiveDocs(numDeletes, (Bits)bits);
                }
            }
        }
        return new LiveDocs(reader.numDeletedDocs(), reader.getLiveDocs());
    }

    private int apply(DocIdSetIterator iterator, FixedBitSet bits) throws IOException {
        int docID = -1;
        int newDeletes = 0;
        while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
            if (!bits.get(docID)) continue;
            bits.clear(docID);
            ++newDeletes;
        }
        return newDeletes;
    }

    private boolean assertCheckIndex() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
        try (CheckIndex checkIndex = new CheckIndex(this.targetDirectory);){
            checkIndex.setFailFast(true);
            checkIndex.setInfoStream(new PrintStream((OutputStream)output, false, IOUtils.UTF_8), false);
            CheckIndex.Status status = checkIndex.checkIndex();
            if (status == null || !status.clean) {
                throw new RuntimeException("CheckIndex failed: " + output.toString(IOUtils.UTF_8));
            }
            boolean bl = true;
            return bl;
        }
    }

    DirectoryReader wrapReader(DirectoryReader reader) throws IOException {
        String softDeletesField = null;
        for (LeafReaderContext ctx : reader.leaves()) {
            String field = ctx.reader().getFieldInfos().getSoftDeletesField();
            if (field == null) continue;
            softDeletesField = field;
            break;
        }
        return softDeletesField == null ? reader : new SoftDeletesDirectoryReaderWrapper(reader, softDeletesField);
    }

    private SegmentCommitInfo syncSegment(SegmentCommitInfo segmentCommitInfo, LiveDocs liveDocs, FieldInfos fieldInfos, Map<BytesRef, SegmentCommitInfo> existingSegments, List<String> createdFiles) throws IOException {
        SegmentCommitInfo newInfo;
        SegmentInfo si = segmentCommitInfo.info;
        Codec codec = si.getCodec();
        String segmentSuffix = "";
        TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(this.targetDirectory);
        BytesRef segmentId = new BytesRef(si.getId());
        boolean exists = existingSegments.containsKey(segmentId);
        if (!exists) {
            SegmentInfo newSegmentInfo = new SegmentInfo(si.dir, si.getVersion(), si.getMinVersion(), si.name, si.maxDoc(), false, si.getCodec(), si.getDiagnostics(), si.getId(), si.getAttributes(), null);
            newInfo = new SegmentCommitInfo(newSegmentInfo, 0, 0, -1L, -1L, -1L);
            ArrayList<FieldInfo> fieldInfoCopy = new ArrayList<FieldInfo>(fieldInfos.size());
            for (FieldInfo fieldInfo : fieldInfos) {
                fieldInfoCopy.add(new FieldInfo(fieldInfo.name, fieldInfo.number, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, fieldInfo.attributes(), 0, 0, 0, fieldInfo.isSoftDeletesField()));
            }
            FieldInfos newFieldInfos = new FieldInfos(fieldInfoCopy.toArray(new FieldInfo[0]));
            codec.fieldInfosFormat().write((Directory)trackingDir, newSegmentInfo, "", newFieldInfos, IOContext.DEFAULT);
            newInfo.setFieldInfosFiles(trackingDir.getCreatedFiles());
            String idxFile = IndexFileNames.segmentFileName((String)newSegmentInfo.name, (String)"", (String)"fdx");
            String dataFile = IndexFileNames.segmentFileName((String)newSegmentInfo.name, (String)"", (String)"fdt");
            Directory sourceDir = newSegmentInfo.dir;
            if (si.getUseCompoundFile()) {
                sourceDir = codec.compoundFormat().getCompoundReader(sourceDir, si, IOContext.DEFAULT);
            }
            trackingDir.copyFrom(sourceDir, idxFile, idxFile, IOContext.DEFAULT);
            trackingDir.copyFrom(sourceDir, dataFile, dataFile, IOContext.DEFAULT);
            if (sourceDir != newSegmentInfo.dir) {
                sourceDir.close();
            }
        } else {
            newInfo = existingSegments.get(segmentId);
            assert (!newInfo.info.getUseCompoundFile());
        }
        if (liveDocs.bits != null && liveDocs.numDeletes != 0 && liveDocs.numDeletes != newInfo.getDelCount()) {
            if (newInfo.getDelCount() != 0) assert (this.assertLiveDocs(liveDocs.bits, liveDocs.numDeletes));
            codec.liveDocsFormat().writeLiveDocs(liveDocs.bits, (Directory)trackingDir, newInfo, liveDocs.numDeletes - newInfo.getDelCount(), IOContext.DEFAULT);
            SegmentCommitInfo info = new SegmentCommitInfo(newInfo.info, liveDocs.numDeletes, 0, newInfo.getNextDelGen(), -1L, -1L);
            info.setFieldInfosFiles(newInfo.getFieldInfosFiles());
            info.info.setFiles((Collection)trackingDir.getCreatedFiles());
            newInfo = info;
        }
        if (!exists) {
            newInfo.info.setFiles((Collection)trackingDir.getCreatedFiles());
            codec.segmentInfoFormat().write((Directory)trackingDir, newInfo.info, IOContext.DEFAULT);
        }
        createdFiles.addAll(trackingDir.getCreatedFiles());
        return newInfo;
    }

    private boolean assertLiveDocs(Bits liveDocs, int deletes) {
        int actualDeletes = 0;
        for (int i = 0; i < liveDocs.length(); ++i) {
            if (liveDocs.get(i)) continue;
            ++actualDeletes;
        }
        assert (actualDeletes == deletes) : " actual: " + actualDeletes + " deletes: " + deletes;
        return true;
    }

    private static class LiveDocs {
        final int numDeletes;
        final Bits bits;

        LiveDocs(int numDeletes, Bits bits) {
            this.numDeletes = numDeletes;
            this.bits = bits;
        }
    }
}

