/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;

public class MappedBuffer
implements Closeable {
    private final MappedByteBuffer[] pages;
    private long position;
    private long limit;
    private final long capacity;
    private final int pageSize;
    private final int sizeBits;

    private MappedBuffer(MappedBuffer other) {
        this.sizeBits = other.sizeBits;
        this.pageSize = other.pageSize;
        this.position = other.position;
        this.limit = other.limit;
        this.capacity = other.capacity;
        this.pages = other.pages;
    }

    public MappedBuffer(RandomAccessReader file) {
        this(file.getChannel(), 30);
    }

    public MappedBuffer(ChannelProxy file) {
        this(file, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected MappedBuffer(ChannelProxy file, int numPageBits) {
        if (numPageBits > 31) {
            throw new IllegalArgumentException("page size can't be bigger than 1G");
        }
        this.sizeBits = numPageBits;
        this.pageSize = 1 << this.sizeBits;
        this.position = 0L;
        this.limit = this.capacity = file.size();
        this.pages = new MappedByteBuffer[(int)(file.size() / (long)this.pageSize) + 1];
        try {
            long offset = 0L;
            for (int i = 0; i < this.pages.length; ++i) {
                long pageSize = Math.min((long)this.pageSize, this.capacity - offset);
                this.pages[i] = file.map(FileChannel.MapMode.READ_ONLY, offset, pageSize);
                offset += pageSize;
            }
        }
        finally {
            file.close();
        }
    }

    public int comparePageTo(long offset, int length, AbstractType<?> comparator, ByteBuffer other) {
        return comparator.compare(this.getPageRegion(offset, length), other);
    }

    public long capacity() {
        return this.capacity;
    }

    public long position() {
        return this.position;
    }

    public MappedBuffer position(long newPosition) {
        if (newPosition < 0L || newPosition > this.limit) {
            throw new IllegalArgumentException("position: " + newPosition + ", limit: " + this.limit);
        }
        this.position = newPosition;
        return this;
    }

    public long limit() {
        return this.limit;
    }

    public MappedBuffer limit(long newLimit) {
        if (newLimit < this.position || newLimit > this.capacity) {
            throw new IllegalArgumentException();
        }
        this.limit = newLimit;
        return this;
    }

    public long remaining() {
        return this.limit - this.position;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0L;
    }

    public byte get() {
        return this.get(this.position++);
    }

    public byte get(long pos) {
        return this.pages[this.getPage(pos)].get(this.getPageOffset(pos));
    }

    public short getShort() {
        short value = this.getShort(this.position);
        this.position += 2L;
        return value;
    }

    public short getShort(long pos) {
        if (this.isPageAligned(pos, 2)) {
            return this.pages[this.getPage(pos)].getShort(this.getPageOffset(pos));
        }
        int ch1 = this.get(pos) & 0xFF;
        int ch2 = this.get(pos + 1L) & 0xFF;
        return (short)((ch1 << 8) + ch2);
    }

    public int getInt() {
        int value = this.getInt(this.position);
        this.position += 4L;
        return value;
    }

    public int getInt(long pos) {
        if (this.isPageAligned(pos, 4)) {
            return this.pages[this.getPage(pos)].getInt(this.getPageOffset(pos));
        }
        int ch1 = this.get(pos) & 0xFF;
        int ch2 = this.get(pos + 1L) & 0xFF;
        int ch3 = this.get(pos + 2L) & 0xFF;
        int ch4 = this.get(pos + 3L) & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public long getLong() {
        long value = this.getLong(this.position);
        this.position += 8L;
        return value;
    }

    public long getLong(long pos) {
        return this.isPageAligned(pos, 8) ? this.pages[this.getPage(pos)].getLong(this.getPageOffset(pos)) : ((long)this.getInt(pos) << 32) + ((long)this.getInt(pos + 4L) & 0xFFFFFFFFL);
    }

    public ByteBuffer getPageRegion(long position, int length) {
        if (!this.isPageAligned(position, length)) {
            throw new IllegalArgumentException(String.format("range: %s-%s wraps more than one page", position, length));
        }
        ByteBuffer slice = this.pages[this.getPage(position)].duplicate();
        int pageOffset = this.getPageOffset(position);
        slice.position(pageOffset).limit(pageOffset + length);
        return slice;
    }

    public MappedBuffer duplicate() {
        return new MappedBuffer(this);
    }

    @Override
    public void close() {
        if (!FileUtils.isCleanerAvailable) {
            return;
        }
        try {
            for (MappedByteBuffer segment : this.pages) {
                FileUtils.clean(segment);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getPage(long position) {
        return (int)(position >> this.sizeBits);
    }

    private int getPageOffset(long position) {
        return (int)(position & (long)(this.pageSize - 1));
    }

    private boolean isPageAligned(long position, int length) {
        return this.pageSize - (this.getPageOffset(position) + length) > 0;
    }
}

