/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.fasta;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.usadellab.trimmomatic.fasta.FastaRecord;

public class FastaParser {
    private BufferedReader reader;
    private String currentLine;
    private FastaRecord current;

    public void parseOne() throws IOException {
        this.current = null;
        if (this.currentLine == null) {
            this.currentLine = this.reader.readLine();
        }
        while (this.currentLine != null && !this.currentLine.startsWith(">")) {
            this.currentLine = this.reader.readLine();
        }
        if (this.currentLine != null && this.currentLine.startsWith(">")) {
            String fullName = this.currentLine.substring(1).trim();
            String[] tokens = fullName.split("[\\| ]");
            String name = tokens[0];
            StringBuilder builder = new StringBuilder();
            this.currentLine = this.reader.readLine();
            while (this.currentLine != null && !this.currentLine.startsWith(">")) {
                if (!this.currentLine.startsWith(";")) {
                    builder.append(this.currentLine.trim());
                }
                this.currentLine = this.reader.readLine();
            }
            this.current = new FastaRecord(name, builder.toString().trim(), fullName);
        }
    }

    public void parse(File file) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(file), 1000000)));
        this.parseOne();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean hasNext() {
        return this.current != null;
    }

    public FastaRecord next() throws IOException {
        FastaRecord current = this.current;
        this.parseOne();
        return current;
    }
}

