/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.util;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.trie4j.MapTrie;

public class TrieMap<T>
extends AbstractMap<String, T> {
    private MapTrie<T> trie;

    public TrieMap(MapTrie<T> trie) {
        this.trie = trie;
    }

    @Override
    public T get(Object key) {
        return this.trie.get(key.toString());
    }

    @Override
    public T put(String key, T value) {
        return this.trie.insert(key, value);
    }

    @Override
    public int size() {
        return this.trie.size();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        TreeSet<1> ret = new TreeSet<1>();
        for (final String s : this.trie.predictiveSearch("")) {
            final T v = this.trie.get(s);
            ret.add(new Map.Entry<String, T>(){

                @Override
                public String getKey() {
                    return s;
                }

                @Override
                public T getValue() {
                    return v;
                }

                @Override
                public T setValue(T value) {
                    throw new UnsupportedOperationException();
                }
            });
        }
        return Collections.unmodifiableSet(ret);
    }
}

