/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.master;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.omegat.core.Core;
import org.omegat.core.data.PluginInformation;
import org.omegat.tokenizer.DefaultTokenizer;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.tokenizer.Tokenizer;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public final class PluginUtils {
    public static final String PLUGINS_LIST_FILE = "Plugins.properties";
    private static final List<Class<?>> LOADED_PLUGINS = new ArrayList();
    private static final Set<PluginInformation> PLUGIN_INFORMATIONS = new HashSet<PluginInformation>();
    private static final List<Class<?>> FILTER_CLASSES = new ArrayList();
    private static final List<Class<?>> TOKENIZER_CLASSES = new ArrayList();
    private static final List<Class<?>> MARKER_CLASSES = new ArrayList();
    private static final List<Class<?>> MACHINE_TRANSLATION_CLASSES = new ArrayList();
    private static final List<Class<?>> GLOSSARY_CLASSES = new ArrayList();
    private static final List<Class<?>> BASE_PLUGIN_CLASSES = new ArrayList();
    private static final List<URL> THEME_PLUGIN_JARS = new ArrayList<URL>();

    private PluginUtils() {
    }

    public static void loadPlugins(Map<String, String> params) {
        block35: {
            File pluginsDir = new File(StaticUtils.installDir(), "plugins");
            File homePluginsDir = new File(StaticUtils.getConfigDir(), "plugins");
            FileFilter jarFilter = pathname -> pathname.getName().endsWith(".jar");
            List fs = Stream.of(pluginsDir, homePluginsDir).flatMap(dir -> FileUtil.findFiles(dir, jarFilter).stream()).collect(Collectors.toList());
            ArrayList<URL> urlList = new ArrayList<URL>();
            for (File f : fs) {
                try {
                    URL url = f.toURI().toURL();
                    urlList.add(url);
                    Log.logInfoRB("PLUGIN_LOAD_JAR", url.toString());
                }
                catch (IOException ex) {
                    Log.log(ex);
                }
            }
            boolean foundMain = false;
            URLClassLoader pluginsClassLoader = new URLClassLoader(urlList.toArray(new URL[0]), PluginUtils.class.getClassLoader());
            try {
                Enumeration<URL> mlist = pluginsClassLoader.getResources("META-INF/MANIFEST.MF");
                while (mlist.hasMoreElements()) {
                    String[] mu = mlist.nextElement();
                    try {
                        InputStream in = mu.openStream();
                        try {
                            Manifest m = new Manifest(in);
                            if ("org.omegat.Main".equals(m.getMainAttributes().getValue("Main-Class"))) {
                                foundMain = true;
                                PluginUtils.loadFromManifest(m, pluginsClassLoader, null);
                            } else {
                                PluginUtils.loadFromManifest(m, pluginsClassLoader, (URL)mu);
                            }
                            if (!"theme".equals(m.getMainAttributes().getValue("Plugin-Category"))) continue;
                            String target = mu.toString();
                            for (URL url : urlList) {
                                if (!target.contains(url.toString())) continue;
                                THEME_PLUGIN_JARS.add(url);
                            }
                        }
                        finally {
                            if (in == null) continue;
                            in.close();
                        }
                    }
                    catch (ClassNotFoundException e) {
                        Log.log(e);
                    }
                    catch (UnsupportedClassVersionError e) {
                        JarURLConnection connection = (JarURLConnection)mu.openConnection();
                        URL url = connection.getJarFileURL();
                        Log.logWarningRB("PLUGIN_JAVA_VERSION_ERROR", url);
                    }
                }
            }
            catch (IOException ex) {
                Log.log(ex);
            }
            try {
                if (foundMain) break block35;
                String manifests = params.get("dev-manifests");
                if (manifests != null) {
                    for (String mf : manifests.split(File.pathSeparator)) {
                        try (InputStream in = Files.newInputStream(Paths.get(mf, new String[0]), new OpenOption[0]);){
                            PluginUtils.loadFromManifest(new Manifest(in), pluginsClassLoader, null);
                        }
                    }
                    break block35;
                }
                Properties props = new Properties();
                try (FileInputStream fis = new FileInputStream(PLUGINS_LIST_FILE);){
                    props.load(fis);
                    PluginUtils.loadFromProperties(props, pluginsClassLoader);
                }
            }
            catch (IOException | ClassNotFoundException ex) {
                Log.log(ex);
            }
        }
        for (Class<?> pl : BASE_PLUGIN_CLASSES) {
            try {
                pl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }

    public static List<Class<?>> getFilterClasses() {
        return FILTER_CLASSES;
    }

    public static List<Class<?>> getTokenizerClasses() {
        return TOKENIZER_CLASSES;
    }

    public static Class<?> getTokenizerClassForLanguage(Language lang) {
        if (lang == null) {
            return DefaultTokenizer.class;
        }
        Class<?> exactResult = PluginUtils.searchForTokenizer(lang.getLanguage());
        if (PluginUtils.isDefault(exactResult)) {
            return exactResult;
        }
        Class<?> generalResult = PluginUtils.searchForTokenizer(lang.getLanguageCode());
        if (PluginUtils.isDefault(generalResult)) {
            return generalResult;
        }
        if (exactResult != null) {
            return exactResult;
        }
        if (generalResult != null) {
            return generalResult;
        }
        return DefaultTokenizer.class;
    }

    private static boolean isDefault(Class<?> c) {
        if (c == null) {
            return false;
        }
        Tokenizer ann = c.getAnnotation(Tokenizer.class);
        return ann != null && ann.isDefault();
    }

    private static Class<?> searchForTokenizer(String lang) {
        if (lang.isEmpty()) {
            return null;
        }
        lang = lang.toLowerCase(Locale.ENGLISH);
        Class<?> fallback = null;
        for (Class<?> c : TOKENIZER_CLASSES) {
            Tokenizer ann = c.getAnnotation(Tokenizer.class);
            if (ann == null) continue;
            String[] languages = ann.languages();
            if (languages.length == 1 && languages[0].equals("discoverAtRuntime")) {
                try {
                    languages = ((ITokenizer)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getSupportedLanguages();
                }
                catch (Exception ex) {
                    Log.log(ex);
                }
            }
            for (String s : languages) {
                if (!lang.equals(s)) continue;
                if (ann.isDefault()) {
                    return c;
                }
                if (fallback != null) continue;
                fallback = c;
            }
        }
        return fallback;
    }

    public static List<Class<?>> getMarkerClasses() {
        return MARKER_CLASSES;
    }

    public static List<Class<?>> getMachineTranslationClasses() {
        return MACHINE_TRANSLATION_CLASSES;
    }

    public static List<Class<?>> getGlossaryClasses() {
        return GLOSSARY_CLASSES;
    }

    public static List<URL> getThemePluginJars() {
        return THEME_PLUGIN_JARS;
    }

    private static void loadFromManifest(Manifest m, ClassLoader classLoader, URL mu) throws ClassNotFoundException {
        String classes = m.getMainAttributes().getValue("OmegaT-Plugins");
        if (classes != null) {
            for (String clazz : classes.split("\\s+")) {
                if (clazz.trim().isEmpty() || !PluginUtils.loadClass(clazz, classLoader)) continue;
                if (mu == null) {
                    PLUGIN_INFORMATIONS.add(PluginInformation.Builder.fromManifest(clazz, m, null, PluginInformation.Status.BUNDLED));
                    continue;
                }
                PLUGIN_INFORMATIONS.add(PluginInformation.Builder.fromManifest(clazz, m, mu, PluginInformation.Status.INSTALLED));
            }
        }
        PluginUtils.loadFromManifestOld(m, classLoader);
    }

    private static void loadFromProperties(Properties props, ClassLoader classLoader) throws ClassNotFoundException {
        for (Object o : props.keySet()) {
            String key = o.toString();
            String[] classes = props.getProperty(key).split("\\s+");
            if (key.startsWith("plugin.desc")) continue;
            if (key.equals("plugin")) {
                for (String clazz : classes) {
                    if (!PluginUtils.loadClass(clazz, classLoader)) continue;
                    PLUGIN_INFORMATIONS.add(PluginInformation.Builder.fromProperties(clazz, props, key, null, PluginInformation.Status.BUNDLED));
                }
                continue;
            }
            for (String clazz : classes) {
                if (!PluginUtils.loadClassOld(key, clazz, classLoader)) continue;
                PLUGIN_INFORMATIONS.add(PluginInformation.Builder.fromProperties(clazz, props, key, null, PluginInformation.Status.BUNDLED));
            }
        }
    }

    private static boolean loadClass(String clazz, ClassLoader classLoader) {
        try {
            Class<?> c = classLoader.loadClass(clazz);
            if (LOADED_PLUGINS.contains(c)) {
                Log.logInfoRB("PLUGIN_SKIP_PREVIOUSLY_LOADED", clazz);
                return false;
            }
            Method load = c.getMethod("loadPlugins", new Class[0]);
            load.invoke(c, new Object[0]);
            LOADED_PLUGINS.add(c);
            Log.logInfoRB("PLUGIN_LOAD_OK", clazz);
            return true;
        }
        catch (Throwable ex) {
            Log.logErrorRB(ex, "PLUGIN_LOAD_ERROR", clazz, ex.getClass().getSimpleName(), ex.getMessage());
            Core.pluginLoadingError(StringUtil.format(OStrings.getString("PLUGIN_LOAD_ERROR"), clazz, ex.getClass().getSimpleName(), ex.getMessage()));
            return false;
        }
    }

    public static void unloadPlugins() {
        for (Class<?> p : LOADED_PLUGINS) {
            try {
                Method load = p.getMethod("unloadPlugins", new Class[0]);
                load.invoke(p, new Object[0]);
            }
            catch (Throwable ex) {
                Log.logErrorRB(ex, "PLUGIN_UNLOAD_ERROR", p.getSimpleName(), ex.getMessage());
            }
        }
    }

    private static void loadFromManifestOld(Manifest m, ClassLoader classLoader) throws ClassNotFoundException {
        if (m.getMainAttributes().getValue("OmegaT-Plugin") == null) {
            return;
        }
        Map<String, Attributes> entries = m.getEntries();
        for (Map.Entry<String, Attributes> e : entries.entrySet()) {
            String key = e.getKey();
            Attributes attrs = e.getValue();
            String sType = attrs.getValue("OmegaT-Plugin");
            if (sType == null || !PluginUtils.loadClassOld(sType, key, classLoader)) continue;
            PLUGIN_INFORMATIONS.add(PluginInformation.Builder.fromManifest(key, m, null, PluginInformation.Status.BUNDLED));
        }
    }

    private static boolean loadClassOld(String sType, String key, ClassLoader classLoader) throws ClassNotFoundException {
        boolean loadOk = true;
        switch (PluginType.getTypeByValue(sType)) {
            case FILTER: {
                FILTER_CLASSES.add(classLoader.loadClass(key));
                Log.logInfoRB("PLUGIN_LOAD_OK", key);
                break;
            }
            case TOKENIZER: {
                TOKENIZER_CLASSES.add(classLoader.loadClass(key));
                Log.logInfoRB("PLUGIN_LOAD_OK", key);
                break;
            }
            case MARKER: {
                MARKER_CLASSES.add(classLoader.loadClass(key));
                Log.logInfoRB("PLUGIN_LOAD_OK", key);
                break;
            }
            case MACHINETRANSLATOR: {
                MACHINE_TRANSLATION_CLASSES.add(classLoader.loadClass(key));
                Log.logInfoRB("PLUGIN_LOAD_OK", key);
                break;
            }
            case BASE: {
                BASE_PLUGIN_CLASSES.add(classLoader.loadClass(key));
                Log.logInfoRB("PLUGIN_LOAD_OK", key);
                break;
            }
            case GLOSSARY: {
                GLOSSARY_CLASSES.add(classLoader.loadClass(key));
                Log.logInfoRB("PLUGIN_LOAD_OK", key);
                break;
            }
            default: {
                Log.logErrorRB("PLUGIN_UNKNOWN", sType, key);
                loadOk = false;
            }
        }
        return loadOk;
    }

    public static Collection<PluginInformation> getPluginInformations() {
        return Collections.unmodifiableSet(PLUGIN_INFORMATIONS);
    }

    public static enum PluginType {
        FILTER("filter"),
        TOKENIZER("tokenizer"),
        MARKER("marker"),
        MACHINETRANSLATOR("machinetranslator"),
        BASE("base"),
        GLOSSARY("glossary"),
        DICTIONARY("dictionary"),
        THEME("theme"),
        MISCELLANEOUS("miscellaneous"),
        UNKNOWN("Undefined");

        private final String typeValue;

        private PluginType(String type) {
            this.typeValue = type;
        }

        public String getTypeValue() {
            return this.typeValue;
        }

        public static PluginType getTypeByValue(String str) {
            if (!StringUtil.isEmpty(str)) {
                String sType = str.toLowerCase(Locale.ENGLISH);
                for (PluginType v : PluginType.values()) {
                    if (!v.getTypeValue().equals(sType)) continue;
                    return v;
                }
            }
            return UNKNOWN;
        }
    }
}

