/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cn.smart.HMMChineseTokenizer;
import org.apache.lucene.analysis.cn.smart.SentenceTokenizer;
import org.apache.lucene.analysis.cn.smart.WordTokenFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public final class SmartChineseAnalyzer
extends Analyzer {
    private final CharArraySet stopWords;
    private static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORD_FILE_COMMENT = "//";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public SmartChineseAnalyzer() {
        this(true);
    }

    public SmartChineseAnalyzer(boolean useDefaultStopWords) {
        this.stopWords = useDefaultStopWords ? DefaultSetHolder.DEFAULT_STOP_SET : CharArraySet.EMPTY_SET;
    }

    public SmartChineseAnalyzer(CharArraySet stopWords) {
        this.stopWords = stopWords == null ? CharArraySet.EMPTY_SET : stopWords;
    }

    public Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Object result;
        Object tokenizer;
        if (this.getVersion().onOrAfter(Version.LUCENE_4_8_0)) {
            result = tokenizer = new HMMChineseTokenizer();
        } else {
            tokenizer = new SentenceTokenizer();
            result = new WordTokenFilter((TokenStream)tokenizer);
        }
        result = new PorterStemFilter((TokenStream)result);
        if (!this.stopWords.isEmpty()) {
            result = new StopFilter((TokenStream)result, this.stopWords);
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static CharArraySet loadDefaultStopWordSet() throws IOException {
            return CharArraySet.unmodifiableSet((CharArraySet)WordlistLoader.getWordSet((Reader)IOUtils.getDecodingReader(SmartChineseAnalyzer.class, (String)SmartChineseAnalyzer.DEFAULT_STOPWORD_FILE, (Charset)StandardCharsets.UTF_8), (String)SmartChineseAnalyzer.STOPWORD_FILE_COMMENT));
        }

        static {
            try {
                DEFAULT_STOP_SET = DefaultSetHolder.loadDefaultStopWordSet();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

