/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.async;

import com.sun.grizzly.async.OperationResult;
import com.sun.grizzly.util.LinkedTransferQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncQueue<K, E> {
    private Map<K, AsyncQueueEntry> queueMap = new ConcurrentHashMap<K, AsyncQueueEntry>();

    public void offer(K key, E queueRecord) {
        AsyncQueueEntry entry = this.obtainAsyncQueueEntry(key);
        entry.queue.offer(queueRecord);
    }

    public E peek(K key) {
        AsyncQueueEntry entry = this.queueMap.get(key);
        if (entry != null) {
            return entry.queue.peek();
        }
        return null;
    }

    public E poll(K key) {
        AsyncQueueEntry entry = this.queueMap.get(key);
        if (entry != null) {
            return entry.queue.poll();
        }
        return null;
    }

    public AsyncQueueEntry removeEntry(K key) {
        return this.queueMap.remove(key);
    }

    public int size(K key) {
        AsyncQueueEntry entry = this.queueMap.get(key);
        return entry == null ? 0 : entry.queue.size();
    }

    public boolean isEmpty(K key) {
        AsyncQueueEntry entry = this.queueMap.get(key);
        return entry == null || entry.queue.isEmpty();
    }

    public void clear() {
        this.queueMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AsyncQueueEntry obtainAsyncQueueEntry(K key) {
        AsyncQueueEntry entry = this.queueMap.get(key);
        if (entry == null) {
            K k = key;
            synchronized (k) {
                entry = this.queueMap.get(key);
                if (entry == null) {
                    entry = new AsyncQueueEntry();
                    this.queueMap.put(key, entry);
                }
            }
        }
        return entry;
    }

    protected AsyncQueueEntry getAsyncQueueEntry(K key) {
        return this.queueMap.get(key);
    }

    public class AsyncQueueEntry {
        public LinkedTransferQueue<E> queue = new LinkedTransferQueue();
        public AtomicReference<E> currentElement = new AtomicReference();
        public ReentrantLock queuedActionLock = new ReentrantLock();
        public AtomicInteger processedDataSize = new AtomicInteger();
        public AtomicInteger processedElementsCount = new AtomicInteger();
        public AtomicInteger totalElementsCount = new AtomicInteger();
        public AtomicInteger queuedElementsCount = new AtomicInteger();
        protected OperationResult tmpResult = new OperationResult();
    }
}

