/*
 * Decompiled with CFR 0.152.
 */
package com.zabbix.gateway;

import com.zabbix.gateway.BinaryProtocolSpeaker;
import com.zabbix.gateway.InternalItemChecker;
import com.zabbix.gateway.ItemChecker;
import com.zabbix.gateway.JMXItemChecker;
import com.zabbix.gateway.JavaGateway;
import com.zabbix.gateway.ZabbixException;
import java.net.Socket;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocketProcessor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SocketProcessor.class);
    private static long cleanupTime = System.currentTimeMillis();
    private Socket socket;
    public static final long MILLISECONDS_IN_HOUR = 3600000L;
    public static final long MILLISECONDS_IN_24HOURS = 86400000L;
    private static long RMISSLhintCacheCleanupTime = System.currentTimeMillis() + 86400000L;

    SocketProcessor(Socket socket) {
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug("starting to process incoming connection");
        BinaryProtocolSpeaker binaryProtocolSpeaker = null;
        ItemChecker itemChecker = null;
        try {
            binaryProtocolSpeaker = new BinaryProtocolSpeaker(this.socket);
            JSONObject jSONObject = new JSONObject(binaryProtocolSpeaker.getRequest());
            if (jSONObject.getString("request").equals("java gateway internal")) {
                itemChecker = new InternalItemChecker(jSONObject);
            } else if (jSONObject.getString("request").equals("java gateway jmx")) {
                itemChecker = new JMXItemChecker(jSONObject);
                long l = System.currentTimeMillis();
                if (l >= cleanupTime) {
                    this.cleanDiscoveredObjects(l);
                    cleanupTime = l + 3600000L;
                }
                this.cleanRMISSLhintCache((JMXItemChecker)itemChecker);
            } else {
                throw new ZabbixException("bad request tag value: '%s'", jSONObject.getString("request"));
            }
            logger.debug("dispatched request to class {}", (Object)itemChecker.getClass().getName());
            JSONArray jSONArray = itemChecker.getValues();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("response", (Object)"success");
            jSONObject2.put("data", (Object)jSONArray);
            binaryProtocolSpeaker.sendResponse(jSONObject2.toString());
        }
        catch (Exception exception) {
            String string = ZabbixException.getRootCauseMessage(exception);
            if (null == itemChecker || null == itemChecker.getFirstKey()) {
                logger.warn("error processing request: {}", (Object)string);
            } else {
                logger.warn("error processing request, item \"{}\" failed: {}", (Object)itemChecker.getFirstKey(), (Object)string);
            }
            logger.debug("error caused by", (Throwable)exception);
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("response", (Object)"failed");
                jSONObject.put("error", (Object)string);
                binaryProtocolSpeaker.sendResponse(jSONObject.toString());
            }
            catch (Exception exception2) {
                logger.warn("error sending failure notification: {}", (Object)ZabbixException.getRootCauseMessage(exception));
                logger.debug("error caused by", (Throwable)exception2);
            }
        }
        finally {
            try {
                if (null != binaryProtocolSpeaker) {
                    binaryProtocolSpeaker.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != this.socket) {
                    this.socket.close();
                }
            }
            catch (Exception exception) {}
        }
        logger.debug("finished processing incoming connection");
    }

    private void cleanDiscoveredObjects(long l) {
        Iterator<Map.Entry<String, Long>> iterator = JavaGateway.iterativeObjects.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            long l2 = entry.getValue();
            if (l < l2) continue;
            iterator.remove();
        }
    }

    public void cleanRMISSLhintCache(JMXItemChecker jMXItemChecker) {
        long l = System.currentTimeMillis();
        logger.debug("RMI SSL hint cache cleanup is scheduled on " + RMISSLhintCacheCleanupTime + ", now is: " + l);
        if (l >= RMISSLhintCacheCleanupTime) {
            jMXItemChecker.cleanUseRMISSLforURLHintCache();
            RMISSLhintCacheCleanupTime = l + 86400000L;
        }
    }
}

