/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.status;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.status.Status;
import org.apache.ivy.util.Message;

public class StatusManager {
    private List status = new ArrayList();
    private String defaultStatus;
    private Map statusPriorityMap;
    private Map statusIntegrationMap;
    private String deliveryStatusListString;

    public static StatusManager newDefaultInstance() {
        return new StatusManager(new Status[]{new Status("release", false), new Status("milestone", false), new Status("integration", true)}, "integration");
    }

    public static StatusManager getCurrent() {
        return IvyContext.getContext().getSettings().getStatusManager();
    }

    public StatusManager(Status[] statusArray, String string) {
        this.status.addAll(Arrays.asList(statusArray));
        this.defaultStatus = string;
        this.computeMaps();
    }

    public StatusManager() {
    }

    public void addStatus(Status status) {
        this.status.add(status);
    }

    public void setDefaultStatus(String string) {
        this.defaultStatus = string;
    }

    public List getStatuses() {
        return this.status;
    }

    private void computeMaps() {
        if (this.status.isEmpty()) {
            throw new IllegalStateException("badly configured statuses: no status found");
        }
        this.statusPriorityMap = new HashMap();
        Iterator iterator = this.status.listIterator();
        while (iterator.hasNext()) {
            Status status = (Status)iterator.next();
            this.statusPriorityMap.put(status.getName(), new Integer(iterator.previousIndex()));
        }
        this.statusIntegrationMap = new HashMap();
        for (Status status : this.status) {
            this.statusIntegrationMap.put(status.getName(), status.isIntegration());
        }
    }

    public boolean isStatus(String string) {
        if (this.statusPriorityMap == null) {
            this.computeMaps();
        }
        return this.statusPriorityMap.containsKey(string);
    }

    public int getPriority(String string) {
        Integer n;
        if (this.statusPriorityMap == null) {
            this.computeMaps();
        }
        if ((n = (Integer)this.statusPriorityMap.get(string)) == null) {
            Message.debug("unknown status " + string + ": assuming lowest priority");
            return Integer.MAX_VALUE;
        }
        return n;
    }

    public boolean isIntegration(String string) {
        Boolean bl;
        if (this.statusIntegrationMap == null) {
            this.computeMaps();
        }
        if ((bl = (Boolean)this.statusIntegrationMap.get(string)) == null) {
            Message.debug("unknown status " + string + ": assuming integration");
            return true;
        }
        return bl;
    }

    public String getDeliveryStatusListString() {
        if (this.deliveryStatusListString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Status status : this.status) {
                if (status.isIntegration()) continue;
                stringBuffer.append(status.getName()).append(",");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            this.deliveryStatusListString = stringBuffer.toString();
        }
        return this.deliveryStatusListString;
    }

    public String getDefaultStatus() {
        if (this.defaultStatus == null) {
            if (this.status.isEmpty()) {
                throw new IllegalStateException("badly configured statuses: no status found");
            }
            this.defaultStatus = ((Status)this.status.get(this.status.size() - 1)).getName();
        }
        return this.defaultStatus;
    }
}

