/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.wrapper.VirtualNode;

public class XdmNode
extends XdmItem {
    public XdmNode(NodeInfo node) {
        super(node);
    }

    public XdmNodeKind getNodeKind() {
        switch (this.getUnderlyingNode().getNodeKind()) {
            case 9: {
                return XdmNodeKind.DOCUMENT;
            }
            case 1: {
                return XdmNodeKind.ELEMENT;
            }
            case 2: {
                return XdmNodeKind.ATTRIBUTE;
            }
            case 3: {
                return XdmNodeKind.TEXT;
            }
            case 8: {
                return XdmNodeKind.COMMENT;
            }
            case 7: {
                return XdmNodeKind.PROCESSING_INSTRUCTION;
            }
            case 13: {
                return XdmNodeKind.NAMESPACE;
            }
        }
        throw new IllegalStateException("nodeKind");
    }

    public QName getNodeName() {
        NodeInfo n = this.getUnderlyingNode();
        switch (n.getNodeKind()) {
            case 3: 
            case 8: 
            case 9: {
                return null;
            }
            case 7: 
            case 13: {
                if (n.getLocalPart().isEmpty()) {
                    return null;
                }
                return new QName(new StructuredQName("", "", n.getLocalPart()));
            }
            case 1: 
            case 2: {
                return new QName(n.getPrefix(), n.getURI(), n.getLocalPart());
            }
        }
        return null;
    }

    public XdmValue getTypedValue() throws SaxonApiException {
        try {
            AtomicSequence v = this.getUnderlyingNode().atomize();
            return XdmValue.wrap(v);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public int getLineNumber() {
        return this.getUnderlyingNode().getLineNumber();
    }

    public int getColumnNumber() {
        return this.getUnderlyingNode().getColumnNumber();
    }

    public Source asSource() {
        return this.getUnderlyingNode();
    }

    public XdmSequenceIterator axisIterator(Axis axis) {
        AxisIterator base = this.getUnderlyingNode().iterateAxis(axis.getAxisNumber());
        return new XdmSequenceIterator(base);
    }

    public XdmSequenceIterator axisIterator(Axis axis, QName name) {
        int kind;
        switch (axis) {
            case ATTRIBUTE: {
                kind = 2;
                break;
            }
            case NAMESPACE: {
                kind = 13;
                break;
            }
            default: {
                kind = 1;
            }
        }
        NamePool pool = this.getUnderlyingNode().getNamePool();
        int nameCode = pool.allocate("", name.getNamespaceURI(), name.getLocalName());
        NameTest test = new NameTest(kind, nameCode, pool);
        AxisIterator base = this.getUnderlyingNode().iterateAxis(axis.getAxisNumber(), test);
        return new XdmSequenceIterator(base);
    }

    public XdmNode getParent() {
        return (XdmNode)XdmValue.wrap(this.getUnderlyingNode().getParent());
    }

    public String getAttributeValue(QName name) {
        NodeInfo node = this.getUnderlyingNode();
        return node.getAttributeValue(name.getNamespaceURI(), name.getLocalName());
    }

    public URI getBaseURI() {
        try {
            String uri = this.getUnderlyingNode().getBaseURI();
            if (uri == null) {
                return null;
            }
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("baseURI", e);
        }
    }

    public URI getDocumentURI() {
        try {
            String systemId = this.getUnderlyingNode().getSystemId();
            return systemId == null || systemId.length() == 0 ? null : new URI(systemId);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("documentURI", e);
        }
    }

    public int hashCode() {
        return this.getUnderlyingNode().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof XdmNode && this.getUnderlyingNode().isSameNodeInfo(((XdmNode)other).getUnderlyingNode());
    }

    public String toString() {
        NodeInfo node = this.getUnderlyingNode();
        if (node.getNodeKind() == 2) {
            String val = node.getStringValue().replace("\"", "&quot;");
            val = val.replace("<", "&lt;");
            val = val.replace("&", "&amp;");
            return node.getDisplayName() + "=\"" + val + '\"';
        }
        if (node.getNodeKind() == 13) {
            String val = node.getStringValue().replace("\"", "&quot;");
            val = val.replace("<", "&lt;");
            val = val.replace("&", "&amp;");
            String name = node.getDisplayName();
            name = name.equals("") ? "xmlns" : "xmlns:" + name;
            return name + "=\"" + val + '\"';
        }
        try {
            return QueryResult.serialize(node);
        }
        catch (XPathException err) {
            throw new IllegalStateException(err);
        }
    }

    public Processor getProcessor() {
        Object p = this.getUnderlyingNode().getConfiguration().getProcessor();
        if (p instanceof Processor) {
            return (Processor)p;
        }
        throw new IllegalStateException("Node was not created using a s9api Processor");
    }

    public NodeInfo getUnderlyingNode() {
        return (NodeInfo)this.getUnderlyingValue();
    }

    public Object getExternalNode() {
        NodeInfo saxonNode = this.getUnderlyingNode();
        if (saxonNode instanceof VirtualNode) {
            Object externalNode = ((VirtualNode)saxonNode).getRealNode();
            return externalNode instanceof NodeInfo ? null : externalNode;
        }
        return null;
    }
}

