/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.functions.Current;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneralNodePattern
extends Pattern {
    private Expression equivalentExpr = null;
    private NodeTest itemType = null;

    public GeneralNodePattern(Expression expr, NodeTest itemType) {
        this.equivalentExpr = expr;
        this.itemType = itemType;
    }

    @Override
    public boolean isMotionless(boolean allowExtensions) {
        return false;
    }

    @Override
    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    @Override
    public Pattern analyze(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.equivalentExpr = visitor.typeCheck(this.equivalentExpr, contextItemType);
        ItemType type = this.equivalentExpr.getItemType(visitor.getConfiguration().getTypeHierarchy());
        if (!(type instanceof NodeTest)) {
            throw new XPathException("GeneralNodePattern can only match nodes");
        }
        return this;
    }

    @Override
    public int getDependencies() {
        return this.equivalentExpr.getDependencies() & 0x80;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator<Expression>(this.equivalentExpr);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        return this.equivalentExpr.replaceSubExpression(original, replacement);
    }

    @Override
    public void bindCurrent(Binding binding) {
        if (ExpressionTool.callsFunction(this.equivalentExpr, Current.FN_CURRENT)) {
            GeneralNodePattern.replaceCurrent(this.equivalentExpr, binding);
        }
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        return ExpressionTool.allocateSlots(this.equivalentExpr, nextFree, slotManager);
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        Binding[] savedBindingList = offer.bindingList;
        this.equivalentExpr = this.equivalentExpr.promote(offer, parent);
        offer.bindingList = savedBindingList;
    }

    @Override
    public boolean matches(Item item, XPathContext context) throws XPathException {
        Object a;
        if (!this.itemType.matches(item, context)) {
            return false;
        }
        AxisIterator anc = ((NodeInfo)item).iterateAxis((byte)1);
        do {
            if ((a = anc.next()) != null) continue;
            return false;
        } while (!this.matchesBeneathAnchor((NodeInfo)item, (NodeInfo)a, context));
        return true;
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        if (!this.itemType.matches(node, context)) {
            return false;
        }
        if (anchor == null) {
            Object ancestor;
            AxisIterator ancestors = node.iterateAxis((byte)1);
            do {
                if ((ancestor = ancestors.next()) != null) continue;
                return false;
            } while (!this.matchesBeneathAnchor(node, (NodeInfo)ancestor, context));
            return true;
        }
        XPathContextMinor c2 = context.newMinorContext();
        UnfailingIterator<NodeInfo> single = SingletonIterator.makeIterator(anchor);
        single.next();
        c2.setCurrentIterator(single);
        try {
            NodeInfo n;
            SequenceIterator<? extends Item> nsv = this.equivalentExpr.iterate(c2);
            do {
                if ((n = (NodeInfo)nsv.next()) != null) continue;
                return false;
            } while (!n.isSameNodeInfo(node));
            return true;
        }
        catch (XPathException e) {
            XPathException err = new XPathException("An error occurred matching pattern {" + this.toString() + "}: ", e);
            err.setXPathContext(c2);
            err.setErrorCodeQName(e.getErrorCodeQName());
            err.setLocator(this);
            c2.getController().recoverableError(err);
            return false;
        }
    }

    @Override
    public int getNodeKind() {
        return this.itemType.getPrimitiveType();
    }

    @Override
    public int getFingerprint() {
        return this.itemType.getFingerprint();
    }

    @Override
    public ItemType getItemType() {
        return this.itemType;
    }

    public boolean equals(Object other) {
        if (other instanceof GeneralNodePattern) {
            GeneralNodePattern lpp = (GeneralNodePattern)other;
            return this.equivalentExpr.equals(lpp.equivalentExpr);
        }
        return false;
    }

    public int hashCode() {
        return 0x146B9 ^ this.equivalentExpr.hashCode();
    }
}

