/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicScrollBarUI
extends ScrollBarUI
implements LayoutManager,
SwingConstants {
    protected static final int DECREASE_HIGHLIGHT = 1;
    protected static final int INCREASE_HIGHLIGHT = 2;
    protected static final int NO_HIGHLIGHT = 0;
    private static final int POSITIVE_SCROLL = 1;
    private static final int NEGATIVE_SCROLL = -1;
    protected ArrowButtonListener buttonListener;
    protected ModelListener modelListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ScrollListener scrollListener;
    protected TrackListener trackListener;
    protected JButton decrButton;
    protected JButton incrButton;
    protected Dimension maximumThumbSize;
    protected Dimension minimumThumbSize;
    protected Color thumbColor;
    protected Color thumbDarkShadowColor;
    protected Color thumbHighlightColor;
    protected Color thumbLightShadowColor;
    protected Color trackHighlightColor;
    protected Color trackColor;
    protected Rectangle trackRect;
    protected Rectangle thumbRect;
    private transient Dimension preferredSize;
    protected int trackHighlight;
    protected boolean isDragging;
    protected Timer scrollTimer;
    protected JScrollBar scrollbar;

    public void addLayoutComponent(String name, Component child) {
    }

    protected void configureScrollBarColors() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.trackColor = defaults.getColor("ScrollBar.track");
        this.trackHighlightColor = defaults.getColor("ScrollBar.trackHighlight");
        this.thumbColor = defaults.getColor("ScrollBar.thumb");
        this.thumbHighlightColor = defaults.getColor("ScrollBar.thumbHighlight");
        this.thumbDarkShadowColor = defaults.getColor("ScrollBar.thumbDarkShadow");
        this.thumbLightShadowColor = defaults.getColor("ScrollBar.thumbShadow");
    }

    protected ArrowButtonListener createArrowButtonListener() {
        return new ArrowButtonListener();
    }

    protected JButton createIncreaseButton(int orientation) {
        return new BasicArrowButton(orientation);
    }

    protected JButton createDecreaseButton(int orientation) {
        return new BasicArrowButton(orientation);
    }

    protected ModelListener createModelListener() {
        return new ModelListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected ScrollListener createScrollListener() {
        return new ScrollListener();
    }

    protected TrackListener createTrackListener() {
        return new TrackListener();
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicScrollBarUI();
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected Dimension getMaximumThumbSize() {
        return this.maximumThumbSize;
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    protected Dimension getMinimumThumbSize() {
        return this.minimumThumbSize;
    }

    void calculatePreferredSize() {
        int width = 0;
        int height = 0;
        if (this.scrollbar.getOrientation() == 0) {
            width = (int)((double)width + this.incrButton.getPreferredSize().getWidth());
            width = (int)((double)width + this.decrButton.getPreferredSize().getWidth());
            width += this.scrollbar.getMaximum() - this.scrollbar.getMinimum();
            height = Math.max(this.incrButton.getPreferredSize().height, this.decrButton.getPreferredSize().height);
            height = Math.max(this.getMinimumThumbSize().height, height);
            height = Math.min(this.getMaximumThumbSize().height, height);
        } else {
            height = (int)((double)height + this.incrButton.getPreferredSize().getHeight());
            height = (int)((double)height + this.decrButton.getPreferredSize().getHeight());
            height += this.scrollbar.getMaximum() - this.scrollbar.getMinimum();
            width = Math.max(this.incrButton.getPreferredSize().width, this.decrButton.getPreferredSize().width);
            width = Math.max(this.getMinimumThumbSize().width, width);
            width = Math.min(this.getMaximumThumbSize().width, width);
        }
        Insets insets = this.scrollbar.getInsets();
        this.preferredSize = new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    public Dimension getPreferredSize(JComponent c) {
        this.calculatePreferredSize();
        return this.preferredSize;
    }

    protected Rectangle getThumbBounds() {
        return this.thumbRect;
    }

    protected Rectangle getTrackBounds() {
        return this.trackRect;
    }

    protected void installComponents() {
        if (this.incrButton != null) {
            this.scrollbar.add(this.incrButton);
        }
        if (this.decrButton != null) {
            this.scrollbar.add(this.decrButton);
        }
    }

    protected void installDefaults() {
        int orientation = this.scrollbar.getOrientation();
        switch (orientation) {
            case 0: {
                this.incrButton = this.createIncreaseButton(3);
                this.decrButton = this.createDecreaseButton(7);
                break;
            }
            default: {
                this.incrButton = this.createIncreaseButton(5);
                this.decrButton = this.createDecreaseButton(1);
                break;
            }
        }
        LookAndFeel.installColors(this.scrollbar, "ScrollBar.background", "ScrollBar.foreground");
        LookAndFeel.installBorder(this.scrollbar, "ScrollBar.border");
        this.scrollbar.setOpaque(true);
        this.scrollbar.setLayout(this);
        this.thumbColor = UIManager.getColor("ScrollBar.thumb");
        this.thumbDarkShadowColor = UIManager.getColor("ScrollBar.thumbDarkShadow");
        this.thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        this.thumbLightShadowColor = UIManager.getColor("ScrollBar.thumbShadow");
        this.maximumThumbSize = UIManager.getDimension("ScrollBar.maximumThumbSize");
        this.minimumThumbSize = UIManager.getDimension("ScrollBar.minimumThumbSize");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.scrollListener = this.createScrollListener();
        this.trackListener = this.createTrackListener();
        this.buttonListener = this.createArrowButtonListener();
        this.modelListener = this.createModelListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.scrollbar.addMouseMotionListener(this.trackListener);
        this.scrollbar.addMouseListener(this.trackListener);
        this.incrButton.addMouseListener(this.buttonListener);
        this.decrButton.addMouseListener(this.buttonListener);
        this.scrollbar.addPropertyChangeListener(this.propertyChangeListener);
        this.scrollbar.getModel().addChangeListener(this.modelListener);
        this.scrollTimer.addActionListener(this.scrollListener);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JScrollBar) {
            this.scrollbar = (JScrollBar)c;
            this.trackRect = new Rectangle();
            this.thumbRect = new Rectangle();
            this.scrollTimer = new Timer(300, null);
            this.installDefaults();
            this.installComponents();
            this.configureScrollBarColors();
            this.installListeners();
            this.calculatePreferredSize();
        }
    }

    public void layoutContainer(Container scrollbarContainer) {
        if (scrollbarContainer instanceof JScrollBar) {
            if (this.scrollbar.getOrientation() == 0) {
                this.layoutHScrollbar((JScrollBar)scrollbarContainer);
            } else {
                this.layoutVScrollbar((JScrollBar)scrollbarContainer);
            }
        }
    }

    protected void layoutHScrollbar(JScrollBar sb) {
        Rectangle vr = new Rectangle();
        SwingUtilities.calculateInnerArea(this.scrollbar, vr);
        Dimension incrDims = this.incrButton.getPreferredSize();
        Dimension decrDims = this.decrButton.getPreferredSize();
        SwingUtilities.calculateInnerArea(this.scrollbar, this.trackRect);
        this.trackRect.width = (int)((double)this.trackRect.width - incrDims.getWidth());
        this.trackRect.width = (int)((double)this.trackRect.width - decrDims.getWidth());
        this.trackRect.x = (int)((double)this.trackRect.x + decrDims.getWidth());
        this.updateThumbRect();
        this.decrButton.setBounds(vr.x, vr.y, decrDims.width, this.trackRect.height);
        this.incrButton.setBounds(this.trackRect.x + this.trackRect.width, vr.y, incrDims.width, this.trackRect.height);
    }

    protected void layoutVScrollbar(JScrollBar sb) {
        Rectangle vr = new Rectangle();
        SwingUtilities.calculateInnerArea(this.scrollbar, vr);
        Dimension incrDims = this.incrButton.getPreferredSize();
        Dimension decrDims = this.decrButton.getPreferredSize();
        SwingUtilities.calculateInnerArea(this.scrollbar, this.trackRect);
        this.trackRect.height = (int)((double)this.trackRect.height - incrDims.getHeight());
        this.trackRect.height = (int)((double)this.trackRect.height - decrDims.getHeight());
        this.trackRect.y = (int)((double)this.trackRect.y + decrDims.getHeight());
        this.updateThumbRect();
        this.decrButton.setBounds(vr.x, vr.y, this.trackRect.width, decrDims.height);
        this.incrButton.setBounds(vr.x, this.trackRect.y + this.trackRect.height, this.trackRect.width, incrDims.height);
    }

    void updateThumbRect() {
        int max = this.scrollbar.getMaximum();
        int min = this.scrollbar.getMinimum();
        int value = this.scrollbar.getValue();
        int extent = this.scrollbar.getVisibleAmount();
        if (max - extent <= min) {
            if (this.scrollbar.getOrientation() == 0) {
                this.thumbRect.x = this.trackRect.x;
                this.thumbRect.y = this.trackRect.y;
                this.thumbRect.width = this.getMinimumThumbSize().width;
                this.thumbRect.height = this.trackRect.height;
            } else {
                this.thumbRect.x = this.trackRect.x;
                this.thumbRect.y = this.trackRect.y;
                this.thumbRect.width = this.trackRect.width;
                this.thumbRect.height = this.getMinimumThumbSize().height;
            }
        } else if (this.scrollbar.getOrientation() == 0) {
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.width = Math.max(extent * this.trackRect.width / (max - min), this.getMinimumThumbSize().width);
            int availableWidth = this.trackRect.width - this.thumbRect.width;
            this.thumbRect.x += (value - min) * availableWidth / (max - min - extent);
            this.thumbRect.y = this.trackRect.y;
            this.thumbRect.height = this.trackRect.height;
        } else {
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.height = Math.max(extent * this.trackRect.height / (max - min), this.getMinimumThumbSize().height);
            int availableHeight = this.trackRect.height - this.thumbRect.height;
            this.thumbRect.y = this.trackRect.y + (value - min) * availableHeight / (max - min - extent);
            this.thumbRect.width = this.trackRect.width;
        }
    }

    public Dimension minimumLayoutSize(Container scrollbarContainer) {
        return this.preferredLayoutSize(scrollbarContainer);
    }

    public void paint(Graphics g, JComponent c) {
        this.paintTrack(g, c, this.getTrackBounds());
        this.paintThumb(g, c, this.getThumbBounds());
        if (this.trackHighlight == 2) {
            this.paintIncreaseHighlight(g);
        } else if (this.trackHighlight == 1) {
            this.paintDecreaseHighlight(g);
        }
    }

    protected void paintDecreaseHighlight(Graphics g) {
        Color saved = g.getColor();
        g.setColor(this.trackHighlightColor);
        if (this.scrollbar.getOrientation() == 0) {
            g.fillRect(this.trackRect.x, this.trackRect.y, this.thumbRect.x - this.trackRect.x, this.trackRect.height);
        } else {
            g.fillRect(this.trackRect.x, this.trackRect.y, this.trackRect.width, this.thumbRect.y - this.trackRect.y);
        }
        g.setColor(saved);
    }

    protected void paintIncreaseHighlight(Graphics g) {
        Color saved = g.getColor();
        g.setColor(this.trackHighlightColor);
        if (this.scrollbar.getOrientation() == 0) {
            g.fillRect(this.thumbRect.x + this.thumbRect.width, this.trackRect.y, this.trackRect.x + this.trackRect.width - this.thumbRect.x - this.thumbRect.width, this.trackRect.height);
        } else {
            g.fillRect(this.trackRect.x, this.thumbRect.y + this.thumbRect.height, this.trackRect.width, this.trackRect.y + this.trackRect.height - this.thumbRect.y - this.thumbRect.height);
        }
        g.setColor(saved);
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        g.setColor(this.thumbColor);
        g.fillRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
        BasicGraphicsUtils.drawBezel(g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, false, false, this.thumbDarkShadowColor, this.thumbDarkShadowColor, this.thumbHighlightColor, this.thumbHighlightColor);
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        Color saved = g.getColor();
        g.setColor(this.trackColor);
        g.fill3DRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, false);
        g.setColor(saved);
    }

    public Dimension preferredLayoutSize(Container scrollbarContainer) {
        if (scrollbarContainer instanceof JComponent) {
            return this.getPreferredSize((JComponent)scrollbarContainer);
        }
        return null;
    }

    public void removeLayoutComponent(Component child) {
    }

    protected void scrollByBlock(int direction) {
        this.scrollbar.setValue(this.scrollbar.getValue() + this.scrollbar.getBlockIncrement(direction));
    }

    protected void scrollByUnit(int direction) {
        this.scrollbar.setValue(this.scrollbar.getValue() + this.scrollbar.getUnitIncrement(direction));
    }

    protected void setThumbBounds(int x, int y, int width, int height) {
        this.thumbRect.x = x;
        this.thumbRect.y = y;
        this.thumbRect.width = width;
        this.thumbRect.height = height;
    }

    protected void uninstallComponents() {
        if (this.incrButton != null) {
            this.scrollbar.remove(this.incrButton);
        }
        if (this.decrButton != null) {
            this.scrollbar.remove(this.decrButton);
        }
    }

    protected void uninstallDefaults() {
        this.scrollbar.setForeground(null);
        this.scrollbar.setBackground(null);
        LookAndFeel.uninstallBorder(this.scrollbar);
        this.incrButton = null;
        this.decrButton = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        if (this.scrollTimer != null) {
            this.scrollTimer.removeActionListener(this.scrollListener);
        }
        if (this.scrollbar != null) {
            this.scrollbar.getModel().removeChangeListener(this.modelListener);
            this.scrollbar.removePropertyChangeListener(this.propertyChangeListener);
            this.scrollbar.removeMouseListener(this.trackListener);
            this.scrollbar.removeMouseMotionListener(this.trackListener);
        }
        if (this.decrButton != null) {
            this.decrButton.removeMouseListener(this.buttonListener);
        }
        if (this.incrButton != null) {
            this.incrButton.removeMouseListener(this.buttonListener);
        }
        this.propertyChangeListener = null;
        this.modelListener = null;
        this.buttonListener = null;
        this.trackListener = null;
        this.scrollListener = null;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.scrollTimer = null;
        this.thumbRect = null;
        this.trackRect = null;
        this.trackColor = null;
        this.trackHighlightColor = null;
        this.thumbColor = null;
        this.thumbHighlightColor = null;
        this.thumbDarkShadowColor = null;
        this.thumbLightShadowColor = null;
        this.scrollbar = null;
    }

    int valueForYPosition(int yPos) {
        int min = this.scrollbar.getMinimum();
        int max = this.scrollbar.getMaximum();
        int len = this.trackRect.height;
        if (len == 0) {
            return (max - min) / 2;
        }
        int value = (yPos - this.trackRect.y) * (max - min) / len + min;
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    int valueForXPosition(int xPos) {
        int min = this.scrollbar.getMinimum();
        int max = this.scrollbar.getMaximum();
        int len = this.trackRect.width;
        if (len == 0) {
            return (max - min) / 2;
        }
        int value = (xPos - this.trackRect.x) * (max - min) / len + min;
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    static /* synthetic */ int access$0() {
        return 1;
    }

    static /* synthetic */ int access$1() {
        return -1;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ArrowButtonListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            BasicScrollBarUI.this.scrollTimer.stop();
            BasicScrollBarUI.this.scrollListener.setScrollByBlock(false);
            if (e.getSource() == BasicScrollBarUI.this.incrButton) {
                BasicScrollBarUI.this.scrollListener.setDirection(1);
            } else if (e.getSource() == BasicScrollBarUI.this.decrButton) {
                BasicScrollBarUI.this.scrollListener.setDirection(-1);
            }
            BasicScrollBarUI.this.scrollTimer.setDelay(100);
            BasicScrollBarUI.this.scrollTimer.start();
        }

        public void mouseReleased(MouseEvent e) {
            BasicScrollBarUI.this.scrollTimer.stop();
            BasicScrollBarUI.this.scrollTimer.setDelay(300);
            if (e.getSource() == BasicScrollBarUI.this.incrButton) {
                BasicScrollBarUI.this.scrollByUnit(1);
            } else if (e.getSource() == BasicScrollBarUI.this.decrButton) {
                BasicScrollBarUI.this.scrollByUnit(-1);
            }
        }

        protected ArrowButtonListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ModelListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            BasicScrollBarUI.this.calculatePreferredSize();
            BasicScrollBarUI.this.updateThumbRect();
            BasicScrollBarUI.this.scrollbar.repaint();
        }

        protected ModelListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("model")) {
                ((BoundedRangeModel)e.getOldValue()).removeChangeListener(BasicScrollBarUI.this.modelListener);
                BasicScrollBarUI.this.scrollbar.getModel().addChangeListener(BasicScrollBarUI.this.modelListener);
                BasicScrollBarUI.this.updateThumbRect();
            } else if (e.getPropertyName().equals("orientation")) {
                BasicScrollBarUI.this.uninstallListeners();
                BasicScrollBarUI.this.uninstallComponents();
                BasicScrollBarUI.this.uninstallDefaults();
                BasicScrollBarUI.this.installDefaults();
                BasicScrollBarUI.this.installComponents();
                BasicScrollBarUI.this.installListeners();
            } else if (e.getPropertyName().equals("enabled")) {
                Boolean b = (Boolean)e.getNewValue();
                if (BasicScrollBarUI.this.incrButton != null) {
                    BasicScrollBarUI.this.incrButton.setEnabled(b);
                }
                if (BasicScrollBarUI.this.decrButton != null) {
                    BasicScrollBarUI.this.decrButton.setEnabled(b);
                }
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class ScrollListener
    implements ActionListener {
        private transient int direction;
        private transient boolean block;

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public void setScrollByBlock(boolean block) {
            this.block = block;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.block) {
                if (!BasicScrollBarUI.this.trackListener.shouldScroll(this.direction)) {
                    BasicScrollBarUI.this.trackHighlight = 0;
                    BasicScrollBarUI.this.scrollbar.repaint();
                    return;
                }
                BasicScrollBarUI.this.scrollByBlock(this.direction);
            } else {
                BasicScrollBarUI.this.scrollByUnit(this.direction);
            }
        }

        public ScrollListener() {
            this.direction = 1;
            this.block = true;
        }

        public ScrollListener(int dir, boolean block) {
            this.direction = dir;
            this.block = block;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class TrackListener
    extends MouseAdapter
    implements MouseMotionListener {
        protected int currentMouseX;
        protected int currentMouseY;
        protected int offset;

        public void mouseDragged(MouseEvent e) {
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (BasicScrollBarUI.this.scrollbar.getValueIsAdjusting()) {
                int value = BasicScrollBarUI.this.scrollbar.getOrientation() == 0 ? BasicScrollBarUI.this.valueForXPosition(this.currentMouseX) - this.offset : BasicScrollBarUI.this.valueForYPosition(this.currentMouseY) - this.offset;
                BasicScrollBarUI.this.scrollbar.setValue(value);
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            int value = BasicScrollBarUI.this.scrollbar.getOrientation() == 0 ? BasicScrollBarUI.this.valueForXPosition(this.currentMouseX) : BasicScrollBarUI.this.valueForYPosition(this.currentMouseY);
            if (!BasicScrollBarUI.this.thumbRect.contains(e.getPoint())) {
                BasicScrollBarUI.this.scrollTimer.stop();
                BasicScrollBarUI.this.scrollListener.setScrollByBlock(true);
                if (value > BasicScrollBarUI.this.scrollbar.getValue()) {
                    BasicScrollBarUI.this.trackHighlight = 2;
                    BasicScrollBarUI.this.scrollListener.setDirection(1);
                } else {
                    BasicScrollBarUI.this.trackHighlight = 1;
                    BasicScrollBarUI.this.scrollListener.setDirection(-1);
                }
                BasicScrollBarUI.this.scrollTimer.setDelay(100);
                BasicScrollBarUI.this.scrollTimer.start();
            } else {
                BasicScrollBarUI.this.scrollListener.setScrollByBlock(false);
                BasicScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
                this.offset = value - BasicScrollBarUI.this.scrollbar.getValue();
            }
            BasicScrollBarUI.this.scrollbar.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            BasicScrollBarUI.this.scrollTimer.stop();
            BasicScrollBarUI.this.scrollTimer.setDelay(300);
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (this.shouldScroll(1)) {
                BasicScrollBarUI.this.scrollByBlock(1);
            } else if (this.shouldScroll(-1)) {
                BasicScrollBarUI.this.scrollByBlock(-1);
            }
            BasicScrollBarUI.this.trackHighlight = 0;
            BasicScrollBarUI.this.scrollListener.setScrollByBlock(false);
            BasicScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            BasicScrollBarUI.this.scrollbar.repaint();
        }

        public boolean shouldScroll(int direction) {
            int value = BasicScrollBarUI.this.scrollbar.getOrientation() == 0 ? BasicScrollBarUI.this.valueForXPosition(this.currentMouseX) : BasicScrollBarUI.this.valueForYPosition(this.currentMouseY);
            if (BasicScrollBarUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                return false;
            }
            if (direction == 1) {
                boolean bl = false;
                if (value > BasicScrollBarUI.this.scrollbar.getValue()) {
                    bl = true;
                }
                return bl;
            }
            boolean bl = false;
            if (value < BasicScrollBarUI.this.scrollbar.getValue()) {
                bl = true;
            }
            return bl;
        }

        protected TrackListener() {
        }
    }
}

