/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Spring;

public class SpringLayout
implements LayoutManager2 {
    public static final String EAST = "East";
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String WEST = "West";
    private Map constraintsMap = new HashMap();

    public void addLayoutComponent(Component component, Object constraint) {
        this.constraintsMap.put(component, constraint);
    }

    public void addLayoutComponent(String name, Component c) {
    }

    public Spring getConstraint(String edgeName, Component c) {
        Constraints constraints = this.getConstraints(c);
        return constraints.getConstraint(edgeName);
    }

    public Constraints getConstraints(Component c) {
        Constraints constraints = (Constraints)this.constraintsMap.get(c);
        if (constraints == null) {
            Container parent = c.getParent();
            constraints = new Constraints();
            if (parent != null) {
                constraints.setX(Spring.constant(parent.getInsets().left));
                constraints.setY(Spring.constant(parent.getInsets().top));
            } else {
                constraints.setX(Spring.constant(0));
                constraints.setY(Spring.constant(0));
            }
        }
        constraints.setWidth(Spring.constant(c.getMinimumSize().width, c.getPreferredSize().width, c.getMaximumSize().width));
        constraints.setHeight(Spring.constant(c.getMinimumSize().height, c.getPreferredSize().height, c.getMaximumSize().height));
        this.constraintsMap.put(c, constraints);
        return constraints;
    }

    public float getLayoutAlignmentX(Container p) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container p) {
        return 0.0f;
    }

    public void invalidateLayout(Container p) {
    }

    public void layoutContainer(Container p) {
        this.addLayoutComponent(p, new Constraints(Spring.constant(0), Spring.constant(0)));
        int offsetX = p.getInsets().left;
        int offsetY = p.getInsets().right;
        Component[] components = p.getComponents();
        int index = 0;
        while (index < components.length) {
            Component c = components[index];
            Constraints constraints = this.getConstraints(c);
            int x = constraints.getX().getValue();
            int y = constraints.getY().getValue();
            int width = constraints.getWidth().getValue();
            int height = constraints.getHeight().getValue();
            c.setLocation(x + offsetX, y + offsetY);
            c.setSize(width, height);
            ++index;
        }
    }

    public Dimension maximumLayoutSize(Container p) {
        int maxX = 0;
        int maxY = 0;
        int offsetX = p.getInsets().left;
        int offsetY = p.getInsets().right;
        Component[] components = p.getComponents();
        int index = 0;
        while (index < components.length) {
            int bottomEdge;
            Component c = components[index];
            Constraints constraints = this.getConstraints(c);
            int x = constraints.getX().getMaximumValue();
            int y = constraints.getY().getMaximumValue();
            int width = constraints.getWidth().getMaximumValue();
            int height = constraints.getHeight().getMaximumValue();
            int rightEdge = offsetX + x + width;
            if (rightEdge > maxX) {
                maxX = rightEdge;
            }
            if ((bottomEdge = offsetY + y + height) > maxY) {
                maxY = bottomEdge;
            }
            ++index;
        }
        return new Dimension(maxX, maxY);
    }

    public Dimension minimumLayoutSize(Container p) {
        int maxX = 0;
        int maxY = 0;
        int offsetX = p.getInsets().left;
        int offsetY = p.getInsets().right;
        Component[] components = p.getComponents();
        int index = 0;
        while (index < components.length) {
            int bottomEdge;
            Component c = components[index];
            Constraints constraints = this.getConstraints(c);
            int x = constraints.getX().getMinimumValue();
            int y = constraints.getY().getMinimumValue();
            int width = constraints.getWidth().getMinimumValue();
            int height = constraints.getHeight().getMinimumValue();
            int rightEdge = offsetX + x + width;
            if (rightEdge > maxX) {
                maxX = rightEdge;
            }
            if ((bottomEdge = offsetY + y + height) > maxY) {
                maxY = bottomEdge;
            }
            ++index;
        }
        return new Dimension(maxX, maxY);
    }

    public Dimension preferredLayoutSize(Container p) {
        int maxX = 0;
        int maxY = 0;
        int offsetX = p.getInsets().left;
        int offsetY = p.getInsets().right;
        Component[] components = p.getComponents();
        int index = 0;
        while (index < components.length) {
            int bottomEdge;
            Component c = components[index];
            Constraints constraints = this.getConstraints(c);
            int x = constraints.getX().getPreferredValue();
            int y = constraints.getY().getPreferredValue();
            int width = constraints.getWidth().getPreferredValue();
            int height = constraints.getHeight().getPreferredValue();
            int rightEdge = offsetX + x + width;
            if (rightEdge > maxX) {
                maxX = rightEdge;
            }
            if ((bottomEdge = offsetY + y + height) > maxY) {
                maxY = bottomEdge;
            }
            ++index;
        }
        return new Dimension(maxX, maxY);
    }

    public void putConstraint(String e1, Component c1, int pad, String e2, Component c2) {
        Constraints constraints1 = this.getConstraints(c1);
        Constraints constraints2 = this.getConstraints(c2);
        Spring strut = Spring.constant(pad);
        Spring otherEdge = constraints2.getConstraint(e2);
        constraints1.setConstraint(e1, Spring.sum(strut, otherEdge));
    }

    public void putConstraint(String e1, Component c1, Spring s, String e2, Component c2) {
        Constraints constraints1 = this.getConstraints(c1);
        Constraints constraints2 = this.getConstraints(c2);
        Spring otherEdge = constraints2.getConstraint(e2);
        constraints1.setConstraint(e1, Spring.sum(s, otherEdge));
    }

    public void removeLayoutComponent(Component c) {
    }

    public static class Constraints {
        private Spring x;
        private Spring y;
        private Spring height;
        private Spring width;
        private Spring east;
        private Spring south;

        public Spring getConstraint(String edgeName) {
            Spring retVal = null;
            if (edgeName.equals(SpringLayout.NORTH)) {
                retVal = this.y;
            } else if (edgeName.equals(SpringLayout.WEST)) {
                retVal = this.x;
            } else if (edgeName.equals(SpringLayout.SOUTH)) {
                retVal = this.south;
                if (retVal == null && this.y != null && this.height != null) {
                    retVal = Spring.sum(this.y, this.height);
                }
            } else if (edgeName.equals(SpringLayout.EAST) && (retVal = this.east) == null && this.x != null && this.width != null) {
                retVal = Spring.sum(this.x, this.width);
            }
            return retVal;
        }

        public Spring getHeight() {
            Spring retVal = this.height;
            if (retVal == null && this.y != null && this.south != null) {
                retVal = Spring.sum(this.south, Spring.minus(this.y));
            }
            return retVal;
        }

        public Spring getWidth() {
            Spring retVal = this.width;
            if (retVal == null && this.x != null && this.east != null) {
                retVal = Spring.sum(this.east, Spring.minus(this.x));
            }
            return retVal;
        }

        public Spring getX() {
            Spring retVal = this.x;
            if (retVal == null && this.width != null && this.east != null) {
                retVal = Spring.sum(this.east, Spring.minus(this.width));
            }
            return retVal;
        }

        public Spring getY() {
            Spring retVal = this.y;
            if (retVal == null && this.height != null && this.south != null) {
                retVal = Spring.sum(this.south, Spring.minus(this.height));
            }
            return retVal;
        }

        public void setConstraint(String edgeName, Spring s) {
            if (edgeName.equals(SpringLayout.WEST)) {
                this.x = s;
                if (this.width != null && this.east != null) {
                    this.width = Spring.sum(this.east, Spring.minus(this.x));
                }
            } else if (edgeName.equals(SpringLayout.NORTH)) {
                this.y = s;
                if (this.height != null && this.south != null) {
                    this.height = Spring.sum(this.south, Spring.minus(this.y));
                }
            } else if (edgeName.equals(SpringLayout.EAST)) {
                this.east = s;
                if (this.x != null && this.width != null) {
                    this.x = Spring.sum(this.east, Spring.minus(this.width));
                }
            } else if (edgeName.equals(SpringLayout.SOUTH)) {
                this.south = s;
                if (this.height != null && this.y != null) {
                    this.y = Spring.sum(this.south, Spring.minus(this.height));
                }
            }
        }

        public void setHeight(Spring s) {
            this.height = s;
            if (this.south != null && this.y != null) {
                this.south = Spring.sum(this.y, this.height);
            }
        }

        public void setWidth(Spring s) {
            this.width = s;
            if (this.east != null && this.x != null) {
                this.east = Spring.sum(this.x, this.width);
            }
        }

        public void setX(Spring s) {
            this.x = s;
            if (this.width != null && this.east != null) {
                this.width = Spring.sum(this.east, Spring.minus(this.x));
            }
        }

        public void setY(Spring s) {
            this.y = s;
            if (this.height != null && this.south != null) {
                this.height = Spring.sum(this.south, Spring.minus(this.y));
            }
        }

        public Constraints() {
            this.south = null;
            this.east = null;
            this.width = null;
            this.height = null;
            this.y = null;
            this.x = null;
        }

        public Constraints(Spring x, Spring y) {
            this.x = x;
            this.y = y;
            this.south = null;
            this.east = null;
            this.height = null;
            this.width = null;
        }

        public Constraints(Spring x, Spring y, Spring width, Spring height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.south = null;
            this.east = null;
        }
    }
}

