/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;

public abstract class MidiMessage
implements Cloneable {
    protected byte[] data;
    protected int length;

    protected void setMessage(byte[] data, int length) throws InvalidMidiDataException {
        this.data = new byte[length];
        System.arraycopy(data, 0, this.data, 0, length);
        this.length = length;
    }

    public byte[] getMessage() {
        byte[] copy = new byte[this.length];
        System.arraycopy(this.data, 0, copy, 0, this.length);
        return copy;
    }

    public int getStatus() {
        if (this.length > 0) {
            return this.data[0] & 0xFF;
        }
        return 0;
    }

    public int getLength() {
        return this.length;
    }

    public abstract Object clone();

    protected MidiMessage(byte[] data) {
        this.data = data;
        this.length = data.length;
    }
}

