/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollbarPeer;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Scrollbar
extends Component
implements Accessible,
Adjustable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final long serialVersionUID = 8451667562882310543L;
    private static transient long next_scrollbar_number;
    private int lineIncrement;
    private int pageIncrement;
    private int maximum;
    private int minimum;
    private int orientation;
    private int value;
    private int visibleAmount;
    private AdjustmentListener adjustment_listeners;
    private transient boolean valueIsAdjusting;
    static /* synthetic */ Class class$java$awt$event$AdjustmentListener;

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("Bad orientation value: " + orientation);
        }
        this.orientation = orientation;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.setValues(value, this.visibleAmount, this.minimum, this.maximum);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.setValues(this.value, this.visibleAmount, this.minimum, maximum);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.setValues(this.value, this.visibleAmount, minimum, this.maximum);
    }

    public int getVisibleAmount() {
        return this.getVisible();
    }

    public int getVisible() {
        return this.visibleAmount;
    }

    public void setVisibleAmount(int visibleAmount) {
        this.setValues(this.value, visibleAmount, this.minimum, this.maximum);
    }

    public synchronized void setValues(int value, int visibleAmount, int minimum, int maximum) {
        ScrollbarPeer peer;
        if (maximum < minimum) {
            maximum = minimum;
        }
        if (value < minimum) {
            value = minimum;
        }
        if (value > maximum) {
            value = maximum;
        }
        if (visibleAmount > maximum - minimum) {
            visibleAmount = maximum - minimum;
        }
        if ((peer = (ScrollbarPeer)this.getPeer()) != null && (this.value != value || this.visibleAmount != visibleAmount || this.minimum != minimum || this.maximum != maximum)) {
            peer.setValues(value, visibleAmount, minimum, maximum);
        }
        this.value = value;
        this.visibleAmount = visibleAmount;
        this.minimum = minimum;
        this.maximum = maximum;
        int range = maximum - minimum;
        if (this.lineIncrement > range) {
            this.lineIncrement = range == 0 ? 1 : range;
            if (peer != null) {
                peer.setLineIncrement(this.lineIncrement);
            }
        }
        if (this.pageIncrement > range) {
            this.pageIncrement = range == 0 ? 1 : range;
            if (peer != null) {
                peer.setPageIncrement(this.pageIncrement);
            }
        }
    }

    public int getUnitIncrement() {
        return this.getLineIncrement();
    }

    public int getLineIncrement() {
        return this.lineIncrement;
    }

    public synchronized void setUnitIncrement(int unitIncrement) {
        this.setLineIncrement(unitIncrement);
    }

    public void setLineIncrement(int lineIncrement) {
        if (lineIncrement < 0) {
            throw new IllegalArgumentException("Unit increment less than zero.");
        }
        int range = this.maximum - this.minimum;
        if (lineIncrement > range) {
            lineIncrement = range == 0 ? 1 : range;
        }
        if (lineIncrement == this.lineIncrement) {
            return;
        }
        this.lineIncrement = lineIncrement;
        ScrollbarPeer peer = (ScrollbarPeer)this.getPeer();
        if (peer != null) {
            peer.setLineIncrement(this.lineIncrement);
        }
    }

    public int getBlockIncrement() {
        return this.getPageIncrement();
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    public synchronized void setBlockIncrement(int blockIncrement) {
        this.setPageIncrement(blockIncrement);
    }

    public void setPageIncrement(int pageIncrement) {
        if (pageIncrement < 0) {
            throw new IllegalArgumentException("Block increment less than zero.");
        }
        int range = this.maximum - this.minimum;
        if (pageIncrement > range) {
            pageIncrement = range == 0 ? 1 : range;
        }
        if (pageIncrement == this.pageIncrement) {
            return;
        }
        this.pageIncrement = pageIncrement;
        ScrollbarPeer peer = (ScrollbarPeer)this.getPeer();
        if (peer != null) {
            peer.setPageIncrement(this.pageIncrement);
        }
    }

    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createScrollbar(this);
        }
        super.addNotify();
    }

    public synchronized void addAdjustmentListener(AdjustmentListener listener) {
        this.adjustment_listeners = AWTEventMulticaster.add(this.adjustment_listeners, listener);
        this.enableEvents(256L);
    }

    public synchronized void removeAdjustmentListener(AdjustmentListener listener) {
        this.adjustment_listeners = AWTEventMulticaster.remove(this.adjustment_listeners, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processAdjustmentEvent(AdjustmentEvent event) {
        this.value = event.getValue();
        if (this.adjustment_listeners != null) {
            this.adjustment_listeners.adjustmentValueChanged(event);
        }
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 601 && e.id >= 601 && (this.adjustment_listeners != null || (this.eventMask & 0x100L) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    protected String paramString() {
        return "value=" + this.getValue() + ",visibleAmount=" + this.getVisibleAmount() + ",minimum=" + this.getMinimum() + ",maximum=" + this.getMaximum() + ",pageIncrement=" + this.pageIncrement + ",lineIncrement=" + this.lineIncrement + ",orientation=" + (this.orientation == 0 ? "HORIZONTAL" : "VERTICAL") + super.paramString();
    }

    public EventListener[] getListeners(Class listenerType) {
        Class clazz = class$java$awt$event$AdjustmentListener;
        if (clazz == null) {
            clazz = class$java$awt$event$AdjustmentListener = Scrollbar.class("[Ljava.awt.event.AdjustmentListener;", false);
        }
        if (listenerType == clazz) {
            return AWTEventMulticaster.getListeners(this.adjustment_listeners, listenerType);
        }
        return super.getListeners(listenerType);
    }

    public AdjustmentListener[] getAdjustmentListeners() {
        Class clazz = class$java$awt$event$AdjustmentListener;
        if (clazz == null) {
            clazz = class$java$awt$event$AdjustmentListener = Scrollbar.class("[Ljava.awt.event.AdjustmentListener;", false);
        }
        return (AdjustmentListener[])this.getListeners(clazz);
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }

    String generateName() {
        return "scrollbar" + Scrollbar.getUniqueLong();
    }

    private static final synchronized long getUniqueLong() {
        return next_scrollbar_number++;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTScrollBar();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.valueIsAdjusting = false;
    }

    public Scrollbar() {
        this(1);
    }

    public Scrollbar(int orientation) throws IllegalArgumentException {
        this(orientation, 0, 10, 0, 100);
    }

    public Scrollbar(int orientation, int value, int visibleAmount, int minimum, int maximum) throws IllegalArgumentException {
        this.this();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("Bad orientation value: " + orientation);
        }
        this.orientation = orientation;
        this.setValues(value, visibleAmount, minimum, maximum);
        this.lineIncrement = 1;
        this.pageIncrement = 10;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTScrollBar
    extends Component.AccessibleAWTComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -344337268523697807L;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_BAR;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (Scrollbar.this.getOrientation() == 0) {
                states.add(AccessibleState.HORIZONTAL);
            } else {
                states.add(AccessibleState.VERTICAL);
            }
            if (Scrollbar.this.getValueIsAdjusting()) {
                states.add(AccessibleState.BUSY);
            }
            return states;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(Scrollbar.this.getValue());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            Scrollbar.this.setValue(number.intValue());
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(Scrollbar.this.getMinimum());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(Scrollbar.this.getMaximum());
        }

        protected AccessibleAWTScrollBar() {
        }
    }
}

