/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import b.h.la;
import com.intellij.CommonBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageTableModel;
import com.intellij.coverage.view.CoverageViewBuilder;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewTreeStructure;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.impl.RunDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CoverageView
extends BorderLayoutPanel
implements DataProvider,
Disposable {
    @NonNls
    private static final String e = "DrillDown";
    @NonNls
    private static final String b = "GoUp";
    @NonNls
    public static final String HELP_ID = "reference.toolWindows.Coverage";
    private final CoverageTableModel d;
    private final JBTable a;
    private final CoverageViewBuilder c;
    private final Project f;
    private final CoverageViewManager.StateBean g;
    private static final long h = la.a(-7563320367126712435L, 5070725560047214656L, MethodHandles.lookup().lookupClass()).a(140426057677545L);

    public CoverageView(final Project project, CoverageDataManager dataManager, CoverageViewManager.StateBean stateBean) {
        long l2 = h ^ 0x41E3F14C070L;
        this.f = project;
        this.g = stateBean;
        JLabel jLabel = new JLabel();
        jLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        CoverageSuitesBundle coverageSuitesBundle = dataManager.getCurrentSuitesBundle();
        this.d = new CoverageTableModel(coverageSuitesBundle, stateBean, project);
        this.a = new JBTable((TableModel)this.d);
        StatusText statusText = this.a.getEmptyText();
        statusText.setText("No coverage results.");
        final RunConfigurationBase runConfigurationBase = coverageSuitesBundle.getRunConfiguration();
        if (runConfigurationBase != null) {
            statusText.appendText(" Click ");
            statusText.appendText("Edit", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){
                private static final long a = la.a(3280924045712945686L, 5645417746123978038L, MethodHandles.lookup().lookupClass()).a(176164918582596L);

                @Override
                public void actionPerformed(ActionEvent e10) {
                    long l2 = a ^ 0x176021CF388EL;
                    RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance((Project)project).findSettings((RunConfiguration)runConfigurationBase);
                    if (runnerAndConfigurationSettings != null) {
                        RunDialog.editConfiguration((Project)project, (RunnerAndConfigurationSettings)runnerAndConfigurationSettings, (String)"Edit Run Configuration");
                    } else {
                        Messages.showErrorDialog((Project)project, (String)("Configuration '" + runConfigurationBase.getName() + "' was not found"), (String)CommonBundle.getErrorTitle());
                    }
                }
            });
            statusText.appendText(" to fix configuration settings.");
        }
        TableColumnModel tableColumnModel = this.a.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new NodeDescriptorTableCellRenderer());
        tableColumn.setPreferredWidth(this.g.myElementSize);
        this.a.getTableHeader().setReorderingAllowed(false);
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel().addToCenter((Component)ScrollPaneFactory.createScrollPane((Component)this.a)).addToTop((Component)jLabel);
        this.addToCenter((Component)borderLayoutPanel);
        final CoverageViewTreeStructure coverageViewTreeStructure = new CoverageViewTreeStructure(project, coverageSuitesBundle, stateBean);
        this.c = new CoverageViewBuilder(project, (JList)new JBList(), this.d, coverageViewTreeStructure, this.a);
        this.c.setParentTitle(jLabel);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e10) {
                CoverageView.this.a(coverageViewTreeStructure);
                return true;
            }
        }.installOn((Component)this.a);
        TableSpeedSearch tableSpeedSearch = new TableSpeedSearch((JTable)this.a);
        tableSpeedSearch.setClearSearchOnNavigateNoMatch(true);
        PopupHandler.installUnknownPopupHandler((JComponent)this.a, (ActionGroup)CoverageView.b(), (ActionManager)ActionManager.getInstance());
        ScrollingUtil.installActions((JTable)this.a);
        this.a.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                if (CoverageView.this.c == null) {
                    return;
                }
                CoverageView.this.c.buildRoot();
            }
        }, KeyStroke.getKeyStroke(92, SystemInfo.isMac ? 4 : 2), 0);
        this.a.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), e);
        this.a.getInputMap(0).put(KeyStroke.getKeyStroke(34, SystemInfo.isMac ? 4 : 2), e);
        this.a.getActionMap().put(e, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                CoverageView.this.a(coverageViewTreeStructure);
            }
        });
        this.a.getInputMap(0).put(KeyStroke.getKeyStroke(33, SystemInfo.isMac ? 4 : 2), b);
        this.a.getInputMap(0).put(KeyStroke.getKeyStroke(8, 0), b);
        this.a.getActionMap().put(b, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                CoverageView.this.goUp();
            }
        });
        JComponent jComponent = ActionManager.getInstance().createActionToolbar("CoverageView", this.b(coverageViewTreeStructure), false).getComponent();
        this.addToLeft(jComponent);
    }

    public void dispose() {
        if (!this.f.isDisposed()) {
            CoverageDataManager.getInstance(this.f).chooseSuitesBundle(null);
        }
    }

    public void saveSize() {
        this.g.myElementSize = this.a.getColumnModel().getColumn(0).getWidth();
    }

    private static ActionGroup b() {
        long l2 = h ^ 0x7632C2C3D5AAL;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add(ActionManager.getInstance().getAction("EditSource"));
        return defaultActionGroup;
    }

    private ActionGroup b(CoverageViewTreeStructure coverageViewTreeStructure) {
        long l2 = h ^ 0x693A07206294L;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add((AnAction)new GoUpAction(this, coverageViewTreeStructure));
        if (coverageViewTreeStructure.supportFlattenPackages()) {
            defaultActionGroup.add((AnAction)new FlattenPackagesAction(this));
        }
        this.a(defaultActionGroup);
        this.b(defaultActionGroup);
        defaultActionGroup.add(ActionManager.getInstance().getAction("GenerateCoverageReport"));
        return defaultActionGroup;
    }

    private void b(DefaultActionGroup defaultActionGroup) {
        MyAutoScrollFromSourceHandler myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler();
        myAutoScrollFromSourceHandler.install();
        defaultActionGroup.add((AnAction)myAutoScrollFromSourceHandler.createToggleAction());
    }

    private void a(DefaultActionGroup defaultActionGroup) {
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return ((CoverageView)CoverageView.this).g.myAutoScrollToSource;
            }

            protected void setAutoScrollMode(boolean state) {
                ((CoverageView)CoverageView.this).g.myAutoScrollToSource = state;
            }
        };
        autoScrollToSourceHandler.install((JTable)this.a);
        defaultActionGroup.add((AnAction)autoScrollToSourceHandler.createToggleAction());
    }

    public void goUp() {
        if (this.c == null) {
            return;
        }
        this.c.goUp();
    }

    private void a(CoverageViewTreeStructure coverageViewTreeStructure) {
        AbstractTreeNode abstractTreeNode = this.a();
        if (abstractTreeNode == null) {
            return;
        }
        if (coverageViewTreeStructure.getChildElements(abstractTreeNode).length == 0) {
            if (abstractTreeNode.canNavigate()) {
                abstractTreeNode.navigate(true);
            }
            return;
        }
        this.c.drillDown();
    }

    public void updateParentTitle() {
        this.c.updateParentTitle();
    }

    private AbstractTreeNode a() {
        return (AbstractTreeNode)this.c.getSelectedValue();
    }

    private boolean c(CoverageViewTreeStructure coverageViewTreeStructure) {
        if (this.a == null) {
            return false;
        }
        if (this.d.getSize() >= 1) {
            AbstractTreeNode abstractTreeNode = (AbstractTreeNode)coverageViewTreeStructure.getRootElement();
            AbstractTreeNode abstractTreeNode2 = (AbstractTreeNode)this.d.getElementAt(0);
            if (abstractTreeNode2.getParent() == abstractTreeNode) {
                return true;
            }
        }
        return false;
    }

    public boolean canSelect(VirtualFile file) {
        return this.c.canSelect(file);
    }

    public void select(VirtualFile file) {
        this.c.select(file);
    }

    public Object getData(@NotNull @NonNls String dataId) {
        long l2 = h ^ 0x5538E5733856L;
        if (dataId == null) {
            CoverageView.a(0);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.a();
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = h ^ 0x760248E34413L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/coverage/view/CoverageView", "getData"));
    }

    private class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        private static final long a = la.a(4742577186988454397L, 932811286471519541L, MethodHandles.lookup().lookupClass()).a(241105579666990L);

        MyAutoScrollFromSourceHandler() {
            super(CoverageView.this.f, (JComponent)((Object)CoverageView.this), (Disposable)CoverageView.this);
        }

        protected boolean isAutoScrollEnabled() {
            return ((CoverageView)CoverageView.this).g.myAutoScrollFromSource;
        }

        protected void setAutoScrollEnabled(boolean state) {
            ((CoverageView)CoverageView.this).g.myAutoScrollFromSource = state;
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            VirtualFile virtualFile;
            if (editor == null) {
                MyAutoScrollFromSourceHandler.a(0);
            }
            if (this.myProject.isDisposed() || !CoverageView.this.isShowing()) {
                return;
            }
            if (((CoverageView)CoverageView.this).g.myAutoScrollFromSource && (virtualFile = FileEditorManagerEx.getInstanceEx((Project)this.myProject).getFile(editor)) != null && CoverageView.this.canSelect(virtualFile)) {
                VirtualFile virtualFile2 = null;
                if (editor instanceof TextEditor) {
                    int n2 = ((TextEditor)editor).getEditor().getCaretModel().getOffset();
                    PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                    PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
                    if (psiFile != null) {
                        virtualFile2 = psiFile.findElementAt(n2);
                    }
                }
                CoverageView.this.c.select(virtualFile2 != null ? virtualFile2 : virtualFile);
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x4A156FFEDD39L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/coverage/view/CoverageView$MyAutoScrollFromSourceHandler", "selectElementFromEditor"));
        }
    }

    private class GoUpAction
    extends DumbAwareAction {
        private final CoverageViewTreeStructure a;
        final /* synthetic */ CoverageView this$0;
        private static final long b = la.a(4741152711928523355L, 7264655658027861741L, MethodHandles.lookup().lookupClass()).a(45433937580139L);

        GoUpAction(CoverageView coverageView, CoverageViewTreeStructure treeStructure) {
            long l2 = b ^ 0x49B238E55D58L;
            this.this$0 = coverageView;
            super("Go Up", "Go to Upper Level", AllIcons.Nodes.UpLevel);
            this.a = treeStructure;
            this.registerCustomShortcutSet(8, 0, (JComponent)coverageView.a);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                GoUpAction.a(0);
            }
            this.this$0.goUp();
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                GoUpAction.a(1);
            }
            e10.getPresentation().setEnabled(!this.this$0.c(this.a));
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = b ^ 0x49FA3C21296CL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/view/CoverageView$GoUpAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class FlattenPackagesAction
    extends ToggleAction {
        final /* synthetic */ CoverageView this$0;
        private static final long a = la.a(-7388612356863413177L, 6007390884846348813L, MethodHandles.lookup().lookupClass()).a(166697257371675L);

        private FlattenPackagesAction(CoverageView coverageView) {
            long l2 = a ^ 0x4176148AAFA9L;
            this.this$0 = coverageView;
            super("Flatten Packages", "Flatten Packages", AllIcons.ObjectBrowser.FlattenPackages);
        }

        public boolean isSelected(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                FlattenPackagesAction.a(0);
            }
            return ((CoverageView)this.this$0).g.myFlattenPackages;
        }

        public void setSelected(@NotNull AnActionEvent e10, boolean state) {
            if (e10 == null) {
                FlattenPackagesAction.a(1);
            }
            ((CoverageView)this.this$0).g.myFlattenPackages = state;
            Object object = this.this$0.c.getSelectedValue();
            this.this$0.c.buildRoot();
            if (object != null) {
                this.this$0.c.select(((CoverageListNode)((Object)object)).getValue());
            }
            this.this$0.c.ensureSelectionExist();
            this.this$0.c.updateParentTitle();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0xCE0CBF23B62L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/view/CoverageView$FlattenPackagesAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NodeDescriptorTableCellRenderer
    extends DefaultTableCellRenderer {
        private NodeDescriptorTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof NodeDescriptor) {
                NodeDescriptor nodeDescriptor = (NodeDescriptor)value;
                this.setIcon(nodeDescriptor.getIcon());
                this.setText(nodeDescriptor.toString());
                if (!isSelected) {
                    this.setForeground(((CoverageListNode)nodeDescriptor).getFileStatus().getColor());
                }
            }
            return component;
        }
    }
}

