/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class IfNode
extends Node {
    private Node condition;
    private Node thenBody;
    private Node elseBody;

    public IfNode(SourcePosition position, Node condition, Node thenBody, Node elseBody) {
        super(position);
        assert (condition != null) : "condition is not null";
        this.condition = this.adopt(condition);
        this.thenBody = this.adopt(thenBody);
        this.elseBody = this.adopt(elseBody);
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        IfNode other = (IfNode)node;
        if (this.getThenBody() == null && other.getThenBody() == null) {
            if (this.getElseBody() == null && other.getElseBody() == null) {
                return this.getCondition().isSame(other.getCondition());
            }
            if (this.getElseBody() == null || other.getElseBody() == null) {
                return false;
            }
        }
        if (this.getThenBody() == null || other.getThenBody() == null) {
            return false;
        }
        if (this.getElseBody() == null && other.getElseBody() == null) {
            return this.getThenBody().isSame(other.getThenBody()) && this.getCondition().isSame(other.getCondition());
        }
        if (this.getElseBody() == null || other.getElseBody() == null) {
            return false;
        }
        return this.getThenBody().isSame(other.getThenBody()) && this.getElseBody().isSame(other.getElseBody()) && this.getCondition().isSame(other.getCondition());
    }

    public NodeType getNodeType() {
        return NodeType.IFNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitIfNode(this);
    }

    public Node getCondition() {
        return this.condition;
    }

    public Node getElseBody() {
        return this.elseBody;
    }

    public Node getThenBody() {
        return this.thenBody;
    }
}

