/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ErrorLabel;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeCellRenderer;

public abstract class GroupedElementsRenderer {
    protected SeparatorWithText mySeparatorComponent = this.createSeparator();
    protected JComponent myComponent;
    protected MyComponent myRendererComponent = new MyComponent();
    protected ErrorLabel myTextLabel;

    protected abstract JComponent createItemComponent();

    public GroupedElementsRenderer() {
        this.myComponent = this.createItemComponent();
        this.layout();
    }

    protected abstract void layout();

    protected SeparatorWithText createSeparator() {
        return new SeparatorWithText();
    }

    protected final JComponent configureComponent(String text, String tooltip, Icon icon, Icon disabledIcon, boolean isSelected, boolean hasSeparatorAbove, String separatorTextAbove, int preferredForcedWidth) {
        this.mySeparatorComponent.setVisible(hasSeparatorAbove);
        this.mySeparatorComponent.setCaption(separatorTextAbove);
        this.mySeparatorComponent.setMinimumWidth(preferredForcedWidth);
        this.myTextLabel.setText(text);
        this.myRendererComponent.setToolTipText(tooltip);
        AccessibleContextUtil.setName((Component)this.myRendererComponent, (Component)this.myTextLabel);
        AccessibleContextUtil.setDescription((Component)this.myRendererComponent, (Component)this.myTextLabel);
        this.myTextLabel.setIcon(icon);
        this.myTextLabel.setDisabledIcon(disabledIcon);
        this.setSelected(this.myComponent, isSelected);
        this.setSelected(this.myTextLabel, isSelected);
        this.myRendererComponent.setPrefereedWidth(preferredForcedWidth);
        return this.myRendererComponent;
    }

    protected final void setSelected(JComponent aComponent) {
        this.setSelected(aComponent, true);
    }

    protected final void setDeselected(JComponent aComponent) {
        this.setSelected(aComponent, false);
    }

    protected final void setSelected(JComponent aComponent, boolean selected) {
        UIUtil.setBackgroundRecursively((Component)aComponent, (Color)(selected ? this.getSelectionBackground() : this.getBackground()));
        aComponent.setForeground(selected ? this.getSelectionForeground() : this.getForeground());
    }

    protected abstract Color getSelectionBackground();

    protected abstract Color getSelectionForeground();

    protected abstract Color getBackground();

    protected abstract Color getForeground();

    protected Border getDefaultItemComponentBorder() {
        return GroupedElementsRenderer.getBorder();
    }

    private static Border getBorder() {
        return new EmptyBorder(UIUtil.getListCellPadding());
    }

    protected class MyComponent
    extends OpaquePanel {
        private int myPrefWidth;

        public MyComponent() {
            super((LayoutManager)new BorderLayout(), GroupedElementsRenderer.this.getBackground());
            this.myPrefWidth = -1;
        }

        public void setPrefereedWidth(int minWidth) {
            this.myPrefWidth = minWidth;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width = this.myPrefWidth == -1 ? size.width : this.myPrefWidth;
            return size;
        }
    }

    public static abstract class Tree
    extends GroupedElementsRenderer
    implements TreeCellRenderer {
        @Override
        protected void layout() {
            this.myRendererComponent.add((Component)this.mySeparatorComponent, "North");
            this.myRendererComponent.add((Component)this.myComponent, "West");
        }

        @Override
        protected Color getSelectionBackground() {
            return UIUtil.getTreeSelectionBackground();
        }

        @Override
        protected Color getSelectionForeground() {
            return UIUtil.getTreeSelectionForeground();
        }

        @Override
        protected Color getBackground() {
            return UIUtil.getTreeBackground();
        }

        @Override
        protected Color getForeground() {
            return UIUtil.getTreeForeground();
        }
    }

    public static abstract class List
    extends GroupedElementsRenderer {
        @Override
        protected void layout() {
            this.myRendererComponent.add((Component)this.mySeparatorComponent, "North");
            this.myRendererComponent.add((Component)this.myComponent, "Center");
        }

        @Override
        protected final Color getSelectionBackground() {
            return UIUtil.getListSelectionBackground();
        }

        @Override
        protected final Color getSelectionForeground() {
            return UIUtil.getListSelectionForeground();
        }

        @Override
        protected Color getBackground() {
            return UIUtil.getListBackground();
        }

        @Override
        protected Color getForeground() {
            return UIUtil.getListForeground();
        }
    }
}

