/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.highlighting;

import com.google.common.base.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateSelectorWeigher;

public class TextMateSelectorWeigherImpl
implements TextMateSelectorWeigher {
    private static final int NESTING_WEIGH_INITIAL = 100;
    private static final int BASE_WEIGH = 1000;
    private static final Splitter RULE_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static final Splitter SELECTOR_SPLITTER = Splitter.on((char)' ').trimResults().omitEmptyStrings();
    private static final Pattern EXCLUDING_SELECTOR_PATTERN = Pattern.compile("\\B-");
    private static final Splitter EXCLUDING_SPLITTER = Splitter.on((Pattern)EXCLUDING_SELECTOR_PATTERN).trimResults().omitEmptyStrings();

    @Override
    public int weigh(@NotNull String scopeSelector, @NotNull String scope) {
        if (scopeSelector == null) {
            TextMateSelectorWeigherImpl.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            TextMateSelectorWeigherImpl.$$$reportNull$$$0(1);
        }
        int result = 0;
        Iterable highlightingSelectors = RULE_SPLITTER.split((CharSequence)scopeSelector);
        for (String highlightingSelector : highlightingSelectors) {
            int includedSelectorWeigh;
            Iterator excludingIterator = EXCLUDING_SPLITTER.split((CharSequence)highlightingSelector).iterator();
            if (!excludingIterator.hasNext() || (includedSelectorWeigh = TextMateSelectorWeigherImpl.weighSelector((String)excludingIterator.next(), scope)) <= result) continue;
            boolean excluded = false;
            if (excludingIterator.hasNext()) {
                while (excludingIterator.hasNext()) {
                    if (TextMateSelectorWeigherImpl.weighSelector((String)excludingIterator.next(), scope) <= 0) continue;
                    excluded = true;
                }
            }
            if (excluded) continue;
            result = includedSelectorWeigh;
        }
        return result;
    }

    private static int weighSelector(@NotNull String highlightingSelector, @NotNull String targetSelector) {
        if (highlightingSelector == null) {
            TextMateSelectorWeigherImpl.$$$reportNull$$$0(2);
        }
        if (targetSelector == null) {
            TextMateSelectorWeigherImpl.$$$reportNull$$$0(3);
        }
        Stack highlightingSelectors = new Stack();
        ContainerUtil.addAll((Collection)highlightingSelectors, (Iterable)SELECTOR_SPLITTER.split((CharSequence)highlightingSelector));
        Stack targetSelectors = new Stack();
        ContainerUtil.addAll((Collection)targetSelectors, (Iterable)SELECTOR_SPLITTER.split((CharSequence)targetSelector));
        String currentTargetSelector = (String)targetSelectors.pop();
        String currentHighlightingSelector = (String)highlightingSelectors.peek();
        int nestingWeigh = 100;
        int result = 0;
        while (!highlightingSelectors.empty() && currentTargetSelector != null) {
            if (currentTargetSelector.startsWith(currentHighlightingSelector)) {
                int dotWeigh = 1000 - StringUtil.getOccurrenceCount((String)currentTargetSelector, (char)'.') + StringUtil.getOccurrenceCount((String)currentHighlightingSelector, (char)'.');
                result += dotWeigh * nestingWeigh;
                highlightingSelectors.pop();
                if (!highlightingSelectors.empty()) {
                    currentHighlightingSelector = (String)highlightingSelectors.peek();
                }
            }
            --nestingWeigh;
            currentTargetSelector = !targetSelectors.empty() ? (String)targetSelectors.pop() : null;
        }
        return highlightingSelectors.empty() ? result : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeSelector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingSelector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSelector";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateSelectorWeigherImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "weigh";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "weighSelector";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

