/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Strings {
    private static final Pattern SEVERAL_SPACES = Pattern.compile("[ \\s\\t\\r\\n]{2,}");

    public static boolean eq(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public static boolean eq(String str1, String str2, boolean caseSensitive) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return caseSensitive ? str1.equals(str2) : str1.equalsIgnoreCase(str2);
    }

    @NotNull
    public static String ensureStartsWith(@NotNull String str, char c) {
        if (str.length() == 0) {
            return Character.toString(c);
        }
        char c1 = str.charAt(0);
        if (c1 == c) {
            return str;
        }
        return c + str;
    }

    @NotNull
    public static String ensureEndsWith(@NotNull String str, char c) {
        int n = str.length();
        if (n > 0 && str.charAt(n - 1) == c) {
            return str;
        }
        return str + c;
    }

    @NotNull
    public static String removeEnding(@NotNull String str, @NotNull String ending) {
        int m;
        int n = str.length();
        if (n > (m = ending.length()) && str.endsWith(ending)) {
            return str.substring(0, n - m);
        }
        return str;
    }

    @NotNull
    public static String rtrim(@NotNull String str) {
        int n;
        int k;
        for (k = n = str.length(); k > 0 && Character.isWhitespace(str.charAt(k - 1)); --k) {
        }
        if (k == n) {
            return str;
        }
        return str.substring(0, k);
    }

    @NotNull
    public static String replace(@NotNull String where, @NotNull String what, @NotNull String with) {
        return where.replace(what, with);
    }

    @NotNull
    public static String repeat(@NotNull String what, @Nullable String delimiter, int count) {
        if (count == 0) {
            return "";
        }
        if (count == 1) {
            return what;
        }
        StringBuilder b = new StringBuilder(what.length() + (delimiter == null ? 0 : delimiter.length()) * count);
        b.append(what);
        for (int i = 1; i < count; ++i) {
            if (delimiter != null) {
                b.append(delimiter);
            }
            b.append(what);
        }
        return b.toString();
    }

    @Contract(value="null,_->false")
    public static boolean matches(@Nullable CharSequence string, @NotNull Pattern pattern) {
        if (string == null) {
            return false;
        }
        return pattern.matcher(string).matches();
    }

    @Contract(value="null,_,_->false")
    public static boolean matches(@Nullable CharSequence string, @NotNull String pattern, boolean caseSensitive) {
        if (string == null) {
            return false;
        }
        Pattern p = Pattern.compile(pattern, caseSensitive ? 0 : 2);
        return Strings.matches(string, p);
    }

    @Contract(value="!null->!null; null->null")
    public static String upper(@Nullable String string) {
        return string == null ? null : string.toUpperCase();
    }

    @Contract(value="!null->!null; null->null")
    public static String lower(@Nullable String string) {
        return string == null ? null : string.toLowerCase();
    }

    @Contract(value="!null->!null; null->null")
    public static String minimizeSpaces(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String s = string.trim();
        if (s.isEmpty()) {
            return "";
        }
        Matcher m = SEVERAL_SPACES.matcher(s);
        return m.replaceAll(" ");
    }

    @Contract(value="!null,_->!null; null,_->null")
    public static String lastPart(@Nullable String string, char delimiter) {
        if (string == null) {
            return null;
        }
        int pos = string.lastIndexOf(delimiter);
        if (pos >= 0) {
            return string.substring(pos + 1);
        }
        return string;
    }
}

