/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdbcDrivers {
    private static final Object syncObject;
    @NotNull
    private static ClassLoader ourDriversClassLoader;
    @NotNull
    private static Collection<Driver> ourPreferredDrivers;

    private JdbcDrivers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPreferredDrivers(@Nullable ClassLoader classLoader, @Nullable Collection<Driver> drivers) {
        Object object = syncObject;
        synchronized (object) {
            ourDriversClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
            ourPreferredDrivers = drivers != null && !drivers.isEmpty() ? Collections.unmodifiableList(new ArrayList<Driver>(drivers)) : Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ClassLoader getDriversClassLoader() {
        Object object = syncObject;
        synchronized (object) {
            return ourDriversClassLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Collection<Driver> getPreferredDrivers() {
        Object object = syncObject;
        synchronized (object) {
            return ourPreferredDrivers;
        }
    }

    @Nullable
    public static Driver findPreferredDriverFor(@NotNull String connectionString) {
        Collection<Driver> drivers = JdbcDrivers.getPreferredDrivers();
        for (Driver driver : drivers) {
            if (!JdbcDrivers.isDriverAcceptingConnectionString(driver, connectionString)) continue;
            return driver;
        }
        return null;
    }

    private static boolean isDriverAcceptingConnectionString(@NotNull Driver driver, @NotNull String connectionString) {
        try {
            return driver.acceptsURL(connectionString);
        }
        catch (SQLException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object = syncObject = new Object();
        synchronized (object) {
            ourDriversClassLoader = Thread.currentThread().getContextClassLoader();
            ourPreferredDrivers = Collections.emptySet();
        }
    }
}

