-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL,ALLOW_INVALID_DATES';


CREATE TABLE IF NOT EXISTS `tags_types` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(45) NOT NULL,
  `parameters_json` TEXT NULL,
  `created` DATETIME NULL,
  `modified` DATETIME NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;

CREATE TABLE IF NOT EXISTS `tags` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `created` DATETIME NULL,
  `modified` DATETIME NULL,
  `tags_types_id` INT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_tags_tags_types1_idx` (`tags_types_id` ASC),
  INDEX `index_tag_name` (`name` ASC),
  CONSTRAINT `fk_tags_tags_types1`
    FOREIGN KEY (`tags_types_id`)
    REFERENCES `tags_types` (`id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;

CREATE TABLE IF NOT EXISTS `tags_has_videos` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `tags_id` INT NOT NULL,
  `videos_id` INT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_tags_has_videos_videos1_idx` (`videos_id` ASC),
  INDEX `fk_tags_has_videos_tags_idx` (`tags_id` ASC),
  CONSTRAINT `fk_tags_has_videos_tags`
    FOREIGN KEY (`tags_id`)
    REFERENCES `tags` (`id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_tags_has_videos_videos1`
    FOREIGN KEY (`videos_id`)
    REFERENCES `videos` (`id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;

CREATE TABLE IF NOT EXISTS `tags_subscriptions` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `created` DATETIME NULL,
  `modified` DATETIME NULL,
  `tags_id` INT(11) NOT NULL,
  `users_id` INT(11) NOT NULL,
  `notify` TINYINT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  INDEX `fk_tags_subscriptions_tags1_idx` (`tags_id` ASC),
  INDEX `fk_tags_subscriptions_users1_idx` (`users_id` ASC),
  INDEX `indextagsnotify` (notify ASC),
  CONSTRAINT `fk_tags_subscriptions_tags1`
    FOREIGN KEY (`tags_id`)
    REFERENCES `tags` (`id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_tags_subscriptions_users1`
    FOREIGN KEY (`users_id`)
    REFERENCES `users` (`id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;

SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
