/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.AbstractAppParamPlugin;
import org.parosproxy.paros.network.HttpMessage;

public class TestExternalRedirect
extends AbstractAppParamPlugin {
    private String redirect1 = "http://www.parosproxy.org";
    private String redirect2 = "www.parosproxy.org";
    private Pattern patternRedirect = Pattern.compile(this.redirect1, 10);

    public int getId() {
        return 30000;
    }

    public String getName() {
        return "External redirect";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        String string = "Arbitrary external redirection can be .  A phishing email can make use of this to entice readers to click on the link to redirect readers to bogus sites.";
        return string;
    }

    public int getCategory() {
        return 3;
    }

    public String getSolution() {
        return "Only allow redirection within the same web sites; or only allow redirection to designated external URLs.";
    }

    public String getReference() {
        String string = "";
        return string;
    }

    public void init() {
    }

    public void scan(HttpMessage httpMessage, String string, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = "";
        URI uRI = null;
        httpMessage = this.getNewMsg();
        try {
            this.sendAndReceive(httpMessage, false);
            if (httpMessage.getResponseHeader().getStatusCode() != 301 && httpMessage.getResponseHeader().getStatusCode() != 302) {
                return;
            }
            string3 = httpMessage.getResponseHeader().getHeader("Location");
            if (string3 == null) {
                return;
            }
            if (string3.compareToIgnoreCase(string2) == 0) {
                string5 = this.redirect1;
            } else if (string3.compareToIgnoreCase(TestExternalRedirect.getURLDecode(string2)) == 0) {
                string5 = TestExternalRedirect.getURLEncode(this.redirect1);
            }
            if (string5 != null) {
                uRI = new URI(string3, true);
                string4 = uRI.getPathQuery();
                if (string4.compareToIgnoreCase(string2) == 0) {
                    string5 = this.redirect2;
                } else if (string4.compareToIgnoreCase(TestExternalRedirect.getURLDecode(string2)) == 0) {
                    string5 = TestExternalRedirect.getURLEncode(this.redirect2);
                }
            }
            if (string5 == null) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        httpMessage = this.getNewMsg();
        this.setParameter(httpMessage, string, string5);
        try {
            this.sendAndReceive(httpMessage, false);
            if (this.checkResult(httpMessage, string + "=" + string5)) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean checkResult(HttpMessage httpMessage, String string) {
        if (httpMessage.getResponseHeader().getStatusCode() != 301 && httpMessage.getResponseHeader().getStatusCode() != 302) {
            return false;
        }
        String string2 = httpMessage.getResponseHeader().getHeader("Location");
        if (string2 != null && string2.startsWith(this.redirect1)) {
            this.bingo(2, 1, null, string, "", httpMessage);
            return true;
        }
        return false;
    }

    public boolean isVisible() {
        return Constant.isSP();
    }
}

