/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis.archive;

import java.io.IOException;
import java.io.InputStream;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.analysis.FileAnalyzerFactory;
import org.opensolaris.opengrok.analysis.archive.ZipAnalyzer;
import org.opensolaris.opengrok.analysis.executables.JarAnalyzerFactory;

public final class ZipAnalyzerFactory
extends FileAnalyzerFactory {
    private static final String[] SUFFIXES = new String[]{"ZIP"};
    private static final byte[] MAGIC = new byte[]{80, 75, 3, 4};
    private static final FileAnalyzerFactory.Matcher MATCHER = new FileAnalyzerFactory.Matcher(){
        private static final int LOCHDRSIZ = 30;
        private static final int XFHSIZ = 4;

        private int CH(byte[] b, int n) {
            return b[n] & 0xFF;
        }

        private int SH(byte[] b, int n) {
            return this.CH(b, n) | this.CH(b, n + 1) << 8;
        }

        private int LOCNAM(byte[] b) {
            return this.SH(b, 26);
        }

        private int LOCEXT(byte[] b) {
            return this.SH(b, 28);
        }

        @Override
        public FileAnalyzerFactory isMagic(byte[] contents, InputStream in) throws IOException {
            int xfdatasiz;
            int xoff;
            assert (in.markSupported());
            if (contents.length < MAGIC.length) {
                return null;
            }
            for (int i = 0; i < MAGIC.length; ++i) {
                if (contents[i] == MAGIC[i]) continue;
                return null;
            }
            byte[] buf = new byte[1024];
            in.mark(buf.length);
            int len = in.read(buf);
            in.reset();
            int xoff_end = Math.min(len, xoff + this.LOCEXT(buf));
            for (xoff = 30 + this.LOCNAM(buf); xoff < xoff_end && len - xoff >= 4; xoff += 4 + xfdatasiz) {
                int xfhid = this.SH(buf, xoff);
                if (xfhid == 51966) {
                    return JarAnalyzerFactory.DEFAULT_INSTANCE;
                }
                xfdatasiz = this.SH(buf, xoff + 2);
            }
            return DEFAULT_INSTANCE;
        }
    };
    public static final ZipAnalyzerFactory DEFAULT_INSTANCE = new ZipAnalyzerFactory();

    private ZipAnalyzerFactory() {
        super(null, null, SUFFIXES, null, MATCHER, null, FileAnalyzer.Genre.XREFABLE);
    }

    @Override
    protected FileAnalyzer newAnalyzer() {
        return new ZipAnalyzer(this);
    }
}

