/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.VImage;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class VImageOr
extends VImage {
    int[] xcoords = new int[4];
    int[] ycoords = new int[4];

    public VImageOr(Image img, float or) {
        super(img);
        this.orient = or;
    }

    public VImageOr(long x, long y, int z, Image img, float or) {
        super(x, y, z, img);
        this.orient = or;
    }

    public void orientTo(float angle) {
        this.orient = angle;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return this.pc[camIndex].p.contains(jpx, jpy);
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.pc[camIndex].p.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        if (this.zoomSensitive) {
            this.pc[i].cw = Math.round((float)this.vw * this.coef);
            this.pc[i].ch = Math.round((float)this.vh * this.coef);
        } else {
            this.pc[i].cw = (int)this.vw;
            this.pc[i].ch = (int)this.vh;
        }
        float x1 = -this.pc[i].cw;
        float y1 = -this.pc[i].ch;
        float x2 = this.pc[i].cw;
        float y2 = this.pc[i].ch;
        this.xcoords[0] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].cx);
        this.ycoords[0] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].cy);
        this.xcoords[1] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].cx);
        this.ycoords[1] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].cy);
        this.xcoords[2] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].cx);
        this.ycoords[2] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].cy);
        this.xcoords[3] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].cx);
        this.ycoords[3] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].cy);
        if (this.pc[i].p == null) {
            this.pc[i].p = new Polygon(this.xcoords, this.ycoords, 4);
        } else {
            for (int j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].p.xpoints[j] = this.xcoords[j];
                this.pc[i].p.ypoints[j] = this.ycoords[j];
            }
            this.pc[i].p.invalidate();
        }
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        if (this.zoomSensitive) {
            this.pc[i].lcw = Math.round((float)this.vw * this.coef);
            this.pc[i].lch = Math.round((float)this.vh * this.coef);
        } else {
            this.pc[i].lcw = (int)this.vw;
            this.pc[i].lch = (int)this.vh;
        }
        float x1 = -this.pc[i].lcw;
        float y1 = -this.pc[i].lch;
        float x2 = this.pc[i].lcw;
        float y2 = this.pc[i].lch;
        this.xcoords[0] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].lcx);
        this.ycoords[0] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].lcy);
        this.xcoords[1] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].lcx);
        this.ycoords[1] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].lcy);
        this.xcoords[2] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].lcx);
        this.ycoords[2] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].lcy);
        this.xcoords[3] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].lcx);
        this.ycoords[3] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].lcy);
        if (this.pc[i].lp == null) {
            this.pc[i].lp = new Polygon(this.xcoords, this.ycoords, 4);
        } else {
            for (int j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].lp.xpoints[j] = this.xcoords[j];
                this.pc[i].lp.ypoints[j] = this.ycoords[j];
            }
            this.pc[i].lp.invalidate();
        }
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cw > 1 && this.pc[i].ch > 1) {
            this.trueCoef = this.zoomSensitive ? this.scaleFactor * this.coef : this.scaleFactor;
            if (Math.abs(this.trueCoef - 1.0f) < 0.01f) {
                this.trueCoef = 1.0f;
            }
            if (this.trueCoef != 1.0f) {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                if (this.orient != 0.0f) {
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].cw, this.pc[i].ch));
                }
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
                if (this.interpolationMethod != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                    g.drawImage(this.image, this.at, null);
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                } else {
                    g.drawImage(this.image, this.at, null);
                }
                if (this.drawBorder == 1) {
                    if (this.pc[i].prevMouseIn) {
                        g.setColor(this.borderColor);
                        g.drawPolygon(this.pc[i].p);
                    }
                } else if (this.drawBorder == 2) {
                    g.setColor(this.borderColor);
                    g.drawPolygon(this.pc[i].p);
                }
            } else {
                if (this.orient == 0.0f) {
                    g.drawImage(this.image, dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, null);
                } else {
                    this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].cw, this.pc[i].ch));
                    g.drawImage(this.image, this.at, null);
                }
                if (this.drawBorder == 1) {
                    if (this.pc[i].prevMouseIn) {
                        g.setColor(this.borderColor);
                        g.drawPolygon(this.pc[i].p);
                    }
                } else if (this.drawBorder == 2) {
                    g.setColor(this.borderColor);
                    g.drawPolygon(this.pc[i].p);
                }
            }
        } else {
            g.setColor(this.borderColor);
            g.fillRect(this.pc[i].lcx, this.pc[i].lcy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lcw > 1 && this.pc[i].lch > 1) {
            this.trueCoef = this.zoomSensitive ? this.scaleFactor * this.coef : this.scaleFactor;
            if (Math.abs(this.trueCoef - 1.0f) < 0.01f) {
                this.trueCoef = 1.0f;
            }
            if (this.trueCoef != 1.0f) {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
                if (this.orient != 0.0f) {
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].lcw, this.pc[i].lch));
                }
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
                if (this.interpolationMethod != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                    g.drawImage(this.image, this.at, null);
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                } else {
                    g.drawImage(this.image, this.at, null);
                }
                if (this.drawBorder == 1) {
                    if (this.pc[i].prevMouseIn) {
                        g.setColor(this.borderColor);
                        g.drawPolygon(this.pc[i].lp);
                    }
                } else if (this.drawBorder == 2) {
                    g.setColor(this.borderColor);
                    g.drawPolygon(this.pc[i].lp);
                }
            } else {
                if (this.orient == 0.0f) {
                    g.drawImage(this.image, dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, null);
                } else {
                    this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].lcw, this.pc[i].lch));
                    g.drawImage(this.image, this.at, null);
                }
                if (this.drawBorder == 1) {
                    if (this.pc[i].prevMouseIn) {
                        g.setColor(this.borderColor);
                        g.drawPolygon(this.pc[i].lp);
                    }
                } else if (this.drawBorder == 2) {
                    g.setColor(this.borderColor);
                    g.drawPolygon(this.pc[i].lp);
                }
            }
        } else {
            g.setColor(this.borderColor);
            g.fillRect(dx + dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public Object clone() {
        VImageOr res = new VImageOr(this.vx, this.vy, 0, this.image, this.orient);
        res.setWidth(this.vw);
        res.setHeight(this.vh);
        res.borderColor = this.borderColor;
        res.mouseInsideColor = this.mouseInsideColor;
        res.bColor = this.bColor;
        res.setDrawBorderPolicy(this.drawBorder);
        res.setZoomSensitive(this.zoomSensitive);
        return res;
    }
}

