/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.CharSourceRange;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.Module;
import org.clang.basic.PresumedLoc;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SrcMgr;
import org.clang.basic.diag;
import org.clang.frontend.impl.PrintPPOutputHelper;
import org.clang.frontend.impl.PrintPreprocessedOutputStatics;
import org.clang.lex.MacroDefinition;
import org.clang.lex.MacroDirective;
import org.clang.lex.MacroInfo;
import org.clang.lex.PPCallbacks;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clang.lex.TokenConcatenation;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.void;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRefInt;
import org.llvm.support.raw_ostream;

public final class PrintPPOutputPPCallbacks
extends PPCallbacks
implements Destructors.ClassWithDestructor {
    private final Preprocessor PP;
    private final SourceManager SM;
    private final TokenConcatenation ConcatInfo;
    public raw_ostream OS;
    private int CurLine;
    private boolean EmittedTokensOnThisLine;
    private boolean EmittedDirectiveOnThisLine;
    private SrcMgr.CharacteristicKind FileType;
    private final SmallString CurFilename;
    private boolean Initialized;
    private final boolean DisableLineMarkers;
    private final boolean DumpDefines;
    private final boolean UseLineDirectives;
    private boolean IsFirstFileEntered;
    private final PrintPPOutputHelper $PrintPPOutputHelper = new PrintPPOutputHelper();
    private boolean PrintPPOutputHelperInUse = false;

    public PrintPPOutputPPCallbacks(Preprocessor pp, raw_ostream os, boolean lineMarkers, boolean defines, boolean UseLineDirectives) {
        this.PP = pp;
        this.SM = this.PP.getSourceManager();
        this.ConcatInfo = new TokenConcatenation(this.PP);
        this.OS = os;
        this.CurFilename = new SmallString(512);
        this.DisableLineMarkers = lineMarkers;
        this.DumpDefines = defines;
        this.UseLineDirectives = UseLineDirectives;
        this.CurLine = 0;
        this.CurFilename.$addassign("<uninit>");
        this.EmittedTokensOnThisLine = false;
        this.EmittedDirectiveOnThisLine = false;
        this.FileType = SrcMgr.CharacteristicKind.C_User;
        this.Initialized = false;
        this.IsFirstFileEntered = false;
    }

    public void setEmittedTokensOnThisLine() {
        this.EmittedTokensOnThisLine = true;
    }

    public boolean hasEmittedTokensOnThisLine() {
        return this.EmittedTokensOnThisLine;
    }

    public void setEmittedDirectiveOnThisLine() {
        this.EmittedDirectiveOnThisLine = true;
    }

    public boolean hasEmittedDirectiveOnThisLine() {
        return this.EmittedDirectiveOnThisLine;
    }

    public boolean startNewLineIfNeeded() {
        return this.startNewLineIfNeeded(true);
    }

    public boolean startNewLineIfNeeded(boolean ShouldUpdateCurrentLine) {
        if (this.EmittedTokensOnThisLine || this.EmittedDirectiveOnThisLine) {
            this.OS.$out_char((byte)10);
            this.EmittedTokensOnThisLine = false;
            this.EmittedDirectiveOnThisLine = false;
            if (ShouldUpdateCurrentLine) {
                ++this.CurLine;
            }
            return true;
        }
        return false;
    }

    public void FileChanged(SourceLocation Loc, PPCallbacks.FileChangeReason Reason, SrcMgr.CharacteristicKind NewFileType, FileID PrevFID) {
        SourceManager SourceMgr = this.SM;
        PresumedLoc UserLoc = SourceMgr.getPresumedLoc(Loc);
        if (UserLoc.isInvalid()) {
            return;
        }
        int NewLine = UserLoc.getLine();
        if (Reason == PPCallbacks.FileChangeReason.EnterFile) {
            int IncludeLoc = UserLoc.$getIncludeLoc();
            if (SourceLocation.isValid((int)IncludeLoc)) {
                this.MoveToLine(IncludeLoc);
            }
        } else if (Reason == PPCallbacks.FileChangeReason.SystemHeaderPragma) {
            ++NewLine;
        }
        this.CurLine = NewLine;
        this.CurFilename.clear();
        this.CurFilename.$addassign(UserLoc.getFilename());
        this.FileType = NewFileType;
        if (this.DisableLineMarkers) {
            this.startNewLineIfNeeded(false);
            return;
        }
        if (!this.Initialized) {
            this.WriteLineInfo(this.CurLine);
            this.Initialized = true;
        }
        if (Reason == PPCallbacks.FileChangeReason.EnterFile && !this.IsFirstFileEntered) {
            this.IsFirstFileEntered = true;
            return;
        }
        switch (Reason) {
            case EnterFile: {
                this.WriteLineInfo(this.CurLine, NativePointer.$((String)" 1"), 2);
                break;
            }
            case ExitFile: {
                this.WriteLineInfo(this.CurLine, NativePointer.$((String)" 2"), 2);
                break;
            }
            case SystemHeaderPragma: 
            case RenameFile: {
                this.WriteLineInfo(this.CurLine);
            }
        }
    }

    public void InclusionDirective(SourceLocation HashLoc, SourceLocation EodLoc, Token IncludeTok, StringRef FileName, boolean IsAngled, CharSourceRange FilenameRange, FileEntry File2, StringRef SearchPath, StringRef RelativePath, Module Imported) {
        if (Imported != null) {
            this.startNewLineIfNeeded();
            this.MoveToLine(new SourceLocation(HashLoc));
            this.OS.$out("@import ").$out(Imported.getFullModuleName()).$out(NativePointer.$SEMI).$out(" /* clang -E: implicit import for \"").$out(File2.getName()).$out("\" */");
            this.EmittedTokensOnThisLine = true;
            this.startNewLineIfNeeded();
        }
    }

    public void Ident(SourceLocation Loc, StringRef S) {
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.write(NativePointer.$((String)"#ident "), std.strlen((CharSequence)"#ident "));
        this.OS.write(S.begin(), S.size());
        this.EmittedTokensOnThisLine = true;
    }

    public void PragmaMessage(SourceLocation Loc, StringRef Namespace, PPCallbacks.PragmaMessageKind Kind2, StringRef Str) {
        this.startNewLineIfNeeded();
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.$out("#pragma ");
        if (!Namespace.empty()) {
            this.OS.$out(Namespace).$out_char((byte)32);
        }
        switch (Kind2) {
            case PMK_Message: {
                this.OS.$out("message(\"");
                break;
            }
            case PMK_Warning: {
                this.OS.$out("warning \"");
                break;
            }
            case PMK_Error: {
                this.OS.$out("error \"");
            }
        }
        PrintPreprocessedOutputStatics.outputPrintable(this.OS, Str.$basic_string());
        this.OS.$out_char((byte)34);
        if (Kind2 == PPCallbacks.PragmaMessageKind.PMK_Message) {
            this.OS.$out_char((byte)41);
        }
        this.setEmittedDirectiveOnThisLine();
    }

    public void PragmaDebug(SourceLocation Loc, StringRef DebugType) {
        this.startNewLineIfNeeded();
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.$out("#pragma clang __debug ");
        this.OS.$out(DebugType);
        this.setEmittedDirectiveOnThisLine();
    }

    public void PragmaDiagnosticPush(SourceLocation Loc, StringRef Namespace) {
        this.startNewLineIfNeeded();
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.$out("#pragma ").$out(Namespace).$out(" diagnostic push");
        this.setEmittedDirectiveOnThisLine();
    }

    public void PragmaDiagnosticPop(SourceLocation Loc, StringRef Namespace) {
        this.startNewLineIfNeeded();
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.$out("#pragma ").$out(Namespace).$out(" diagnostic pop");
        this.setEmittedDirectiveOnThisLine();
    }

    public void PragmaDiagnostic(SourceLocation Loc, StringRef Namespace, diag.Severity Map2, StringRef Str) {
        this.startNewLineIfNeeded();
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.$out("#pragma ").$out(Namespace).$out(" diagnostic ");
        switch (Map2) {
            case Remark: {
                this.OS.$out("remark");
                break;
            }
            case Warning: {
                this.OS.$out(NativePointer.$warning);
                break;
            }
            case Error: {
                this.OS.$out(NativePointer.$error);
                break;
            }
            case Ignored: {
                this.OS.$out("ignored");
                break;
            }
            case Fatal: {
                this.OS.$out("fatal");
            }
        }
        this.OS.$out(" \"").$out(Str).$out_char((byte)34);
        this.setEmittedDirectiveOnThisLine();
    }

    public void PragmaWarning(SourceLocation Loc, StringRef WarningSpec, ArrayRefInt Ids) {
        this.startNewLineIfNeeded();
        this.MoveToLine(Loc);
        this.OS.$out("#pragma warning(").$out(WarningSpec).$out_char((byte)58);
        int.ptr I = (int.ptr)Native.$tryClone((NativeCloneable)Ids.begin());
        int.ptr E = (int.ptr)Native.$tryClone((NativeCloneable)Ids.end());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            this.OS.$out_char((byte)32).$out_int(I.$star());
            I.$preInc();
        }
        this.OS.$out_char((byte)41);
        this.setEmittedDirectiveOnThisLine();
    }

    public void PragmaWarningPush(SourceLocation Loc, int Level2) {
        this.startNewLineIfNeeded();
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.$out("#pragma warning(push");
        if (Level2 >= 0) {
            this.OS.$out(NativePointer.$COMMA_SPACE).$out_int(Level2);
        }
        this.OS.$out_char((byte)41);
        this.setEmittedDirectiveOnThisLine();
    }

    public void PragmaWarningPop(SourceLocation Loc) {
        this.startNewLineIfNeeded();
        this.MoveToLine(new SourceLocation(Loc));
        this.OS.$out("#pragma warning(pop)");
        this.setEmittedDirectiveOnThisLine();
    }

    public boolean HandleFirstTokOnLine(Token Tok) {
        if (!this.MoveToLine(Tok.getLocation())) {
            return false;
        }
        int ColNo = this.SM.getExpansionColumnNumber(Tok.getLocation());
        if (ColNo == 1 && Tok.hasLeadingSpace()) {
            ColNo = 2;
        }
        if (Unsigned.$lesseq_uint((int)ColNo, (int)1) && Tok.is('A')) {
            this.OS.$out_char((byte)32);
        }
        while (Unsigned.$greater_uint((int)ColNo, (int)1)) {
            this.OS.$out_char((byte)32);
            --ColNo;
        }
        return true;
    }

    public boolean MoveToLine(SourceLocation Loc) {
        return this.MoveToLine(Loc.getRawEncoding());
    }

    public boolean MoveToLine(int Loc) {
        PresumedLoc PLoc = this.SM.getPresumedLoc(Loc);
        if (PLoc.isInvalid()) {
            return false;
        }
        return this.MoveToLineNo(PLoc.getLine()) || PLoc.getLine() == 1;
    }

    private boolean MoveToLineNo(int LineNo) {
        if (0 <= LineNo - this.CurLine && LineNo - this.CurLine <= 8) {
            if (LineNo - this.CurLine == 1) {
                this.OS.$out_char((byte)10);
            } else {
                if (LineNo == this.CurLine) {
                    return false;
                }
                String NewLines = "\n\n\n\n\n\n\n\n";
                this.OS.write(NewLines, LineNo - this.CurLine);
            }
        } else if (!this.DisableLineMarkers) {
            this.WriteLineInfo(LineNo, null, 0);
        } else {
            this.startNewLineIfNeeded(false);
        }
        this.CurLine = LineNo;
        return true;
    }

    public boolean AvoidConcat(Token PrevPrevTok, Token PrevTok, Token Tok) {
        return this.ConcatInfo.AvoidConcat(PrevPrevTok, PrevTok, Tok);
    }

    public void WriteLineInfo(int LineNo) {
        this.WriteLineInfo(LineNo, null, 0);
    }

    public void WriteLineInfo(int LineNo, char.ptr Extra) {
        this.WriteLineInfo(LineNo, Extra, 0);
    }

    public void WriteLineInfo(int LineNo, char.ptr Extra, int ExtraLen) {
        this.startNewLineIfNeeded(false);
        if (this.UseLineDirectives) {
            this.OS.$out("#line").$out_char((byte)32).$out_uint(LineNo).$out_char((byte)32).$out_char((byte)34);
            this.OS.write_escaped(this.CurFilename.$StringRef());
            this.OS.$out_char((byte)34);
        } else {
            this.OS.$out_char((byte)35).$out_char((byte)32).$out_uint(LineNo).$out_char((byte)32).$out_char((byte)34);
            this.OS.write_escaped(this.CurFilename.$StringRef());
            this.OS.$out_char((byte)34);
            if (ExtraLen != 0) {
                this.OS.write(Extra, ExtraLen);
            }
            if (this.FileType == SrcMgr.CharacteristicKind.C_System) {
                this.OS.write(NativePointer.$((String)" 3"), 2);
            } else if (this.FileType == SrcMgr.CharacteristicKind.C_ExternCSystem) {
                this.OS.write(NativePointer.$((String)" 3 4"), 4);
            }
        }
        this.OS.$out_char((byte)10);
    }

    public boolean LineMarkersAreDisabled() {
        return this.DisableLineMarkers;
    }

    public void HandleNewlinesInToken(char.ptr TokStr, int Len) {
        int NumNewlines = 0;
        while (Len != 0) {
            if (TokStr.$star() == 10 || TokStr.$star() == 13) {
                ++NumNewlines;
                if (Len != 1 && (TokStr.$at(1) == 10 || TokStr.$at(1) == 13) && TokStr.$at(0) != TokStr.$at(1)) {
                    TokStr.$preInc();
                    --Len;
                }
            }
            --Len;
            TokStr.$preInc();
        }
        if (NumNewlines == 0) {
            return;
        }
        this.CurLine += NumNewlines;
    }

    public void MacroDefined(SourceLocation HashLoc, SourceLocation EodLoc, Token MacroNameTok, MacroDirective MD) {
        MacroInfo MI = MD.getMacroInfo();
        if (!this.DumpDefines || MI.isBuiltinMacro()) {
            return;
        }
        this.MoveToLine(MI.$getDefinitionLoc());
        PrintPreprocessedOutputStatics.PrintMacroDefinition(MacroNameTok.getIdentifierInfo(), MI, this.PP, this.OS);
        this.setEmittedDirectiveOnThisLine();
    }

    public void MacroUndefined(SourceLocation HashLoc, SourceLocation EodLoc, Token MacroNameTok, MacroDefinition MD) {
        if (!this.DumpDefines) {
            return;
        }
        this.MoveToLine(MacroNameTok.getLocation());
        this.OS.$out("#undef ").$out(MacroNameTok.getIdentifierInfo().getName());
        this.setEmittedDirectiveOnThisLine();
    }

    public void $destroy() {
        this.CurFilename.$destroy();
        super.$destroy();
    }

    PrintPPOutputHelper $getPrintPPOutputHelper() {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.PrintPPOutputHelperInUse) break block3;
                this.PrintPPOutputHelperInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        return this.$PrintPPOutputHelper;
    }

    void $releasePrintPPOutputHelper(PrintPPOutputHelper helper) {
        assert (helper == this.$PrintPPOutputHelper);
        assert (this.PrintPPOutputHelperInUse);
        if (!$assertionsDisabled) {
            this.PrintPPOutputHelperInUse = false;
            if (!false) {
                // empty if block
            }
        }
        this.$PrintPPOutputHelper.release();
    }

    public String toString() {
        return "CurLine=" + this.CurLine + ", EmittedTokensOnThisLine=" + this.EmittedTokensOnThisLine + ", EmittedDirectiveOnThisLine=" + this.EmittedDirectiveOnThisLine + ", FileType=" + this.FileType + ", CurFilename=" + this.CurFilename + ", Initialized=" + this.Initialized + ", DisableLineMarkers=" + this.DisableLineMarkers + ", DumpDefines=" + this.DumpDefines + ", UseLineDirectives=" + this.UseLineDirectives + ", IsFirstFileEntered=" + this.IsFirstFileEntered + super.toString();
    }
}

