/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.discovery.api.BuildTraceSupport;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class DiscoveryUtils {
    private DiscoveryUtils() {
    }

    public static ProjectBridge getProjectBridge(ProjectProxy project) {
        ProjectBridge bridge;
        Project p;
        if (project != null && (p = project.getProject()) != null && (bridge = new ProjectBridge(p)).isValid()) {
            return bridge;
        }
        return null;
    }

    public static String resolveSymbolicLink(FileSystem fileSystem, final String aPath) {
        if (fileSystem == null || FileSystemProvider.getExecutionEnvironment((FileSystem)fileSystem).isLocal()) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws IOException {
                        String path = aPath;
                        for (int i = 0; i < 5; ++i) {
                            Path to;
                            Path file = Paths.get(Utilities.toURI((File)new File(path)));
                            if (Files.isSymbolicLink(file)) {
                                to = Files.readSymbolicLink(file);
                                if (!to.isAbsolute()) {
                                    to = file.getParent().resolve(to).normalize();
                                }
                                if (Files.isRegularFile(to, new LinkOption[0])) {
                                    return to.toString();
                                }
                            } else {
                                return null;
                            }
                            path = to.toString();
                        }
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                CndUtils.printStackTraceOnce((Throwable)ex);
                return null;
            }
        }
        try {
            FileObject fo = fileSystem.findResource(aPath);
            if (fo == null) {
                return null;
            }
            if (FileSystemProvider.isLink((FileObject)fo)) {
                return FileSystemProvider.resolveLink((FileObject)fo);
            }
            return null;
        }
        catch (Exception ex) {
            CndUtils.printStackTraceOnce((Throwable)ex);
            return null;
        }
    }

    public static Set<String> getCompilerNames(ProjectProxy project, PredefinedToolKind kind) {
        Project p = null;
        if (project != null) {
            p = project.getProject();
        }
        return BuildTraceSupport.getCompilerNames(p, kind);
    }

    public static String getRelativePath(String base, String path) {
        String bstring;
        if (path.equals(base)) {
            return path;
        }
        if (path.startsWith(base + '/')) {
            return path.substring(base.length() + 1);
        }
        if (path.startsWith(base + '\\')) {
            return path.substring(base.length() + 1);
        }
        if (!(path.startsWith("/") || path.startsWith("\\") || path.length() > 2 && path.charAt(2) == ':')) {
            return path;
        }
        StringTokenizer stb = new StringTokenizer(base, "\\/");
        StringTokenizer stp = new StringTokenizer(path, "\\/");
        int match = 0;
        String pstring = null;
        while (stb.hasMoreTokens() && stp.hasMoreTokens() && (bstring = stb.nextToken()).equals(pstring = stp.nextToken())) {
            ++match;
        }
        if (match <= 1) {
            return path;
        }
        StringBuilder s = new StringBuilder();
        while (stb.hasMoreTokens()) {
            String bstring2 = stb.nextToken();
            s.append("..").append(File.separator);
        }
        s.append("..").append(File.separator).append(pstring);
        while (stp.hasMoreTokens()) {
            s.append(File.separator).append(stp.nextToken());
        }
        return s.toString();
    }

    public static String normalizeAbsolutePath(String path) {
        boolean caseSensitive = CndFileUtils.isSystemCaseSensitive();
        if (!caseSensitive && Utilities.isWindows()) {
            path = path.replace('\\', '/');
        }
        String normalized = !caseSensitive || path.endsWith("/.") || path.endsWith("\\.") || path.contains("..") || path.contains("./") || path.contains(".\\") ? FileUtil.normalizeFile((File)new File(path)).getAbsolutePath() : path;
        return normalized;
    }

    public static String convertRelativePathToAbsolute(SourceFileProperties source, String path) {
        if (!(path.startsWith("/") || path.length() > 1 && path.charAt(1) == ':')) {
            path = path.equals(".") ? source.getCompilePath() : source.getCompilePath() + File.separator + path;
            File file = new File(path);
            path = CndFileUtils.normalizeFile((File)file).getAbsolutePath();
        }
        if (Utilities.isWindows()) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static String removeQuotes(String path) {
        if (path.length() >= 2 && (path.charAt(0) == '\'' && path.charAt(path.length() - 1) == '\'' || path.charAt(0) == '\"' && path.charAt(path.length() - 1) == '\"')) {
            path = path.substring(1, path.length() - 1);
        }
        return path;
    }

    public static String removeEscape(String s) {
        int n = s.length();
        StringBuilder ret = new StringBuilder(n);
        int prev = 0;
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if ((c == ' ' || c == '\t' || c == ':' || c == '\'' || c == '*' || c == '\"' || c == '[' || c == ']' || c == '(' || c == ')' || c == ';') && prev == 92) {
                ret.setLength(ret.length() - 1);
            }
            ret.append(c);
            prev = c;
        }
        return ret.toString();
    }
}

