/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.ios;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cordova.platforms.api.WebKitDebuggingSupport;
import org.netbeans.modules.cordova.platforms.ios.Bundle;
import org.netbeans.modules.cordova.platforms.ios.IOSDevice;
import org.netbeans.modules.cordova.platforms.spi.Device;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.browser.api.WebBrowserFeatures;
import org.netbeans.modules.web.browser.spi.EnhancedBrowser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class IOSBrowser
extends HtmlBrowser.Impl
implements EnhancedBrowser {
    private final Kind kind;
    private Lookup projectContext;
    private static final Logger LOGGER = Logger.getLogger(IOSBrowser.class.getName());
    private URL url;

    public void initialize(WebBrowserFeatures browserFeatures) {
    }

    public void close(boolean closeTab) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                WebKitDebuggingSupport.getDefault().stopDebugging(true);
            }
        });
    }

    public void setProjectContext(Lookup projectContext) {
        this.projectContext = projectContext;
    }

    public boolean canReloadPage() {
        return false;
    }

    public boolean ignoreChange(FileObject fo) {
        return BrowserSupport.ignoreChangeDefaultImpl((FileObject)fo);
    }

    public IOSBrowser(Kind kind) {
        this.kind = kind;
    }

    public Component getComponent() {
        return null;
    }

    public void reloadDocument() {
        WebKitDebuggingSupport.getDefault().reload();
    }

    public void stopLoading() {
    }

    public void setURL(final URL url) {
        if (!Utilities.isMac()) {
            NotifyDescriptor not = new NotifyDescriptor((Object)Bundle.LBL_NoMac(), Bundle.ERR_Title(), -1, 0, null, null);
            DialogDisplayer.getDefault().notify(not);
            return;
        }
        final WebKitDebuggingSupport build = WebKitDebuggingSupport.getDefault();
        this.url = url;
        final IOSDevice dev = this.kind == Kind.IOS_DEVICE_DEFAULT ? IOSDevice.CONNECTED : IOSDevice.IPHONE;
        dev.openUrl(url.toExternalForm());
        final Project project = (Project)this.projectContext.lookup(Project.class);
        if (project == null) {
            return;
        }
        try {
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (IOSBrowser.this.kind == Kind.IOS_DEVICE_DEFAULT) {
                        try {
                            build.startDebugging((Device)dev, project, (Lookup)new ProxyLookup(new Lookup[]{IOSBrowser.this.projectContext, Lookups.fixed((Object[])new Object[]{ImageUtilities.loadImage((String)"org/netbeans/modules/cordova/platforms/ios/iosdevice16.png"), url})}), true);
                        }
                        catch (IllegalStateException ise) {
                            build.stopDebugging(true);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    NotifyDescriptor not = new NotifyDescriptor((Object)Bundle.LBL_DeviceNotConnected(), Bundle.TTL_DeviceNotConnected(), -1, 0, null, null);
                                    DialogDisplayer.getDefault().notify(not);
                                }
                            });
                        }
                    } else {
                        build.startDebugging((Device)dev, project, (Lookup)new ProxyLookup(new Lookup[]{IOSBrowser.this.projectContext, Lookups.fixed((Object[])new Object[]{ImageUtilities.loadImage((String)"org/netbeans/modules/cordova/platforms/ios/iossimulator16.png"), url})}), true);
                    }
                }
            }, (String)(this.kind == Kind.IOS_DEVICE_DEFAULT ? Bundle.LBL_OpeningiOS() : Bundle.LBL_Opening()), (AtomicBoolean)new AtomicBoolean(), (boolean)true);
        }
        catch (IllegalStateException ise) {
            LOGGER.log(Level.FINE, "Stopping debugging.", ise);
            WebKitDebuggingSupport.getDefault().stopDebugging(true);
        }
    }

    public static void openBrowser(String command, Lookup context, Kind kind, Project project, BrowserSupport browserSupport) throws IllegalArgumentException {
        WebKitDebuggingSupport build = WebKitDebuggingSupport.getDefault();
        assert (project != null && build != null);
        IOSDevice dev = kind == Kind.IOS_DEVICE_DEFAULT ? IOSDevice.CONNECTED : IOSDevice.IPHONE;
        String url1 = build.getUrl(project, context);
        FileObject f = build.getFile(project, context);
        try {
            browserSupport.load(new URL(url1), f);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public String getStatusMessage() {
        return "";
    }

    public String getTitle() {
        return Bundle.LBL_SafariTitle();
    }

    public boolean isForward() {
        return false;
    }

    public void forward() {
    }

    public boolean isBackward() {
        return false;
    }

    public void backward() {
    }

    public boolean isHistory() {
        return false;
    }

    public void showHistory() {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    public static enum Kind {
        IOS_DEVICE_DEFAULT,
        IOS_SIMULATOR_DEFAULT;

    }
}

