/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.toolchains.impl;

import org.clang.basic.SanitizerKind;
import org.clang.driver.Driver;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.options;
import org.clang.driver.toolchains.impl.Generic_GCC;
import org.clang.driver.tools.impl.CrossWindowsStatics;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.sys.path;

public class CrossWindowsToolChain
extends Generic_GCC
implements Destructors.ClassWithDestructor {
    public CrossWindowsToolChain(Driver D, Triple T, ArgList Args) {
        super(D, T, Args);
        if (this.GetCXXStdlibType(Args) == ToolChain.CXXStdlibType.CST_Libstdcxx) {
            std.string SysRoot = D.SysRoot;
            this.getFilePaths().push_back((Object)std.$add_string$C_T((std.string)SysRoot, (String)"/usr/lib"));
            this.getFilePaths().push_back((Object)std.$add_string$C_T((std.string)SysRoot, (String)"/usr/lib/gcc"));
        }
    }

    @Override
    public boolean IsIntegratedAssemblerDefault() {
        return true;
    }

    @Override
    public boolean IsUnwindTablesDefault() {
        return this.getArch() == Triple.ArchType.x86_64;
    }

    @Override
    public boolean isPICDefault() {
        return this.getArch() == Triple.ArchType.x86_64;
    }

    @Override
    public boolean isPIEDefault() {
        return this.getArch() == Triple.ArchType.x86_64;
    }

    @Override
    public boolean isPICDefaultForced() {
        return this.getArch() == Triple.ArchType.x86_64;
    }

    @Override
    public int GetDefaultStackProtectorLevel(boolean KernelOrKext) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void AddClangSystemIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            Driver D = this.getDriver();
            std.string SysRoot = D.SysRoot;
            if (DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdlibinc.getValue()))) {
                return;
            }
            CrossWindowsToolChain.addSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_string$C_T((std.string)SysRoot, (String)"/usr/local/include")));
            if (!DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nobuiltininc.getValue()))) {
                SmallString ResourceDir = new SmallString(new StringRef(D.ResourceDir), 128);
                path.append((SmallString)ResourceDir, (Twine)new Twine(NativePointer.$include));
                CrossWindowsToolChain.addSystemInclude(DriverArgs, CC1Args, new Twine(ResourceDir));
            }
            for (std.string P : (std.vectorString)$c$.clean($c$.track((Object)DriverArgs.getAllArgValues(new OptSpecifier(options.ID.OPT_isystem_after.getValue()))))) {
                CrossWindowsToolChain.addSystemInclude(DriverArgs, CC1Args, new Twine(P));
            }
            CrossWindowsToolChain.addExternCSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_string$C_T((std.string)SysRoot, (String)"/usr/include")));
        }
        finally {
            $c$.$destroy();
        }
    }

    @Override
    public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
        Triple Triple2 = this.getTriple();
        std.string SysRoot = this.getDriver().SysRoot;
        if (DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdlibinc.getValue())) || DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdincxx.getValue()))) {
            return;
        }
        switch (this.GetCXXStdlibType(DriverArgs)) {
            case CST_Libcxx: {
                CrossWindowsToolChain.addSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_string$C_T((std.string)SysRoot, (String)"/usr/include/c++/v1")));
                break;
            }
            case CST_Libstdcxx: {
                CrossWindowsToolChain.addSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_string$C_T((std.string)SysRoot, (String)"/usr/include/c++")));
                CrossWindowsToolChain.addSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_string_string$C((std.string)std.$add_string$C_T((std.string)SysRoot, (String)"/usr/include/c++/"), (std.string)Triple2.str())));
                CrossWindowsToolChain.addSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_string$C_T((std.string)SysRoot, (String)"/usr/include/c++/backwards")));
            }
        }
    }

    @Override
    public void AddCXXStdlibLibArgs(ArgList DriverArgs, ArgStringList CC1Args) {
        switch (this.GetCXXStdlibType(DriverArgs)) {
            case CST_Libcxx: {
                CC1Args.push_back((Object)NativePointer.$((String)"-lc++"));
                break;
            }
            case CST_Libstdcxx: {
                CC1Args.push_back((Object)NativePointer.$((String)"-lstdc++"));
                CC1Args.push_back((Object)NativePointer.$((String)"-lmingw32"));
                CC1Args.push_back((Object)NativePointer.$((String)"-lmingwex"));
                CC1Args.push_back((Object)NativePointer.$((String)"-lgcc"));
                CC1Args.push_back((Object)NativePointer.$((String)"-lmoldname"));
                CC1Args.push_back((Object)NativePointer.$((String)"-lmingw32"));
            }
        }
    }

    @Override
    public long getSupportedSanitizers() {
        long Res = super.getSupportedSanitizers();
        return Res |= SanitizerKind.Address;
    }

    @Override
    protected Tool buildLinker() {
        return new CrossWindowsStatics.Linker(this);
    }

    @Override
    protected Tool buildAssembler() {
        return new CrossWindowsStatics.Assembler(this);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

