/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.cnd.repository.api.UnitDescriptor;

final class UnitDescriptorsDictionary {
    private final Map<UnitDescriptor, Integer> map = new HashMap<UnitDescriptor, Integer>();
    private final AtomicInteger counter = new AtomicInteger(7);
    private final Object lock = new Object();

    UnitDescriptorsDictionary() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnitID(UnitDescriptor clientUnitDescriptor) {
        Object object = this.lock;
        synchronized (object) {
            Integer result = this.map.get(clientUnitDescriptor);
            if (result == null) {
                result = this.counter.getAndIncrement();
                this.map.put(clientUnitDescriptor, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer remove(Integer clientShortUnitID) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.remove(this.getUnitDescriptor(clientShortUnitID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UnitDescriptor getUnitDescriptor(Integer clientShortUnitID) {
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<UnitDescriptor, Integer> entry : this.map.entrySet()) {
                if (!entry.getValue().equals(clientShortUnitID)) continue;
                return entry.getKey();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean contains(UnitDescriptor clientUnitDescriptor) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsKey(clientUnitDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder("\n[clientUnitDescriptor <-> clientShortUnitID]\n");
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<UnitDescriptor, Integer> entry : this.map.entrySet()) {
                sb.append(entry.getKey()).append(" => ").append(entry.getValue()).append("\n");
            }
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Integer> getUnitIDs() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.values();
        }
    }
}

