/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.testng.TestNGException;
import org.testng.collections.Lists;

public class PoolService<FutureType> {
    private ExecutorCompletionService<FutureType> m_completionService;
    private ThreadFactory m_threadFactory = new ThreadFactory(){
        private int m_threadIndex = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread result = new Thread(r);
            result.setName("PoolService-" + this.m_threadIndex);
            ++this.m_threadIndex;
            return result;
        }
    };
    private ExecutorService m_executor;

    public PoolService(int threadPoolSize) {
        this.m_executor = Executors.newFixedThreadPool(threadPoolSize, this.m_threadFactory);
        this.m_completionService = new ExecutorCompletionService(this.m_executor);
    }

    public List<FutureType> submitTasksAndWait(List<? extends Callable<FutureType>> tasks) {
        List result = Lists.newArrayList();
        for (Callable<FutureType> callable : tasks) {
            this.m_completionService.submit(callable);
        }
        for (int i = 0; i < tasks.size(); ++i) {
            try {
                Future<FutureType> take = this.m_completionService.take();
                result.add(take.get());
                continue;
            }
            catch (InterruptedException e) {
                throw new TestNGException(e);
            }
            catch (ExecutionException e) {
                throw new TestNGException(e);
            }
        }
        this.m_executor.shutdown();
        return result;
    }
}

