/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.providers;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.ui.SwingWorker;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProgressDisplayer;
import org.netbeans.modules.profiler.api.java.ProfilerTypeUtils;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.nbimpl.javac.ElementUtilitiesEx;
import org.netbeans.modules.profiler.nbimpl.javac.ParsingUtils;
import org.netbeans.modules.profiler.nbimpl.javac.ScanSensitiveTask;
import org.netbeans.modules.profiler.nbimpl.providers.Bundle;
import org.netbeans.modules.profiler.spi.java.GoToSourceProvider;
import org.netbeans.modules.profiler.ui.ProfilerProgressDisplayer;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;

public final class GoToJavaSourceProvider
extends GoToSourceProvider {
    private static final Logger LOG = Logger.getLogger(GoToJavaSourceProvider.class.getName());

    public boolean openSource(Lookup.Provider project, String className, String methodName, String signature, int line) {
        String normalizedClassName = className.replace("[", "").replace("]", "").replace('/', '.');
        if (VMUtils.isPrimitiveType((String)normalizedClassName)) {
            ProfilerDialogs.displayWarning((String)Bundle.MSG_CannotShowPrimitive());
            return true;
        }
        ProfilerProgressDisplayer pd = ProfilerProgressDisplayer.getDefault();
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        final ProgressDisplayer.ProgressController[] pc = new ProgressDisplayer.ProgressController[1];
        final GotoSourceRunnable r = new GotoSourceRunnable(project, normalizedClassName, methodName, signature, line, cancelled);
        new SwingWorker(false, (ProgressDisplayer)pd, className, methodName, signature, line){
            final /* synthetic */ ProgressDisplayer val$pd;
            final /* synthetic */ String val$className;
            final /* synthetic */ String val$methodName;
            final /* synthetic */ String val$signature;
            final /* synthetic */ int val$line;
            {
                this.val$pd = progressDisplayer;
                this.val$className = string;
                this.val$methodName = string2;
                this.val$signature = string3;
                this.val$line = n;
                super(x0);
            }

            protected void doInBackground() {
                r.run();
            }

            protected void nonResponding() {
                pc[0] = new ProgressDisplayer.ProgressController(){

                    public boolean cancel() {
                        if (cancelled.compareAndSet(false, true)) {
                            val$pd.close();
                        }
                        return true;
                    }
                };
                String target = MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(this.val$className, this.val$methodName, this.val$signature).toFormatted();
                this.val$pd.showProgress(Bundle.MSG_ScanningInProgress(), this.val$line == -1 ? Bundle.MSG_Opening(target) : Bundle.MSG_OpeningOnLine(target, this.val$line), pc[0]);
            }

            protected void done() {
                if (!cancelled.get()) {
                    this.val$pd.close();
                }
            }
        }.execute();
        return r.isSuccess();
    }

    public boolean openFile(final FileObject srcFile, final int offset) {
        final boolean[] rslt = new boolean[]{false};
        Runnable action = new Runnable(){

            @Override
            public void run() {
                rslt[0] = UiUtils.open((FileObject)srcFile, (int)offset);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            action.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(action);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException e) {
                ProfilerLogger.log((Exception)e);
            }
        }
        return rslt[0];
    }

    private static boolean openAtLine(CompilationController controller, Document doc, String methodName, int line) {
        try {
            if (line > -1) {
                Line l;
                LineCookie lc;
                String offsetMethodName;
                DataObject od = DataObject.find((FileObject)controller.getFileObject());
                int offset = NbDocument.findLineOffset((StyledDocument)((StyledDocument)doc), (int)line);
                ExecutableElement parentMethod = controller.getTreeUtilities().scopeFor(offset).getEnclosingMethod();
                if (parentMethod != null && methodName.equals(offsetMethodName = parentMethod.getSimpleName().toString()) && (lc = (LineCookie)od.getLookup().lookup(LineCookie.class)) != null && (l = lc.getLineSet().getCurrent(line - 1)) != null) {
                    CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        }
                    });
                    return true;
                }
            }
        }
        catch (DataObjectNotFoundException e) {
            LOG.log(Level.WARNING, "Error accessing dataobject", e);
        }
        return false;
    }

    private static class GotoSourceRunnable
    implements Runnable {
        private Lookup.Provider project;
        private String className;
        private String methodName;
        private String signature;
        private int line;
        private final AtomicBoolean cancelled;
        private final AtomicBoolean result = new AtomicBoolean(true);

        public GotoSourceRunnable(Lookup.Provider project, String className, String methodName, String signature, int line, AtomicBoolean cancelled) {
            this.project = project;
            this.className = className;
            this.methodName = methodName;
            this.signature = signature;
            this.line = line;
            this.cancelled = cancelled;
        }

        @Override
        public void run() {
            FileObject sourceFile;
            SourceClassInfo ci = ProfilerTypeUtils.resolveClass((String)this.className, (Lookup.Provider)this.project);
            FileObject fileObject = sourceFile = ci != null ? ci.getFile() : null;
            if (sourceFile == null) {
                return;
            }
            JavaSource js = JavaSource.forFileObject((FileObject)sourceFile);
            if (js != null) {
                ScanSensitiveTask<CompilationController> t = new ScanSensitiveTask<CompilationController>(){

                    public void run(CompilationController controller) throws Exception {
                        if (!controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).equals((Object)JavaSource.Phase.ELEMENTS_RESOLVED)) {
                            return;
                        }
                        TypeElement parentClass = ElementUtilitiesEx.resolveClassByName(GotoSourceRunnable.this.className, controller, true);
                        if (GotoSourceRunnable.this.cancelled != null && GotoSourceRunnable.this.cancelled.get()) {
                            return;
                        }
                        if (ElementOpen.open((ClasspathInfo)controller.getClasspathInfo(), (Element)parentClass)) {
                            Document doc = controller.getDocument();
                            if (doc != null && doc instanceof StyledDocument) {
                                ExecutableElement methodElement;
                                if (GoToJavaSourceProvider.openAtLine(controller, doc, GotoSourceRunnable.this.methodName, GotoSourceRunnable.this.line)) {
                                    GotoSourceRunnable.this.result.set(true);
                                    return;
                                }
                                if (GotoSourceRunnable.this.methodName != null && (methodElement = ElementUtilitiesEx.resolveMethodByName((CompilationInfo)controller, parentClass, GotoSourceRunnable.this.methodName, GotoSourceRunnable.this.signature)) != null && ElementOpen.open((ClasspathInfo)controller.getClasspathInfo(), (Element)methodElement)) {
                                    GotoSourceRunnable.this.result.set(true);
                                    return;
                                }
                            }
                            GotoSourceRunnable.this.result.set(true);
                        }
                    }

                    @Override
                    public boolean shouldRetry() {
                        return !GotoSourceRunnable.this.result.get();
                    }
                };
                ParsingUtils.invokeScanSensitiveTask(js, t);
            }
        }

        public boolean isSuccess() {
            return this.result.get();
        }
    }
}

