/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.jstestdriver.ext;

import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.JsTestDriver;
import com.google.jstestdriver.browser.DocType;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.config.DefaultConfiguration;
import com.google.jstestdriver.embedded.JsTestDriverBuilder;
import com.google.jstestdriver.hooks.ServerListener;
import com.google.jstestdriver.model.BasePaths;
import com.google.jstestdriver.runner.RunnerMode;
import java.io.File;
import java.util.concurrent.Semaphore;

public class StartServer {
    private Semaphore s;

    public static void main(String[] args) {
        assert (args.length == 2);
        int port = Integer.parseInt(args[0]);
        boolean strict = Boolean.parseBoolean(args[1]);
        new StartServer().startServer(port, strict);
    }

    public void startServer(int port, boolean strict) {
        System.out.println("Starting js-test-driver server on port " + port);
        JsTestDriver serverRunner = new JsTestDriverBuilder().setDefaultConfiguration((Configuration)new ServerConfiguration(strict)).raiseExceptionOnTestFailure(false).addServerListener((ServerListener)new MyListener()).setRunnerMode(RunnerMode.QUIET).setPort(port).build();
        serverRunner.startServer();
        this.s = new Semaphore(0);
        try {
            this.s.acquire();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    class MyListener
    implements ServerListener {
        public void serverStarted() {
            System.out.println("msg.server.started");
        }

        public void serverStopped() {
            System.out.println("Starting stopped");
            StartServer.this.s.release();
        }

        public void browserCaptured(BrowserInfo bi) {
            System.out.println("New browser captured:\n" + bi);
        }

        public void browserPanicked(BrowserInfo bi) {
            System.out.println("Browser panicked:\n" + bi);
        }
    }

    static class ServerConfiguration
    extends DefaultConfiguration {
        private boolean strictMode;

        public ServerConfiguration(boolean strictMode) {
            super(new BasePaths(new File[]{new File(".")}));
            this.strictMode = strictMode;
        }

        public DocType getDocType() {
            return this.strictMode ? DocType.STRICT : DocType.QUIRKS;
        }
    }
}

