/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.execution;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openide.util.Mutex;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class IOTabsController {
    private static final IOTabsController instance = new IOTabsController();
    private static final TabsGroupGroupsComparator comparator = new TabsGroupGroupsComparator();
    private final List<TabsGroup> groups = new ArrayList<TabsGroup>();

    public static IOTabsController getDefault() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabsGroup openTabsGroup(String groupName, boolean reuse) {
        List<TabsGroup> list = this.groups;
        synchronized (list) {
            ArrayList<TabsGroup> toRemove = new ArrayList<TabsGroup>();
            for (TabsGroup tabsGroup : this.groups) {
                if (!tabsGroup.canForget()) continue;
                toRemove.add(tabsGroup);
            }
            for (TabsGroup tabsGroup : toRemove) {
                this.groups.remove(tabsGroup);
            }
            if (reuse) {
                TabsGroup toReuse = null;
                for (TabsGroup group : this.groups) {
                    if (!group.groupName.equals(groupName) || group.isLocked()) continue;
                    toReuse = group;
                    break;
                }
                if (toReuse != null) {
                    toReuse.closeAll();
                    this.groups.remove(toReuse);
                }
            }
            int idx = 1;
            for (TabsGroup group : this.groups) {
                if (!group.groupName.equals(groupName) || idx < group.seqID) continue;
                ++idx;
            }
            TabsGroup tabsGroup = new TabsGroup(groupName, idx);
            this.groups.add(tabsGroup);
            Collections.sort(this.groups, comparator);
            return tabsGroup;
        }
    }

    public static InputOutput getInputOutput(InputOutputTab ioTab) {
        return (InputOutput)ioTab.inputOutputRef.get();
    }

    public static interface IOTabFactory {
        public InputOutput createNewTab(String var1);
    }

    private static final class TabsGroupGroupsComparator
    implements Comparator<TabsGroup> {
        private TabsGroupGroupsComparator() {
        }

        @Override
        public int compare(TabsGroup o1, TabsGroup o2) {
            return o1.seqID - o2.seqID;
        }
    }

    public static final class InputOutputTab {
        private final String name;
        private final WeakReference<InputOutput> inputOutputRef;

        private InputOutputTab(String name, InputOutput inputOutput) {
            this.name = name;
            this.inputOutputRef = new WeakReference<InputOutput>(inputOutput);
        }

        public String getName() {
            return this.name;
        }

        public void select() {
            Mutex.EVENT.postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    InputOutput io = (InputOutput)InputOutputTab.this.inputOutputRef.get();
                    if (io != null) {
                        io.select();
                    }
                }
            });
        }

        private OutputWriter getOutputWriter() {
            InputOutput io = (InputOutput)this.inputOutputRef.get();
            return io == null ? null : io.getOut();
        }

        public void closeOutput() {
            Mutex.EVENT.postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    OutputWriter outputWriter = InputOutputTab.this.getOutputWriter();
                    if (outputWriter != null) {
                        outputWriter.close();
                    }
                }
            });
        }

        private void closeTab() {
            final InputOutput io = (InputOutput)this.inputOutputRef.get();
            if (io != null) {
                Mutex.EVENT.postWriteRequest(new Runnable(){

                    @Override
                    public void run() {
                        io.closeInputOutput();
                    }
                });
            }
        }

        private void resetIO() {
            Mutex.EVENT.postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    OutputWriter outputWriter = InputOutputTab.this.getOutputWriter();
                    if (outputWriter != null) {
                        try {
                            outputWriter.reset();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    public static final class TabsGroup {
        private final List<InputOutputTab> tabs = new ArrayList<InputOutputTab>();
        private final AtomicBoolean locked = new AtomicBoolean(false);
        private final String groupName;
        private final int seqID;

        private TabsGroup(String groupName, int seqID) {
            this.seqID = seqID;
            this.groupName = groupName;
        }

        private boolean isLocked() {
            return this.locked.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputOutputTab getTab(String tabName, IOTabFactory factory) {
            String name = this.seqID == 1 ? tabName : tabName.concat(" #" + this.seqID);
            List<InputOutputTab> list = this.tabs;
            synchronized (list) {
                for (InputOutputTab tab : this.tabs) {
                    if (!tab.name.equals(name)) continue;
                    return tab;
                }
                InputOutputTab newTab = new InputOutputTab(name, factory.createNewTab(name));
                this.tabs.add(newTab);
                return newTab;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeAll() {
            List<InputOutputTab> list = this.tabs;
            synchronized (list) {
                for (InputOutputTab tab : this.tabs) {
                    tab.closeTab();
                }
                this.tabs.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lockAndReset() {
            if (!this.locked.compareAndSet(false, true)) {
                throw new IllegalStateException("Already locked");
            }
            List<InputOutputTab> list = this.tabs;
            synchronized (list) {
                Mutex.EVENT.writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                    public Void run() {
                        for (InputOutputTab tab : TabsGroup.this.tabs) {
                            tab.resetIO();
                            tab.closeOutput();
                        }
                        return null;
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlockAndCloseOutput() {
            List<InputOutputTab> list = this.tabs;
            synchronized (list) {
                if (!this.locked.get()) {
                    throw new IllegalStateException("Not locked: " + this.toString());
                }
                Mutex.EVENT.writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                    public Void run() {
                        for (InputOutputTab tab : TabsGroup.this.tabs) {
                            tab.closeOutput();
                        }
                        return null;
                    }
                });
                this.locked.set(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean canForget() {
            List<InputOutputTab> list = this.tabs;
            synchronized (list) {
                for (InputOutputTab tab : this.tabs) {
                    if (tab.inputOutputRef.get() == null) continue;
                    return false;
                }
                this.tabs.clear();
                return true;
            }
        }

        public String toString() {
            return "Group of IO tabs named " + this.groupName;
        }
    }
}

