/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.openide.util.Lookup;

public abstract class CsmFunctionDefinitionResolver {
    private static final CsmFunctionDefinitionResolver DEFAULT = new Default();

    protected CsmFunctionDefinitionResolver() {
    }

    public static CsmFunctionDefinitionResolver getDefault() {
        return DEFAULT;
    }

    public abstract CsmReference getFunctionDefinition(CsmFunction var1);

    public abstract Collection<CsmOffsetableDeclaration> findDeclarationByName(CsmProject var1, String var2);

    private static final class Default
    extends CsmFunctionDefinitionResolver {
        private final Lookup.Result<CsmFunctionDefinitionResolver> res = Lookup.getDefault().lookupResult(CsmFunctionDefinitionResolver.class);

        private Default() {
        }

        @Override
        public CsmReference getFunctionDefinition(CsmFunction referencedFunction) {
            for (CsmFunctionDefinitionResolver resolver : this.res.allInstances()) {
                CsmReference out = resolver.getFunctionDefinition(referencedFunction);
                if (out == null) continue;
                return out;
            }
            return null;
        }

        @Override
        public Collection<CsmOffsetableDeclaration> findDeclarationByName(CsmProject project, String name) {
            for (CsmFunctionDefinitionResolver resolver : this.res.allInstances()) {
                Collection<CsmOffsetableDeclaration> out = resolver.findDeclarationByName(project, name);
                if (out == null) continue;
                return out;
            }
            return null;
        }
    }
}

