/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.branch;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.branch.BranchSelectorPanel;
import org.netbeans.modules.mercurial.remote.ui.branch.HgBranch;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BranchSelector
implements ListSelectionListener,
DocumentListener {
    private final BranchSelectorPanel panel;
    private JButton okButton;
    private final JButton cancelButton;
    private final VCSFileProxy repository;
    private static final RequestProcessor rp = new RequestProcessor("BranchPicker", 1, true);
    private boolean bGettingRevisions = false;
    private InitialLoadingProgressSupport loadingSupport;
    private static final String MARK_ACTIVE_HEAD = "*";
    private static final String INITIAL_REVISION = NbBundle.getMessage(BranchSelectorPanel.class, (String)"MSG_Revision_Loading");
    private static final String NO_BRANCH = NbBundle.getMessage(BranchSelectorPanel.class, (String)"MSG_Revision_NoRevision");
    private HgLogMessage.HgRevision parentRevision;
    private final Timer filterTimer;
    private HgBranch[] branches;
    private final Object LOCK = new Object();

    public BranchSelector(VCSFileProxy repository) {
        this.repository = repository;
        this.panel = new BranchSelectorPanel();
        this.panel.branchList.setCellRenderer(new RevisionRenderer());
        this.filterTimer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSelector.this.filterTimer.stop();
                BranchSelector.this.applyFilter();
            }
        });
        this.panel.txtFilter.getDocument().addDocumentListener(this);
        this.panel.branchList.addListSelectionListener(this);
        this.panel.jPanel1.setVisible(false);
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(BranchSelector.class, (String)"CTL_BranchSelector_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BranchSelector.class, (String)"ACSD_BranchSelector_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BranchSelector.class, (String)"ACSN_BranchSelector_Action_Cancel"));
    }

    public boolean showDialog(JButton okButton, String title, String branchListDescription) {
        this.okButton = okButton;
        Mnemonics.setLocalizedText((JLabel)this.panel.jLabel1, (String)branchListDescription);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, title, true, new Object[]{okButton, this.cancelButton}, (Object)okButton, 0, new HelpCtx(this.getClass()), null);
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(title);
        this.loadRevisions();
        dialog.setVisible(true);
        InitialLoadingProgressSupport supp = this.loadingSupport;
        if (supp != null) {
            supp.cancel();
        }
        boolean ret = dialogDescriptor.getValue() == okButton;
        return ret;
    }

    public boolean showGeneralDialog() {
        JButton btn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)btn, (String)NbBundle.getMessage(BranchSelector.class, (String)"CTL_BranchSelectorPanel_Action_OK"));
        btn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BranchSelector.class, (String)"ACSD_BranchSelectorPanel_Action_OK"));
        btn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BranchSelector.class, (String)"ACSN_BranchSelectorPanel_Action_OK"));
        btn.setEnabled(false);
        return this.showDialog(btn, NbBundle.getMessage(BranchSelector.class, (String)"CTL_BranchSelectorPanel.title", (Object)this.repository.getName()), NbBundle.getMessage(BranchSelector.class, (String)"BranchSelectorPanel.infoLabel.text"));
    }

    public String getBranchName() {
        HgBranch selectedBranch = this.getSelectedBranch();
        return selectedBranch == null ? null : selectedBranch.getName();
    }

    private HgBranch getSelectedBranch() {
        if (this.panel.branchList.getSelectedValue() instanceof HgBranch) {
            return (HgBranch)this.panel.branchList.getSelectedValue();
        }
        return null;
    }

    private String getRefreshLabel() {
        return NbBundle.getMessage(BranchSelectorPanel.class, (String)"MSG_BranchSelector_Refreshing_Branches");
    }

    private void loadRevisions() {
        this.loadingSupport = new InitialLoadingProgressSupport();
        this.loadingSupport.start(rp, this.repository, this.getRefreshLabel());
    }

    public void setOptionsPanel(JPanel optionsPanel, Border parentPanelBorder) {
        if (optionsPanel == null) {
            this.panel.jPanel1.setVisible(false);
        } else {
            if (parentPanelBorder != null) {
                this.panel.jPanel1.setBorder(parentPanelBorder);
            }
            this.panel.jPanel1.removeAll();
            this.panel.jPanel1.add((Component)optionsPanel, "North");
            this.panel.jPanel1.setVisible(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            HgBranch branch = null;
            if (this.panel.branchList.getSelectedValue() instanceof HgBranch) {
                branch = (HgBranch)this.panel.branchList.getSelectedValue();
            }
            if (branch == null) {
                this.okButton.setEnabled(false);
            } else {
                this.okButton.setEnabled(true);
                this.panel.changesetPanel1.setInfo(branch.getRevisionInfo());
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.bGettingRevisions) {
            this.filterTimer.restart();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.bGettingRevisions) {
            this.filterTimer.restart();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFilter() {
        HgBranch selectedBranch = this.getSelectedBranch();
        DefaultListModel<Object> targetsModel = new DefaultListModel<Object>();
        targetsModel.removeAllElements();
        HgBranch toSelect = null;
        String filter = this.panel.txtFilter.getText();
        Object object = this.LOCK;
        synchronized (object) {
            for (HgBranch branch : this.branches) {
                if (!this.applies(filter, branch)) continue;
                if (selectedBranch != null && branch.getRevisionInfo().getCSetShortID().equals(selectedBranch.getRevisionInfo().getCSetShortID())) {
                    toSelect = branch;
                } else if (this.parentRevision != null && branch.getRevisionInfo().getCSetShortID().equals(this.parentRevision.getChangesetId())) {
                    toSelect = branch;
                }
                targetsModel.addElement(branch);
            }
        }
        if (targetsModel.isEmpty()) {
            targetsModel.addElement(NO_BRANCH);
        }
        if (!Arrays.equals(targetsModel.toArray(), ((DefaultListModel)this.panel.branchList.getModel()).toArray())) {
            this.panel.branchList.setModel(targetsModel);
            if (toSelect != null) {
                this.panel.branchList.setSelectedValue(toSelect, true);
            } else if (targetsModel.size() > 0) {
                this.panel.branchList.setSelectedIndex(0);
            }
        }
    }

    private boolean applies(String filter, HgBranch branch) {
        boolean applies = filter.isEmpty();
        filter = filter.toLowerCase(Locale.getDefault());
        String inactiveLabel = NbBundle.getMessage(BranchSelector.class, (String)"LBL_BranchSelector.branch.inactive");
        if (!applies) {
            HgLogMessage message = branch.getRevisionInfo();
            if (branch.getName().contains(filter) || branch.isActive() && "active".startsWith(filter) || !branch.isActive() && inactiveLabel.startsWith(filter) || message.getRevisionNumber().contains(filter) || message.getAuthor().toLowerCase(Locale.getDefault()).contains(filter) || message.getCSetShortID().toLowerCase(Locale.getDefault()).contains(filter) || message.getMessage().toLowerCase(Locale.getDefault()).contains(filter) || message.getUsername().toLowerCase(Locale.getDefault()).contains(filter) || this.applies(filter, message.getBranches()) || this.applies(filter, message.getTags()) || DateFormat.getDateTimeInstance().format(message.getDate()).toLowerCase(Locale.getDefault()).contains(filter)) {
                applies = true;
            }
        }
        return applies;
    }

    private boolean applies(String format, String[] array) {
        for (String v : array) {
            if (!v.toLowerCase(Locale.getDefault()).contains(format)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ HgBranch[] access$1102(BranchSelector x0, HgBranch[] x1) {
        x0.branches = x1;
        return x1;
    }

    private class RevisionRenderer
    extends DefaultListCellRenderer {
        private RevisionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof HgBranch) {
                HgBranch branch = (HgBranch)value;
                StringBuilder sb = new StringBuilder().append(branch.getName());
                HgLogMessage.HgRevision parent = BranchSelector.this.parentRevision;
                if (parent != null && parent.getRevisionNumber().equals(branch.getRevisionInfo().getRevisionNumber())) {
                    sb.append(BranchSelector.MARK_ACTIVE_HEAD);
                }
                sb.append(" (").append(branch.getRevisionInfo().getCSetShortID().substring(0, 7));
                if (!branch.isActive()) {
                    sb.append(" - ").append(NbBundle.getMessage(BranchSelector.class, (String)"LBL_BranchSelector.branch.inactive"));
                }
                sb.append(")");
                value = sb.toString();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private class InitialLoadingProgressSupport
    extends HgProgressSupport {
        private InitialLoadingProgressSupport() {
        }

        @Override
        public void perform() {
            try {
                final DefaultListModel<String> targetsModel = new DefaultListModel<String>();
                targetsModel.addElement(INITIAL_REVISION);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((BranchSelector)BranchSelector.this).panel.branchList.setModel(targetsModel);
                        if (!targetsModel.isEmpty()) {
                            ((BranchSelector)BranchSelector.this).panel.branchList.setSelectedIndex(0);
                        }
                    }
                });
                this.refreshRevisions(this);
            }
            finally {
                BranchSelector.this.loadingSupport = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshRevisions(HgProgressSupport supp) {
            HgBranch[] fetchedBranches;
            BranchSelector.this.bGettingRevisions = true;
            OutputLogger logger = Mercurial.getInstance().getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            try {
                fetchedBranches = HgCommand.getBranches(BranchSelector.this.repository, logger);
            }
            catch (HgException ex) {
                Mercurial.LOG.log(Level.INFO, null, ex);
                fetchedBranches = null;
            }
            if (fetchedBranches == null) {
                fetchedBranches = new HgBranch[]{};
            }
            if (!supp.isCanceled() && fetchedBranches.length > 0) {
                try {
                    BranchSelector.this.parentRevision = HgCommand.getParent(BranchSelector.this.repository, null, null);
                }
                catch (HgException ex) {
                    Mercurial.LOG.log(Level.FINE, null, ex);
                }
            }
            if (!supp.isCanceled()) {
                Arrays.sort(fetchedBranches, new Comparator<HgBranch>(){

                    @Override
                    public int compare(HgBranch b1, HgBranch b2) {
                        return b1.getName().compareTo(b2.getName());
                    }
                });
                Object object = BranchSelector.this.LOCK;
                synchronized (object) {
                    BranchSelector.access$1102(BranchSelector.this, fetchedBranches);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BranchSelector.this.applyFilter();
                        BranchSelector.this.bGettingRevisions = false;
                    }
                });
            }
        }
    }
}

