/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import java.util.Hashtable;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.request.MemoryRealm;
import org.apache.tomcat.util.SecurityTools;

public class SimpleRealm
extends BaseInterceptor {
    MemoryRealm memoryRealm;
    ContextManager cm;
    int reqRolesNote;

    public int authenticate(Request req, Response response) {
        Hashtable cred = new Hashtable();
        SecurityTools.credentials(req, cred);
        String user = (String)cred.get("username");
        String password = (String)cred.get("password");
        if (this.debug > 0) {
            this.log("Verify user=" + user + " pass=" + password);
        }
        if (this.memoryRealm.checkPassword(user, password)) {
            if (this.debug > 0) {
                this.log("Auth ok, user=" + user);
            }
            req.setRemoteUser(user);
            Context ctx = req.getContext();
            if (ctx != null) {
                req.setAuthType(ctx.getAuthMethod());
            }
        }
        return 0;
    }

    public int authorize(Request req, Response response, String[] roles) {
        if (roles == null || roles.length == 0) {
            return 0;
        }
        Context ctx = req.getContext();
        String[] userRoles = null;
        String user = req.getRemoteUser();
        if (user == null) {
            return 401;
        }
        if (this.debug > 0) {
            this.log("Controled access for " + user + " " + req + " " + req.getContainer());
        }
        userRoles = this.memoryRealm.getUserRoles(user);
        req.setUserRoles(userRoles);
        if (SecurityTools.haveRole(userRoles, roles)) {
            return 0;
        }
        if (this.debug > 0) {
            this.log("UnAuthorized " + roles[0]);
        }
        return 401;
    }

    public void contextInit(Context ctx) throws TomcatException {
        block2: {
            if (this.memoryRealm != null) break block2;
            this.memoryRealm = new MemoryRealm(ctx);
            try {
                this.memoryRealm.readMemoryRealm(ctx);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.memoryRealm = null;
            }
        }
    }

    public void setContextManager(ContextManager cm) {
        super.setContextManager(cm);
        this.cm = cm;
        try {
            this.reqRolesNote = cm.getNoteId(2, "required.roles");
        }
        catch (TomcatException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Invalid state ");
        }
    }
}

