/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.ui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.karma.preferences.KarmaPreferences;
import org.netbeans.modules.javascript.karma.ui.actions.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;

public final class SetKarmaConfAction
extends AbstractAction
implements ContextAwareAction {
    @NullAllowed
    private final Project project;
    @NullAllowed
    private final FileObject karmaConfJs;

    public SetKarmaConfAction() {
        this((Project)null, (FileObject)null);
    }

    public SetKarmaConfAction(Project project, FileObject karmaConfJs) {
        this.project = project;
        this.karmaConfJs = karmaConfJs;
        this.setEnabled(karmaConfJs != null);
        this.putValue("hideWhenDisabled", true);
        this.putValue("Name", Bundle.SetKarmaConfAction_name());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (this.project != null);
        assert (this.karmaConfJs != null);
        KarmaPreferences.setConfig(this.project, FileUtil.toFile((FileObject)this.karmaConfJs).getAbsolutePath());
    }

    public Action createContextAwareInstance(Lookup context) {
        DataObject dataObject;
        FileObject file = (FileObject)context.lookup(FileObject.class);
        if (file == null && (dataObject = (DataObject)context.lookup(DataObject.class)) != null) {
            file = dataObject.getPrimaryFile();
        }
        if (file == null) {
            return this;
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)file);
        if (owner == null) {
            return this;
        }
        if (!KarmaPreferences.isEnabled(owner)) {
            return this;
        }
        return new SetKarmaConfAction(owner, file);
    }
}

