/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask.jrefmask;

import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.mask.jrefmask.MemoryMap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class CardMemory {
    byte isVirginMask;
    MemoryMap memoryConfig;
    private ByteArrayOutputStream ROMBos;
    private ByteArrayOutputStream E2Bos;
    private DataOutputStream ROMDos;
    private DataOutputStream E2Dos;

    public CardMemory(int n) {
        this.memoryConfig = new MemoryMap(n);
        this.isVirginMask = (byte)-1;
        this.ROMBos = new ByteArrayOutputStream();
        this.ROMDos = new DataOutputStream(this.ROMBos);
        this.E2Bos = new ByteArrayOutputStream();
        this.E2Dos = new DataOutputStream(this.E2Bos);
    }

    int getE2Base() {
        return this.memoryConfig.getROMSize();
    }

    void addToRom(byte[] byArray) {
        try {
            if (this.ROMDos.size() + byArray.length > this.memoryConfig.getROMSize()) {
                Msg.error("jref.4", null);
                System.exit(1);
            }
            this.ROMDos.write(byArray, 0, byArray.length);
            this.ROMDos.flush();
        }
        catch (IOException iOException) {
            Msg.error("jref.2", null);
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    void addToE2(byte[] byArray) {
        try {
            if (this.E2Dos.size() + byArray.length > this.memoryConfig.getE2Size()) {
                Msg.error("jref.5", null);
                System.exit(1);
            }
            this.E2Dos.write(byArray, 0, byArray.length);
            this.E2Dos.flush();
            this.memoryConfig.setNextE2Address((short)this.E2Bos.size());
        }
        catch (IOException iOException) {
            Msg.error("jref.2", null);
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    public short getNextRomAddr() {
        return (short)this.ROMBos.size();
    }

    public short getNextE2Address() {
        return (short)this.E2Bos.size();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.isVirginMask);
        this.memoryConfig.write(dataOutputStream);
        dataOutputStream.writeShort(this.ROMBos.size());
        dataOutputStream.write(this.ROMBos.toByteArray());
        dataOutputStream.writeShort(this.E2Bos.size());
        dataOutputStream.write(this.E2Bos.toByteArray());
        this.ROMDos.close();
        this.ROMBos.close();
        this.E2Dos.close();
        this.E2Bos.close();
    }
}

