/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.converter.AppletProfile;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.PackageProfile;
import com.sun.javacard.converter.util.ClassFileNameFilter;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.converter.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

public class OptionParser {
    String[] argv;
    ConversionProfile cp;
    public static String[] keys = new String[]{"-classdir", "-i", "-exportpath", "-exportmap", "-applet", "-d", "-out", "-V", "-version", "-v", "-verbose", "-help", "-nowarn", "-mask", "-debug", "-nobanner", "-noverify", "-config"};
    public static String[] keysWithFileNameArgs = new String[]{"-classdir", "-exportpath", "-d", "-config"};
    public static String[] keysWithNoArgs = new String[]{"-exportmap", "-i", "-V", "-version", "-v", "-verbose", "-help", "-nowarn", "-mask", "-debug", "-nobanner", "-noverify"};
    public static Vector<String> keysV = new Vector();
    public static Vector<String> keysWithFileNameArgsV = new Vector();
    public static Vector<String> keysWithNoArgsV = new Vector();

    public OptionParser(String[] stringArray, ConversionProfile conversionProfile) {
        this.argv = stringArray;
        this.cp = conversionProfile;
        for (String string : keys) {
            keysV.addElement(string);
        }
        for (String string : keysWithFileNameArgs) {
            keysWithFileNameArgsV.addElement(string);
        }
        for (String string : keysWithNoArgs) {
            keysWithNoArgsV.addElement(string);
        }
    }

    public void parse() {
        try {
            if (this.argv == null || this.argv.length == 0) {
                OptionParser.usage();
                System.exit(1);
            }
            if (this.argv[0].equals("-config")) {
                this.parseOptionsFromFile(this.argv);
            } else {
                this.parseOptionsFromCommandLine(this.argv);
            }
        }
        catch (Exception exception) {
            OptionParser.usage();
            System.exit(1);
        }
        this.checkOptions();
    }

    private Vector<String> putQuotedTogether(Vector<String> vector) {
        Object object;
        int n;
        boolean bl = false;
        Vector<String> vector2 = new Vector<String>();
        for (n = 0; n < vector.size(); ++n) {
            object = vector.elementAt(n);
            if (((String)object).indexOf("\"") == -1) {
                if (bl) {
                    vector2.setElementAt(vector2.lastElement() + " " + (String)object, vector2.indexOf(vector2.lastElement()));
                    continue;
                }
                vector2.addElement((String)object);
                continue;
            }
            if (!((String)object).startsWith("\"") && !((String)object).endsWith("\"")) {
                Notifier.error("profile.14", (String)object);
                System.exit(1);
            }
            if (!bl) {
                bl = true;
                vector2.addElement((String)object);
                continue;
            }
            bl = false;
            vector2.setElementAt(vector2.lastElement() + " " + (String)object, vector2.indexOf(vector2.lastElement()));
        }
        for (n = 0; n < vector2.size(); ++n) {
            if (vector2.elementAt(n).indexOf("\"") == -1) continue;
            object = new StringTokenizer(vector2.elementAt(n), "\"");
            String string = "";
            while (((StringTokenizer)object).hasMoreElements()) {
                string = string + ((StringTokenizer)object).nextToken();
            }
            vector2.setElementAt(string, n);
        }
        return vector2;
    }

    private void parseOptionsFromFile(String[] stringArray) {
        String string = stringArray[1];
        Vector<String> vector = new Vector<String>();
        try {
            int n = 1;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                n += string2.length();
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            BufferedReader bufferedReader2 = new BufferedReader(new FileReader(string));
            boolean bl = false;
            char[] cArray = new char[n];
            char[] cArray2 = null;
            int n2 = 0;
            String string3 = bufferedReader2.readLine();
            while (string3 != null) {
                block10: for (char c : cArray2 = string3.toCharArray()) {
                    switch (c) {
                        case ' ': {
                            if (bl) {
                                cArray[n2++] = c;
                                continue block10;
                            }
                            if (n2 <= 0) continue block10;
                            vector.addElement(new String(cArray, 0, n2));
                            cArray = new char[n];
                            n2 = 0;
                            continue block10;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': {
                            if (bl || n2 <= 0) continue block10;
                            vector.addElement(new String(cArray, 0, n2));
                            cArray = new char[n];
                            n2 = 0;
                            continue block10;
                        }
                        case '\"': {
                            bl = !bl;
                            continue block10;
                        }
                        default: {
                            cArray[n2++] = c;
                        }
                    }
                }
                string3 = bufferedReader2.readLine();
                if (bl || n2 <= 0) continue;
                vector.addElement(new String(cArray, 0, n2));
                cArray = new char[n];
                n2 = 0;
            }
            if (n2 > 0) {
                vector.addElement(new String(cArray, 0, n2));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Notifier.error("converter.0", string);
            OptionParser.usage();
            System.exit(1);
        }
        catch (IOException iOException) {
            Notifier.error("converter.1", string);
            OptionParser.usage();
            System.exit(1);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        this.parseOptionsFromCommandLine((String[])objectArray);
    }

    private void parseOptionsFromCommandLine(String[] stringArray) {
        Vector<AppletProfile> vector = new Vector<AppletProfile>();
        block6: for (int i = 0; i < stringArray.length; ++i) {
            byte[] byArray;
            Object object;
            if (stringArray[i].equals("-i")) {
                this.cp.int_supported = true;
                continue;
            }
            if (stringArray[i].equals("-classdir")) {
                this.cp.class_root = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-exportpath")) {
                this.cp.export_path = Strings.toStrings(stringArray[++i], File.pathSeparator);
                continue;
            }
            if (stringArray[i].equals("-exportmap")) {
                this.cp.this_exp_provided = true;
                continue;
            }
            if (stringArray[i].equals("-applet")) {
                object = new AppletProfile();
                byArray = null;
                try {
                    byArray = Strings.toByteArray(stringArray[++i], ":");
                }
                catch (Exception exception) {
                    Notifier.error("profile.4", stringArray[i]);
                    OptionParser.usage();
                    System.exit(1);
                }
                if (byArray.length > 16 || byArray.length < 5) {
                    Notifier.error("profile.1", stringArray[i]);
                    OptionParser.usage();
                    System.exit(1);
                }
                ((AppletProfile)object).aid = byArray;
                ((AppletProfile)object).install_class = stringArray[++i].replace('.', '/');
                vector.addElement((AppletProfile)object);
                continue;
            }
            if (stringArray[i].equals("-out")) {
                while (true) {
                    if (stringArray[i + 1].equals("JCA")) {
                        this.cp.output |= 4;
                        this.cp.deleteJCA = false;
                        ++i;
                        continue;
                    }
                    if (stringArray[i + 1].equals("CAP")) {
                        this.cp.output |= 1;
                        this.cp.output |= 4;
                        ++i;
                        continue;
                    }
                    if (stringArray[i + 1].equals("EXP")) {
                        this.cp.output |= 2;
                        ++i;
                        continue;
                    }
                    if (!stringArray[i + 1].equals("NORMALIZED_CAP")) continue block6;
                    this.cp.output = 8;
                    this.cp.output |= 1;
                    this.cp.output |= 4;
                    ++i;
                }
            }
            if (stringArray[i].equals("-d")) {
                this.cp.output_dir = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-keepproxysource")) {
                this.cp.keepDir = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-verbose")) {
                Notifier.setVerboseFlag(true);
                continue;
            }
            if (stringArray[i].equals("-v")) {
                Notifier.setVerboseFlag(true);
                continue;
            }
            if (stringArray[i].equals("-noverify")) {
                this.cp.noVerify = true;
                continue;
            }
            if (stringArray[i].equals("-version")) {
                Notifier.outPrintLn(ToolsVersion.getToolName(1) + ToolsVersion.getVersion(1));
                Notifier.outPrintLn(ToolsVersion.getCopyrightBanner());
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-V")) {
                Notifier.outPrintLn(ToolsVersion.getToolName(1) + ToolsVersion.getVersion(1));
                Notifier.outPrintLn(ToolsVersion.getCopyrightBanner());
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-help")) {
                OptionParser.usage();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-debug")) {
                this.cp.debug = true;
                continue;
            }
            if (stringArray[i].equals("-mask")) {
                this.cp.mask = true;
                continue;
            }
            if (stringArray[i].equals("-nowarn")) {
                Notifier.setNoWarningFlag(true);
                continue;
            }
            if (stringArray[i].equals("-nobanner")) {
                Notifier.setNoBannerFlag(true);
                continue;
            }
            if (stringArray[i].equals("-sign")) {
                this.cp.sign = true;
                continue;
            }
            if (stringArray[i].equals("-keystore")) {
                this.cp.keystore = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-storepass")) {
                this.cp.storepass = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-alias")) {
                this.cp.alias = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-passkey")) {
                this.cp.passkey = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-inputcap")) {
                this.cp.inputCapName = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-useproxyclass")) {
                this.cp.useProxyClass = true;
                continue;
            }
            if (stringArray[i].equals("-usecapcomponents")) {
                this.cp.useCapComponents = true;
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                Notifier.error("profile.0", stringArray[i]);
                OptionParser.usage();
                System.exit(1);
            }
            this.cp.package_profile = new PackageProfile();
            this.cp.package_profile.package_name = stringArray[i].replace('.', '/');
            object = null;
            try {
                object = Strings.toByteArray(stringArray[++i], ":");
            }
            catch (Exception exception) {
                Notifier.error("profile.4", stringArray[i]);
                OptionParser.usage();
                System.exit(1);
            }
            if (((Object)object).length < 5 || ((Object)object).length > 16) {
                Notifier.error("profile.1", stringArray[i]);
                OptionParser.usage();
                System.exit(1);
            }
            this.cp.package_profile.aid = (byte[])object;
            byArray = null;
            try {
                byArray = Strings.toByteArray(stringArray[++i], ".");
            }
            catch (Exception exception) {
                Notifier.error("profile.2", stringArray[i]);
                OptionParser.usage();
                System.exit(1);
            }
            if (byArray.length != 2) {
                Notifier.error("profile.2", stringArray[i]);
                OptionParser.usage();
                System.exit(1);
            }
            this.cp.package_profile.major_version = byArray[0];
            this.cp.package_profile.minor_version = byArray[1];
        }
        this.cp.applets_profile = new AppletProfile[vector.size()];
        vector.copyInto(this.cp.applets_profile);
    }

    public static void usage() {
        for (int i = 0; i < 46; ++i) {
            Notifier.out("allusage." + i);
        }
    }

    private void checkOptions() {
        try {
            Object object;
            if (this.cp.package_profile == null) {
                OptionParser.usage();
                System.exit(1);
            }
            if (this.cp.class_root == null) {
                this.cp.class_root = new String(System.getProperty("user.dir"));
            }
            this.enumerateClasses();
            if (this.cp.output == 0) {
                this.cp.output |= 1;
                this.cp.output |= 2;
                this.cp.output |= 4;
            }
            if (this.cp.output_dir == null) {
                this.cp.output_dir = this.cp.class_root;
            }
            if (this.cp.export_path == null) {
                object = System.getProperty("java.class.path");
                this.cp.export_path = Strings.toStrings((String)object, File.pathSeparator);
            }
            if (this.cp.applets_profile == null) {
                this.cp.applets_profile = new AppletProfile[0];
            }
            if (this.cp.mask && (this.cp.output & 1) != 0) {
                Notifier.error("profile.7");
                System.exit(1);
            }
            if (this.cp.keepDir != null && ((File)(object = new File(this.cp.keepDir))).exists() && ((File)object).isFile()) {
                Notifier.error("converter.14", this.cp.keepDir);
                throw new ConverterException();
            }
        }
        catch (Exception exception) {
            OptionParser.usage();
            System.exit(1);
        }
    }

    private void enumerateClasses() {
        File file;
        String string = this.cp.package_profile.package_name.replace('/', File.separatorChar);
        File file2 = new File(this.cp.class_root);
        if (!file2.exists()) {
            Notifier.error("profile.3", this.cp.class_root);
            OptionParser.usage();
            System.exit(1);
        }
        if (!(file = new File(file2, string)).exists()) {
            if (File.separatorChar == '\\' && this.cp.class_root.endsWith("\\")) {
                Notifier.error("profile.5", this.cp.class_root + string);
            } else {
                Notifier.error("profile.5", this.cp.class_root + File.separatorChar + string);
            }
            OptionParser.usage();
            System.exit(1);
        }
        Object[] objectArray = file.list(new ClassFileNameFilter());
        Arrays.sort(objectArray);
        if (objectArray == null) {
            Notifier.error("profile.6");
            OptionParser.usage();
            System.exit(1);
        }
        this.cp.classes = new File[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.cp.classes[i] = new File(file, (String)objectArray[i]);
        }
    }
}

