/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.antlr;

import org.netbeans.modules.cnd.antlr.RecognitionException;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.antlr.collections.impl.BitSet;

public class MismatchedTokenException
extends RecognitionException {
    String[] tokenNames;
    public Token token;
    public AST node;
    String tokenText = null;
    public static final int TOKEN = 1;
    public static final int NOT_TOKEN = 2;
    public static final int RANGE = 3;
    public static final int NOT_RANGE = 4;
    public static final int SET = 5;
    public static final int NOT_SET = 6;
    public int mismatchType;
    public int expecting;
    public int upper;
    public BitSet set;

    public MismatchedTokenException() {
        super("Mismatched Token: expecting any AST node", "<AST>", -1, -1);
    }

    public MismatchedTokenException(String[] tokenNames_, AST node_, int lower, int upper_, boolean matchNot) {
        super("Mismatched Token", "<AST>", node_ == null ? -1 : node_.getLine(), node_ == null ? -1 : node_.getColumn());
        this.tokenNames = tokenNames_;
        this.node = node_;
        this.tokenText = node_ == null ? "<empty tree>" : node_.toString();
        this.mismatchType = matchNot ? 4 : 3;
        this.expecting = lower;
        this.upper = upper_;
    }

    public MismatchedTokenException(String[] tokenNames_, AST node_, int expecting_, boolean matchNot) {
        super("Mismatched Token", "<AST>", node_ == null ? -1 : node_.getLine(), node_ == null ? -1 : node_.getColumn());
        this.tokenNames = tokenNames_;
        this.node = node_;
        this.tokenText = node_ == null ? "<empty tree>" : node_.toString();
        this.mismatchType = matchNot ? 2 : 1;
        this.expecting = expecting_;
    }

    public MismatchedTokenException(String[] tokenNames_, AST node_, BitSet set_, boolean matchNot) {
        super("Mismatched Token", "<AST>", node_ == null ? -1 : node_.getLine(), node_ == null ? -1 : node_.getColumn());
        this.tokenNames = tokenNames_;
        this.node = node_;
        this.tokenText = node_ == null ? "<empty tree>" : node_.toString();
        this.mismatchType = matchNot ? 6 : 5;
        this.set = set_;
    }

    public MismatchedTokenException(String[] tokenNames_, Token token_, int lower, int upper_, boolean matchNot, String fileName_) {
        super("Mismatched Token", fileName_, token_.getLine(), token_.getColumn());
        this.tokenNames = tokenNames_;
        this.token = token_;
        this.tokenText = token_.getText();
        this.mismatchType = matchNot ? 4 : 3;
        this.expecting = lower;
        this.upper = upper_;
    }

    public MismatchedTokenException(String[] tokenNames_, Token token_, int expecting_, boolean matchNot, String fileName_) {
        super("Mismatched Token", fileName_, token_.getLine(), token_.getColumn());
        this.tokenNames = tokenNames_;
        this.token = token_;
        this.tokenText = token_.getText();
        this.mismatchType = matchNot ? 2 : 1;
        this.expecting = expecting_;
    }

    public MismatchedTokenException(String[] tokenNames_, Token token_, BitSet set_, boolean matchNot, String fileName_) {
        super("Mismatched Token", fileName_, token_.getLine(), token_.getColumn());
        this.tokenNames = tokenNames_;
        this.token = token_;
        this.tokenText = token_.getText();
        this.mismatchType = matchNot ? 6 : 5;
        this.set = set_;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        switch (this.mismatchType) {
            case 1: {
                sb.append("expecting " + this.tokenName(this.expecting) + ", found '" + this.tokenText + "'");
                break;
            }
            case 2: {
                sb.append("expecting anything but " + this.tokenName(this.expecting) + "; got it anyway");
                break;
            }
            case 3: {
                sb.append("expecting token in range: " + this.tokenName(this.expecting) + ".." + this.tokenName(this.upper) + ", found '" + this.tokenText + "'");
                break;
            }
            case 4: {
                sb.append("expecting token NOT in range: " + this.tokenName(this.expecting) + ".." + this.tokenName(this.upper) + ", found '" + this.tokenText + "'");
                break;
            }
            case 5: 
            case 6: {
                sb.append("expecting " + (this.mismatchType == 6 ? "NOT " : "") + "one of (");
                int[] elems = this.set.toArray();
                for (int i = 0; i < elems.length; ++i) {
                    sb.append(" ");
                    sb.append(this.tokenName(elems[i]));
                }
                sb.append("), found '" + this.tokenText + "'");
                break;
            }
            default: {
                sb.append(super.getMessage());
            }
        }
        return sb.toString();
    }

    private String tokenName(int tokenType) {
        return MismatchedTokenException.tokenName(this.tokenNames, tokenType);
    }

    public static String tokenName(String[] tokenNames, int tokenType) {
        if (tokenType == 0) {
            return "<Set of tokens>";
        }
        if (tokenType < 0 || tokenType >= tokenNames.length) {
            return "<" + String.valueOf(tokenType) + ">";
        }
        return tokenNames[tokenType];
    }

    @Override
    public String getTokenText() {
        return this.tokenText;
    }
}

