/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProvider;
import org.netbeans.modules.cnd.remote.mapper.SimpleConfigParser;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;

final class HostMappingProviderSamba
implements HostMappingProvider {
    private static final String GLOBAL = "global";
    private static final String PATH = "path";

    HostMappingProviderSamba() {
    }

    @Override
    public Map<String, String> findMappings(ExecutionEnvironment execEnv, ExecutionEnvironment otherExecEnv) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        ProcessUtils.ExitStatus exit = ProcessUtils.execute((ExecutionEnvironment)execEnv, (String)"cat", (String[])new String[]{"/etc/sfw/smb.conf"});
        if (exit.isOK()) {
            mappings.putAll(HostMappingProviderSamba.parseOutput(new StringReader(exit.getOutputString())));
        }
        return mappings;
    }

    @Override
    public boolean isApplicable(PlatformInfo hostPlatform, PlatformInfo otherPlatform) {
        return otherPlatform.isWindows() && hostPlatform.isUnix();
    }

    static Map<String, String> parseOutput(Reader outputReader) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        SimpleConfigParser parser = new SimpleConfigParser();
        parser.parse(outputReader);
        for (String name : parser.getSections()) {
            String path;
            if (GLOBAL.equals(name) || (path = parser.getAttributes(name).get(PATH)) == null) continue;
            mappings.put(name, path);
        }
        return mappings;
    }
}

