/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.nodes;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.JBRemoteAction;
import org.netbeans.modules.j2ee.jboss4.JBoss5ProfileServiceProxy;
import org.netbeans.modules.j2ee.jboss4.nodes.JBAbilitiesSupport;
import org.netbeans.modules.j2ee.jboss4.nodes.JBAsyncChildren;
import org.netbeans.modules.j2ee.jboss4.nodes.JBEarApplicationNode;
import org.netbeans.modules.j2ee.jboss4.nodes.Util;
import org.netbeans.modules.j2ee.jboss4.nodes.actions.Refreshable;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class JBEarApplicationsChildren
extends JBAsyncChildren
implements Refreshable {
    private static final Logger LOGGER = Logger.getLogger(JBEarApplicationsChildren.class.getName());
    private final JBAbilitiesSupport abilitiesSupport;
    private final Lookup lookup;

    JBEarApplicationsChildren(Lookup lookup) {
        this.lookup = lookup;
        this.abilitiesSupport = new JBAbilitiesSupport(lookup);
    }

    @Override
    public void updateKeys() {
        this.setKeys(new Object[]{"wait_node"});
        this.getExecutorService().submit(this.abilitiesSupport.isJB7x() ? new JBoss7EarApplicationNodeUpdater() : new JBossEarApplicationNodeUpdater(), 0);
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof JBEarApplicationNode) {
            return new Node[]{(JBEarApplicationNode)((Object)key)};
        }
        if (key instanceof String && key.equals("wait_node")) {
            return new Node[]{Util.createWaitNode()};
        }
        return null;
    }

    class JBoss7EarApplicationNodeUpdater
    implements Runnable {
        List keys = new ArrayList();

        JBoss7EarApplicationNodeUpdater() {
        }

        @Override
        public void run() {
            try {
                final JBDeploymentManager dm = (JBDeploymentManager)JBEarApplicationsChildren.this.lookup.lookup(JBDeploymentManager.class);
                dm.invokeLocalAction(new Callable<Void>(){

                    @Override
                    public Void call() {
                        try {
                            Target[] targets = dm.getTargets();
                            ModuleType moduleType = ModuleType.EAR;
                            TargetModuleID[] modules = dm.getAvailableModules(moduleType, targets);
                            if (modules != null) {
                                for (int intModule = 0; intModule < modules.length; ++intModule) {
                                    JBoss7EarApplicationNodeUpdater.this.keys.add(new JBEarApplicationNode(modules[intModule].getModuleID(), JBEarApplicationsChildren.this.lookup));
                                }
                            }
                        }
                        catch (TargetException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (IllegalStateException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            JBEarApplicationsChildren.this.setKeys(this.keys);
        }
    }

    class JBossEarApplicationNodeUpdater
    implements Runnable {
        List keys = new ArrayList();

        JBossEarApplicationNodeUpdater() {
        }

        @Override
        public void run() {
            try {
                ((JBDeploymentManager)JBEarApplicationsChildren.this.lookup.lookup(JBDeploymentManager.class)).invokeRemoteAction(new JBRemoteAction<Void>(){

                    @Override
                    public Void action(MBeanServerConnection connection, JBoss5ProfileServiceProxy profileService) throws Exception {
                        String propertyName;
                        ObjectName searchPattern;
                        if (JBEarApplicationsChildren.this.abilitiesSupport.isRemoteManagementSupported() && (JBEarApplicationsChildren.this.abilitiesSupport.isJB4x() || JBEarApplicationsChildren.this.abilitiesSupport.isJB6x())) {
                            searchPattern = new ObjectName("jboss.management.local:j2eeType=J2EEApplication,*");
                            propertyName = "name";
                        } else {
                            searchPattern = new ObjectName("jboss.j2ee:service=EARDeployment,*");
                            propertyName = "url";
                        }
                        Method method = connection.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class);
                        method = Util.fixJava4071957(method);
                        Set managedObj = (Set)method.invoke((Object)connection, searchPattern, null);
                        Iterator it = managedObj.iterator();
                        while (it.hasNext()) {
                            try {
                                ObjectName elem = ((ObjectInstance)it.next()).getObjectName();
                                String name = elem.getKeyProperty(propertyName);
                                if (JBEarApplicationsChildren.this.abilitiesSupport.isRemoteManagementSupported() && (JBEarApplicationsChildren.this.abilitiesSupport.isJB4x() || JBEarApplicationsChildren.this.abilitiesSupport.isJB6x())) {
                                    if (name.endsWith(".sar") || name.endsWith(".deployer")) {
                                        continue;
                                    }
                                } else {
                                    name = name.substring(1, name.length() - 1);
                                }
                                JBossEarApplicationNodeUpdater.this.keys.add(new JBEarApplicationNode(name, JBEarApplicationsChildren.this.lookup));
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.INFO, null, ex);
                            }
                        }
                        return null;
                    }
                });
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            JBEarApplicationsChildren.this.setKeys(this.keys);
        }
    }
}

