/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.impl.services.UIDFilter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;

public class LazyCsmCollection<Tuid, Tfact extends Tuid>
implements Collection<Tfact> {
    private final Collection<CsmUID<Tuid>> uids;
    private final boolean allowNullsAndSkip;

    public LazyCsmCollection(Collection<CsmUID<Tuid>> uids, boolean allowNullsAndSkip) {
        this.uids = uids;
        this.allowNullsAndSkip = allowNullsAndSkip;
    }

    private Tfact convertToObject(CsmUID<? extends Tfact> uid) {
        return UIDCsmConverter.UIDtoCsmObject(uid);
    }

    @Override
    public int size() {
        return this.uids.size();
    }

    @Override
    public boolean isEmpty() {
        return this.uids.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        for (Tfact object : this) {
            if (o != object && (o == null || !o.equals(object))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Tfact> iterator() {
        return this.allowNullsAndSkip ? new MySafeIterator() : new MyIterator();
    }

    public Iterator<Tfact> iterator(CsmSelect.CsmFilter filter) {
        return new MySafeIterator(filter);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        Iterator<Tfact> e = this.iterator();
        int i = 0;
        while (e.hasNext()) {
            result[i] = e.next();
            ++i;
        }
        if (i < this.size()) {
            Object[] a = new Object[i];
            System.arraycopy(result, 0, a, 0, i);
            result = a;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator<Tfact> it = this.iterator();
        T[] result = a;
        int i = 0;
        while (it.hasNext()) {
            result[i] = it.next();
            ++i;
        }
        if (i < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), i);
            System.arraycopy(result, 0, a, 0, i);
        }
        return a;
    }

    @Override
    public boolean add(Tfact o) {
        return this.uids.add(UIDs.get(o));
    }

    @Override
    public boolean remove(Object o) {
        return this.uids.remove(UIDs.get((Object)o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Tfact> c) {
        boolean modified = false;
        if (c instanceof LazyCsmCollection) {
            LazyCsmCollection col = (LazyCsmCollection)c;
            return this.uids.addAll(col.uids);
        }
        Iterator<Tfact> it = c.iterator();
        while (it.hasNext()) {
            if (!this.add(it.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<Tfact> it = this.iterator();
        while (it.hasNext()) {
            if (!c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<Tfact> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.uids.clear();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        Iterator<Tfact> it = this.iterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Tfact o = it.next();
            buf.append(o == this ? "(this Collection)" : String.valueOf(o));
            hasNext = it.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    private class MySafeIterator
    implements Iterator<Tfact> {
        private final Iterator<CsmUID<Tuid>> it;
        private Tfact next;
        private final CsmSelect.CsmFilter filter;

        private MySafeIterator() {
            this((CsmSelect.CsmFilter)null);
        }

        private MySafeIterator(CsmSelect.CsmFilter filter) {
            this.filter = filter;
            this.it = LazyCsmCollection.this.uids.iterator();
            this.next = this.getNextNonNull();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        private Tfact getNextNonNull() {
            Object out = null;
            while (out == null && this.it.hasNext()) {
                CsmUID uid = this.it.next();
                if (uid == null || this.filter != null && !((UIDFilter)this.filter).accept(uid)) continue;
                out = LazyCsmCollection.this.convertToObject(uid);
            }
            return out;
        }

        @Override
        public Tfact next() {
            Object decl = this.next;
            this.next = this.getNextNonNull();
            return decl;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    private class MyIterator
    implements Iterator<Tfact> {
        private final Iterator<CsmUID<Tuid>> it;

        private MyIterator() {
            this.it = LazyCsmCollection.this.uids.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Tfact next() {
            CsmUID uid = this.it.next();
            Object decl = LazyCsmCollection.this.convertToObject(uid);
            assert (decl != null) : "no object for UID " + uid;
            return decl;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

