/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.openide.filesystems.FileSystem;

public class Context {
    public static final Context Empty = new Context(Context.getEmptyList(), Context.getEmptyList(), Context.getEmptyList());
    private static final long serialVersionUID = 1L;
    private final List<VCSFileProxy> filteredFiles;
    private final List<VCSFileProxy> rootFiles;
    private final List<VCSFileProxy> exclusions;

    public Context(List<VCSFileProxy> filteredFiles, List<VCSFileProxy> rootFiles, List<VCSFileProxy> exclusions) {
        this.filteredFiles = filteredFiles;
        this.rootFiles = rootFiles;
        this.exclusions = exclusions;
        while (this.normalize()) {
        }
    }

    public Context(VCSFileProxy file) {
        this(new VCSFileProxy[]{file});
    }

    public Context(VCSFileProxy[] files) {
        ArrayList<VCSFileProxy> list = new ArrayList<VCSFileProxy>(files.length);
        list.addAll(Arrays.asList(files));
        this.removeDuplicates(list);
        this.filteredFiles = list;
        this.rootFiles = list;
        this.exclusions = Collections.emptyList();
    }

    public FileSystem getFileSystem() {
        Iterator<VCSFileProxy> iterator = this.rootFiles.iterator();
        if (iterator.hasNext()) {
            VCSFileProxy root = iterator.next();
            return VCSFileProxySupport.getFileSystem((VCSFileProxy)root);
        }
        return null;
    }

    public VCSFileProxy getTopFolder() {
        Iterator<VCSFileProxy> iterator = this.rootFiles.iterator();
        if (iterator.hasNext()) {
            VCSFileProxy root = iterator.next();
            return Subversion.getInstance().getTopmostManagedAncestor(root);
        }
        return null;
    }

    private boolean normalize() {
        for (VCSFileProxy root : this.rootFiles) {
            Iterator<VCSFileProxy> j = this.exclusions.iterator();
            while (j.hasNext()) {
                VCSFileProxy exclusion = j.next();
                if (!VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)exclusion, (VCSFileProxy)root)) continue;
                j.remove();
                this.exclusionRemoved(exclusion, root);
                return true;
            }
        }
        this.removeDuplicates(this.rootFiles);
        this.removeDuplicates(this.exclusions);
        return false;
    }

    private void removeDuplicates(List<VCSFileProxy> files) {
        ArrayList<VCSFileProxy> newFiles = new ArrayList<VCSFileProxy>();
        block0: for (VCSFileProxy file : files) {
            Iterator j = newFiles.iterator();
            while (j.hasNext()) {
                VCSFileProxy includedFile = (VCSFileProxy)j.next();
                if (VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)includedFile, (VCSFileProxy)file) && (file.isFile() || !VersioningSupport.isFlat((VCSFileProxy)includedFile))) continue block0;
                if (!VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)file, (VCSFileProxy)includedFile) || !includedFile.isFile() && VersioningSupport.isFlat((VCSFileProxy)file)) continue;
                j.remove();
            }
            newFiles.add(file);
        }
        files.clear();
        files.addAll(newFiles);
    }

    private void exclusionRemoved(VCSFileProxy exclusion, VCSFileProxy root) {
        VCSFileProxy[] exclusionChildren = exclusion.listFiles();
        if (exclusionChildren == null) {
            return;
        }
        for (int i = 0; i < exclusionChildren.length; ++i) {
            VCSFileProxy child = exclusionChildren[i];
            if (VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)root, (VCSFileProxy)child)) continue;
            this.exclusions.add(child);
        }
    }

    public List<VCSFileProxy> getRoots() {
        return this.rootFiles;
    }

    public List<VCSFileProxy> getExclusions() {
        return this.exclusions;
    }

    public VCSFileProxy[] getFiles() {
        return this.filteredFiles.toArray(new VCSFileProxy[this.filteredFiles.size()]);
    }

    public VCSFileProxy[] getRootFiles() {
        return this.rootFiles.toArray(new VCSFileProxy[this.rootFiles.size()]);
    }

    public boolean contains(VCSFileProxy file) {
        block0: for (VCSFileProxy root : this.rootFiles) {
            if (!SvnUtils.isParentOrEqual(root, file)) continue;
            for (VCSFileProxy excluded : this.exclusions) {
                if (!VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)excluded, (VCSFileProxy)file)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    public static final List<VCSFileProxy> getEmptyList() {
        return Collections.emptyList();
    }

    public void writeObject(ObjectOutput out) throws IOException {
        URI uri;
        out.writeInt(this.rootFiles.size());
        for (VCSFileProxy root : this.rootFiles) {
            uri = VCSFileProxySupport.toURI((VCSFileProxy)root);
            out.writeObject(uri);
        }
        out.writeInt(this.filteredFiles.size());
        for (VCSFileProxy root : this.filteredFiles) {
            uri = VCSFileProxySupport.toURI((VCSFileProxy)root);
            out.writeObject(uri);
        }
        out.writeInt(this.exclusions.size());
        for (VCSFileProxy root : this.exclusions) {
            uri = VCSFileProxySupport.toURI((VCSFileProxy)root);
            out.writeObject(uri);
        }
    }

    public Context(ObjectInput in) throws IOException, ClassNotFoundException {
        VCSFileProxy root;
        URI uri;
        int i;
        int size = in.readInt();
        this.rootFiles = new ArrayList<VCSFileProxy>(size);
        for (i = 0; i < size; ++i) {
            uri = (URI)in.readObject();
            root = VCSFileProxySupport.fromURI((URI)uri);
            if (root == null) continue;
            this.rootFiles.add(root);
        }
        size = in.readInt();
        this.filteredFiles = new ArrayList<VCSFileProxy>(size);
        for (i = 0; i < size; ++i) {
            uri = (URI)in.readObject();
            root = VCSFileProxySupport.fromURI((URI)uri);
            if (root == null) continue;
            this.filteredFiles.add(root);
        }
        size = in.readInt();
        this.exclusions = new ArrayList<VCSFileProxy>(size);
        for (i = 0; i < size; ++i) {
            uri = (URI)in.readObject();
            root = VCSFileProxySupport.fromURI((URI)uri);
            if (root == null) continue;
            this.exclusions.add(root);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (VCSFileProxy root : this.rootFiles) {
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(root.getPath());
        }
        return buf.toString();
    }
}

