/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.copy;

import java.util.concurrent.Callable;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.RepositoryFile;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.ISVNLogMessage;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.copy.Merge;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.nodes.Node;

public class MergeAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Merge";
    }

    @Override
    protected int getFileEnabledStatus() {
        return -8;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return nodes != null && nodes.length == 1 && this.isCacheReady() && this.getCachedContext(nodes).getRoots().size() > 0;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        SVNUrl url;
        SVNUrl rootUrl;
        Context ctx = this.getContext(nodes);
        if (!Subversion.getInstance().checkClientAvailable(ctx)) {
            return;
        }
        final VCSFileProxy[] roots = SvnUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        VCSFileProxy interestingFile = roots.length == 1 ? roots[0] : SvnUtils.getPrimaryFile(roots[0]);
        try {
            rootUrl = ContextAction.getSvnUrl(ctx);
            if (rootUrl == null) {
                SvnClientExceptionHandler.notifyNullUrl(ctx);
                return;
            }
            url = SvnUtils.getRepositoryUrl(interestingFile);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
            return;
        }
        final RepositoryFile repositoryRoot = new RepositoryFile(ctx.getFileSystem(), rootUrl, url, SVNRevision.HEAD);
        final Merge merge = new Merge(repositoryRoot, interestingFile);
        if (merge.showDialog()) {
            ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes, ctx){

                @Override
                public void perform() {
                    for (VCSFileProxy root : roots) {
                        MergeAction.this.performMerge(merge, repositoryRoot, root, this, roots.length > 1);
                    }
                }
            };
            support.start(this.createRequestProcessor(ctx));
        }
    }

    private void performMerge(final Merge merge, RepositoryFile repositoryRoot, final VCSFileProxy file, SvnProgressSupport support, boolean partOfMultiFile) {
        VCSFileProxy[][] split = VCSFileProxySupport.splitFlatOthers((VCSFileProxy[])new VCSFileProxy[]{file});
        final boolean recursive = split[0].length <= 0;
        try {
            SVNRevision startRevision;
            SVNUrl startUrl;
            SvnClient client;
            Context context = new Context(file);
            try {
                client = Subversion.getInstance().getClient(context, repositoryRoot.getRepositoryUrl());
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException(context, ex, true, true);
                return;
            }
            if (support.isCanceled()) {
                return;
            }
            SVNUrl endUrl = merge.getMergeEndRepositoryFile().getFileUrl();
            final SVNRevision endRevision = merge.getMergeEndRevision();
            RepositoryFile mergeStartRepositoryFile = merge.getMergeStartRepositoryFile();
            SVNUrl sVNUrl = startUrl = mergeStartRepositoryFile != null ? mergeStartRepositoryFile.getFileUrl() : null;
            if (file.isFile() && partOfMultiFile) {
                endUrl = merge.getMergeEndRepositoryFile().replaceLastSegment(file.getName(), 0).getFileUrl();
                SVNUrl sVNUrl2 = startUrl = mergeStartRepositoryFile != null ? mergeStartRepositoryFile.replaceLastSegment(file.getName(), 0).getFileUrl() : null;
            }
            if (startUrl != null) {
                startRevision = merge.getMergeStartRevision();
                if (merge.isStartRevisionIncluded()) {
                    if (startRevision.getKind() == SVNRevision.Kind.number) {
                        startRevision = new SVNRevision.Number(((SVNRevision.Number)startRevision).getNumber() - 1L);
                    } else {
                        ISVNInfo info = client.getInfo(context, startUrl, startRevision, startRevision);
                        if (info != null) {
                            startRevision = new SVNRevision.Number(info.getRevision().getNumber() - 1L);
                        }
                    }
                }
            } else {
                startUrl = endUrl;
                ISVNLogMessage[] log = client.getLogMessages(startUrl, null, new SVNRevision.Number(0L), SVNRevision.HEAD, true, false, 0L);
                startRevision = log[0].getRevision();
            }
            if (support.isCanceled()) {
                return;
            }
            final SVNUrl fStartUrl = startUrl;
            final SVNUrl fEndUrl = endUrl;
            final SVNRevision fStartRevision = startRevision;
            SvnUtils.runWithoutIndexing(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (endRevision == null) {
                        client.mergeReintegrate(fEndUrl, SVNRevision.HEAD, file, false, false);
                    } else {
                        client.merge(fStartUrl, fStartRevision, fEndUrl, endRevision, file, false, recursive, false, merge.isIgnoreAncestry());
                    }
                    return null;
                }
            }, file);
        }
        catch (SVNClientException ex) {
            support.annotate(ex);
        }
    }
}

